<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{	
	public $defaultCaptcha = 'RBooking_Captcha';
	
	public $defaultLocale = 'RBooking_LocaleId';
	
	public $defaultStore = 'RBooking_Store';
	
	public $firstLoad = 'RBooking_FirstLoad';
	
	public $defaultForm = 'RBooking_Form';
	
	public $defaultVoucher = 'RBooking_Voucher';
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
		
		self::allowCORS();
	}
	
	private function _get($key)
	{
		if ($this->_is($key))
		{
			return $_SESSION[$this->defaultStore][$key];
		}
		return false;
	}
	
	private function _is($key)
	{
		return isset($_SESSION[$this->defaultStore]) && isset($_SESSION[$this->defaultStore][$key]);
	}
	
	private function _set($key, $value)
	{
		$_SESSION[$this->defaultStore][$key] = $value;
		return $this;
	}

	public function afterFilter()
	{		
		if (!isset($_GET['hide']) || (isset($_GET['hide']) && (int) $_GET['hide'] !== 1) &&
			in_array($_GET['action'], array('pjActionSearch', 'pjActionCheckout', 'pjActionPreview', 'pjActionGetPaymentForm')))
		{
			$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file, t2.title')
				->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
				->where('t2.file IS NOT NULL')
				->orderBy('t1.sort ASC')->findAll()->getData();
			
			$this->set('locale_arr', $locale_arr);
		}
	}
	
	public function beforeFilter()
	{
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();

		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		if(isset($_GET['locale']) && (int) $_GET['locale'] > 0 && !isset($_SESSION[$this->defaultLocale]))
		{
			$_SESSION[$this->defaultLocale] = (int) $_GET['locale'];
		}
		
		if (!in_array($_GET['action'], array('pjActionLoadCss')))
		{
			if(isset($_GET['locale']) && (int) $_GET['locale'] > 0 && $_GET['action'] == 'pjActionLoad')
			{
				$this->pjActionSetLocale((int) $_GET['locale']);
				$this->loadSetFields(true);
			}else{
				$this->loadSetFields();
			}
		}
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		header("Cache-Control: max-age=3600, private");
		$Captcha = new pjCaptcha('app/web/obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		$Captcha->setImage('app/web/img/button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : rand(1, 9999));
		exit;
	}

	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
		exit;
	}
	public function pjActionLocale()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['locale_id']))
			{
				$this->pjActionSetLocale($_GET['locale_id']);
				$this->loadSetFields(true);
			}
		}
		exit;
	}
	private function pjActionSetLocale($locale)
	{
		if ((int) $locale > 0)
		{
			$_SESSION[$this->defaultLocale] = (int) $locale;
		}
		return $this;
	}
	
	public function pjActionGetLocale()
	{
		return isset($_SESSION[$this->defaultLocale]) && (int) $_SESSION[$this->defaultLocale] > 0 ? (int) $_SESSION[$this->defaultLocale] : FALSE;
	}
	
	public function pjActionLoadCss()
	{
		$dm = new pjDependencyManager(PJ_THIRD_PARTY_PATH);
		$dm->load(PJ_CONFIG_PATH . 'dependencies.php')->resolve();
	
		$theme = $this->option_arr['o_theme'];
		$fonts = $this->option_arr['o_theme'];
		if(isset($_GET['theme']) && in_array($_GET['theme'], array('theme1', 'theme2', 'theme3', 'theme4', 'theme5', 'theme6', 'theme7', 'theme8', 'theme9', 'theme10')))
		{
			$theme = $_GET['theme'];
			$fonts = $_GET['theme'];
		}
		$arr = array(
				array('file' => 'bootstrap-datetimepicker.min.css', 'path' => $dm->getPath('pj_bootstrap_datetimepicker')),
				array('file' => 'style.css', 'path' => PJ_CSS_PATH),
				array('file' => "$fonts.css", 'path' => PJ_CSS_PATH . "fonts/"),
				array('file' => "$theme.css", 'path' => PJ_CSS_PATH . "themes/"),
				array('file' => 'transitions.css', 'path' => PJ_CSS_PATH)
		);
		header("Content-Type: text/css; charset=utf-8");
		foreach ($arr as $item)
		{
			ob_start();
			@readfile($item['path'] . $item['file']);
			$string = ob_get_contents();
			ob_end_clean();
				
			if ($string !== FALSE)
			{
				echo str_replace(
						array('../fonts/glyphicons', "pjWrapper"),
						array(
								PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/fonts/glyphicons',
								"pjWrapperRestaurant_" . $theme
						),
						$string
				) . "\n";
			}
		}
		exit;
	}
	
	public function pjActionLoad()
	{
		ob_start();
		header("Content-Type: text/javascript; charset=utf-8");
	}
	
	private function pjCheckWTime()
	{
		$status = 200;
		
		$date = pjUtil::formatDate($this->_get('date'), $this->option_arr['o_date_format']);
		$wt_arr = pjAppController::getWorkingTime($date);
		
		$offset = 0;
		if ($wt_arr !== false)
		{
			$offset = $wt_arr['end_hour'] <= $wt_arr['start_hour'] ? 86400 : 0;
		}
		
		$_time = date('H:i:s', strtotime($this->_get('time')));
		$ts = strtotime($date . ' ' . $_time);
		$play = $this->option_arr['o_booking_earlier'] * 3600;
		
		if ($wt_arr === false)
		{
			$status = 300;
		} else {
			$stime = $ts;
			if($offset == 86400 && date('H', $ts) < $wt_arr['start_hour'])
			{
				$stime += 86400;
			}
			if (time() + $play > $stime)
			{
				$status = 301;
			} elseif ($wt_arr['start_ts'] > $ts + $offset) {
				$status = 302;
			} elseif ( ($wt_arr['end_ts'] + $offset < $ts + $this->option_arr['o_booking_length'] * 60)) {
				$status = 303;
			} else {
				$status = 200;
			}
		}
		return $status;
	}
	
	private function pjCheckAvailability($start_time, $people, $use_map, $status)
	{
		$result = array();
		if($people !== false && (int) $people > 0)
		{
			$booking_length = $this->option_arr['o_booking_length'] * 60;
			$end_time = date('Y-m-d H:i:s',strtotime($start_time) + $booking_length);
			
			$sub_query = sprintf("(SELECT COUNT(`table_id`)
									FROM `%1\$s`
									WHERE `table_id` = `t1`.`id`
									AND `booking_id` IN (SELECT `id` FROM `%2\$s` WHERE (
										(`dt` <= '%3\$s' AND '%3\$s' < `dt_to`)
										OR (`dt_to` >= '%4\$s' AND '%4\$s' > `dt`)
									) AND (`status` = 'confirmed' OR `status`='pending'))
									LIMIT 1)",
									pjBookingTableModel::factory()->getTable(),
									pjBookingModel::factory()->getTable(),
									$start_time, 
									$end_time
								);
			$table_arr = pjTableModel::factory()->select("t1.*, $sub_query AS booked")->findAll()->getData();
			
			$passed = false;
			$result['avail_tables'] = 0;
			$result['action'] = 'table';
			$table_id = 0;
			
			foreach ($table_arr as $table)
			{
				if((int) $table['booked'] === 0)
				{
					$passed = true;
					if((int) $people <= (int) $table['seats'] && (int) $people >= (int) $table['minimum'])
					{
						$result['avail_tables']++;
						if($status == 200 && $table_id == 0 && $use_map == 0)
						{
							$table_id = $table['id'];
							$this->_set('table_id', $table['id']);
						}
					}
				}
			}
			if($passed == true)
			{
				if($result['avail_tables'] == 0)
				{
					$result['action'] = 'enquiry';
				}else{
					if($table_id != 0)
					{
						$result['action'] = 'checkout';
					}else{
						$result['action'] = 'table';
					}
				}
			}
			
			$result['passed'] = $passed;
			$result['table_arr'] = $table_arr;
		}else{
			$result['passed'] = true;
		}
		return $result;
	}
	
	public function pjActionAddPromo()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$resp = array();
			
			$pjVoucherModel = pjVoucherModel::factory();
			
			$result = $pjVoucherModel->getVoucher($_GET['code'], date("Y-m-d", $this->_get('actual_datetime')), date("H:i:s", $this->_get('actual_datetime')));
			if ($result['status'] == 'OK')
			{
				$resp = pjAppController::getPrice($this->option_arr, date("Y-m-d", $this->_get('actual_datetime')), date("H:i:s", $this->_get('actual_datetime')), $_GET['code']);
				$resp['code'] = $result['code'];
				$this->_set('code', $_GET['code']);
				
				if (isset($resp['discount_formated']))
				{
					$resp['discount_text'] = $resp['discount_formated'] . " " . __('front_label_discount', true, false);
				}
			} else {
				$resp = pjAppController::getPrice($this->option_arr, date("Y-m-d", $this->_get('actual_datetime')), date("H:i:s", $this->_get('actual_datetime')));
				if ($this->_is('code'))
				{
					unset($_SESSION[$this->defaultStore]['code']);
				}
				$resp['code'] = $result['code'];
			}
			pjAppController::jsonResponse($resp);
		}
	}
	
	public function pjActionRemovePromo()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$resp = array();
			
			if ($this->_is('code'))
			{
				unset($_SESSION[$this->defaultStore]['code']);
			}
			$resp = pjAppController::getPrice($this->option_arr, date("Y-m-d", $this->_get('actual_datetime')), date("H:i:s", $this->_get('actual_datetime')));
			$resp['code'] = 200;
			pjAppController::jsonResponse($resp);
		}
	}
	
	public function pjActionGetWTime()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$this->_set('date', $_GET['date']);
			$date = pjUtil::formatDate($this->_get('date'), $this->option_arr['o_date_format']);
			$previous_date = date('Y-m-d', strtotime($date) - 86400);
			if($this->_is('table_id'))
			{
				unset($_SESSION[$this->defaultStore]['table_id']);
			}
			$this->set('wt_arr', pjAppController::getWorkingTime($date));
			$this->set('previous_wt_arr', pjAppController::getWorkingTime($previous_date));
		}
	}
	public function pjActionCheckAvail()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$resp = array();
			
			if(isset($_POST['step']))
			{
				if(isset($_POST['time']))
				{
					$this->_set('time', $_POST['time']);
				}
				if(isset($_POST['date']))
				{
					$this->_set('date', $_POST['date']);
				}
				if(isset($_POST['people']))
				{
					$this->_set('people', $_POST['people']);
				}
				if ($this->_get('date_format') != $this->option_arr['o_date_format'])
				{
					$this->_set('date', pjUtil::formatDate($this->_get('date'), $this->_get('date_format'), $this->option_arr['o_date_format']));
					$this->_set('date_format', $this->option_arr['o_date_format']);
				}
				$date = pjUtil::formatDate($this->_get('date'), $this->option_arr['o_date_format']);
				$wt_arr = pjAppController::getWorkingTime($date);
				$offset = 0;
				if ($wt_arr !== false)
				{
					$offset = $wt_arr['end_hour'] <= $wt_arr['start_hour'] ? 86400 : 0;
				}
				$status = $this->pjCheckWTime();
				$_date = pjUtil::formatDate($this->_get('date'), $this->option_arr['o_date_format']);
				$_time = date('H:i:s', strtotime($this->_get('time')));
				$start_time = $_date . " " . $_time;
				
				if($wt_arr != false)
				{
					$check_result = $this->pjCheckAvailability($start_time, $this->_get('people'), $this->option_arr['o_use_map'], $status);
					if($check_result['action'] == 'enquiry' && $this->_is('table_id'))
					{
						unset($_SESSION[$this->defaultStore]['table_id']);
					}
					$this->_set('check_result', $check_result);
					$resp['code'] = 200;
				}else{
					if($this->_is('table_id'))
					{
						unset($_SESSION[$this->defaultStore]['table_id']);
					}
					$resp['code'] = 100;
				}
			}else{
				$resp['code'] = 100;
			}
			pjAppController::jsonResponse($resp);
		}
	}
	
	public function pjActionSearch()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			if (!isset($_SESSION[$this->defaultStore]) || count($_SESSION[$this->defaultStore]) === 0)
			{
				$_SESSION[$this->defaultStore] = array();
			
				$this->_set('people', 1);
				$this->_set('date', pjUtil::formatDate(date('Y-m-d', time() + 86400), "Y-m-d", $this->option_arr['o_date_format']));
				$this->_set('date_format', $this->option_arr['o_date_format']);
			}
			$date = pjUtil::formatDate($this->_get('date'), $this->option_arr['o_date_format']);
			$previous_date = date('Y-m-d', strtotime($date) - 86400);
			
			$wt_arr = pjAppController::getWorkingTime($date);
			$previous_wt_arr = pjAppController::getWorkingTime($previous_date);
			
			if ($wt_arr !== false)
			{
				$this->set('wt_arr', $wt_arr);
			}
			if ($previous_wt_arr !== false)
			{
				$this->set('previous_wt_arr', $previous_wt_arr);
			}
		}
	}
	public function pjActionTables()
	{
		$this->setAjax(true);
	
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			if (!isset($_SESSION[$this->defaultStore]) || empty($_SESSION[$this->defaultStore]))
			{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100));
			}
			$check_result = $this->_get('check_result');
			$_date = pjUtil::formatDate($this->_get('date'), $this->option_arr['o_date_format']);
			$_time = date('H:i:s', strtotime($this->_get('time')));
			$start_time = $_date . " " . $_time;

			$previous_date = date('Y-m-d', strtotime($_date) - 86400);
			
			$wt_arr = pjAppController::getWorkingTime($_date);
			$previous_wt_arr = pjAppController::getWorkingTime($previous_date);
			$offset = 0;
			if ($wt_arr !== false)
			{
				$offset = $wt_arr['end_hour'] <= $wt_arr['start_hour'] ? 86400 : 0;
				$this->set('wt_arr', $wt_arr);
			}
			if ($previous_wt_arr !== false)
			{
				$this->set('previous_wt_arr', $previous_wt_arr);
			}
			
			$stime = strtotime($start_time);
			$this->_set('actual_datetime', $stime);
			
			if($check_result['action'] == 'enquiry')
			{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 101));
			}
			if($check_result['action'] == 'checkout')
			{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 102));
			}
			
			$status = $this->pjCheckWTime();
			
			$time = date($this->option_arr['o_time_format'], $stime);
			$title_str = __('front_available_tables_for', true, false);
			$title_str = sprintf($title_str, $this->_get('people'), date($this->option_arr['o_date_format'], $stime), $time);
			
			$this->set('status', $status);
			$this->set('people', $this->_get('people'));
			$this->set('title_str', $title_str);
			$this->set('check_result', $check_result);
		}
	}
	
	public function pjActionAddTable()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$this->_set('table_id', $_GET['table_id']);
			$resp = array('code' => 200);
			pjAppController::jsonResponse($resp);
		}
	}
	
	public function pjActionRemoveTable()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			if($this->_is('table_id'))
			{
				unset($_SESSION[$this->defaultStore]['table_id']);
			}
			$resp = array('code' => 200);
			pjAppController::jsonResponse($resp);
		}
	}
	
	public function pjActionCheckout()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			if (isset($_SESSION[$this->defaultStore]) && count($_SESSION[$this->defaultStore]) > 0)
			{
				$table_id = $this->_get('table_id');
				if ($table_id !== false && (int) $table_id > 0)
				{
					$this->set('table', pjTableModel::factory()->find($table_id)->getData());
				}
				
				$country_arr = pjCountryModel::factory()
							->select('t1.id, t2.content AS country_title')
							->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
							->where('status', 'T')
							->orderBy('`country_title` ASC')->findAll()->getData();
							
				$date = pjUtil::formatDate($this->_get('date'), $this->option_arr['o_date_format']);
				$code = $this->_is('code') ? $this->_get('code') : NULL;
					
				$resp = pjAppController::getPrice($this->option_arr, date("Y-m-d", $this->_get('actual_datetime')), date("H:i:s", $this->_get('actual_datetime')), $code);
				if (isset($resp['discount_formated']))
				{
					$resp['discount_text'] = $resp['discount_formated'] . " " . __('front_label_discount', true, false);
				}else{
					if($this->_is('code'))
					{
						unset($_SESSION[$this->defaultStore]['code']);
					}
				}
				
				$terms_key = 'o_terms';
				if($_SESSION[$this->defaultStore]['check_result']['action'] == 'enquiry')
				{
					$terms_key = 'o_enquiry';
				}
				
				$terms_conditions = pjMultiLangModel::factory()->select('t1.*')
												 ->where('t1.model','pjOption')
												 ->where('t1.locale', $this->getLocaleId())
												 ->where('t1.field', $terms_key)
												 ->limit(0, 1)
												 ->findAll()->getData();
	
				$this->set('country_arr', $country_arr);
				$this->set('price_arr', $resp);
				$this->set('terms_conditions', $terms_conditions[0]['content']);
				$this->set('wt_arr', pjAppController::getWorkingTime($date));
				
				$this->set('status', 'OK');
			}else{
				$this->set('status', 'ERR');
			}
		}
	}
	
	public function pjActionSaveForm()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			if (!isset($_SESSION[$this->defaultForm]) || count($_SESSION[$this->defaultForm]) === 0)
			{
				$_SESSION[$this->defaultForm] = array();
			}
			if(isset($_POST['step_checkout'])){
				$_SESSION[$this->defaultForm] = $_POST;
			}
			
			$resp = array('code' => 200);
			pjAppController::jsonResponse($resp);
		}
	}
	
	public function pjActionPreview()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			if (isset($_SESSION[$this->defaultForm]) && count($_SESSION[$this->defaultForm]) > 0)
			{
				$table_id = $this->_get('table_id');
				if ($table_id !== false && (int) $table_id > 0)
				{
					$this->set('table', pjTableModel::factory()->find($table_id)->getData());
				}
				
				$country_arr = array();
				if(isset($_SESSION[$this->defaultForm]['c_country']) && !empty($_SESSION[$this->defaultForm]['c_country'])){
					
					$country_arr = pjCountryModel::factory()
								->select('t1.id, t2.content AS country_title')
								->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
								->find($_SESSION[$this->defaultForm]['c_country'])->getData();
				}
							
				$date = pjUtil::formatDate($this->_get('date'), $this->option_arr['o_date_format']);
				$code = $this->_is('code') ? $this->_get('code') : NULL;
							
				$resp = pjAppController::getPrice($this->option_arr, date("Y-m-d", $this->_get('actual_datetime')), date("H:i:s", $this->_get('actual_datetime')), $code);
				if (isset($resp['discount_formated']))
				{
					$resp['discount_text'] = $resp['discount_formated'] . " " . __('front_label_discount', true, false);
				}
	
				$this->set('country_arr', $country_arr);
				$this->set('price_arr', $resp);
				$this->set('wt_arr', pjAppController::getWorkingTime($date));
				
				$this->set('status', 'OK');
			}else{
				$this->set('status', 'ERR');
			}
		}
	}
	
	public function pjActionSaveBooking()
	{
		$this->setAjax(true);
		if ($this->isXHR())
		{
			$pjBookingModel = pjBookingModel::factory();
			$pjBookingTableModel = pjBookingTableModel::factory();
			
			$data = array();
			$FORM = $_SESSION[$this->defaultForm];
			$STORE = $_SESSION[$this->defaultStore];
			
			$data['status'] = $this->option_arr['o_booking_status'];
			
			$code = $this->_is('code') ? $this->_get('code') : NULL;
			
			$booking_length = $this->option_arr['o_booking_length'] * 60;
			$opts = pjAppController::getPrice($this->option_arr, date("Y-m-d", $this->_get('actual_datetime')), date("H:i:s", $this->_get('actual_datetime')), $code);
			$data['total']   = $opts['total'];
			$data['dt'] = date("Y-m-d H:i:s", $this->_get('actual_datetime'));
			$data['dt_to'] = date("Y-m-d H:i:s", strtotime($data['dt']) + $booking_length);
			$data['uuid'] = time();
			$data['ip'] = $_SERVER['REMOTE_ADDR'];

			if ($this->_is('table_id'))
			{
				$start_time = $this->_get('actual_datetime');
				$end_time = $this->_get('actual_datetime') + $booking_length;
				
				$cnt_tables = $pjBookingTableModel
					->where("t1.table_id", $this->_get('table_id'))
					->where("(t1.`booking_id` IN (SELECT `id` FROM `".$pjBookingModel->getTable()."` WHERE (
										(UNIX_TIMESTAMP(`dt`) <= '$end_time' AND UNIX_TIMESTAMP(`dt`) > '$start_time')
										OR (UNIX_TIMESTAMP(`dt_to`) <= '$end_time' AND UNIX_TIMESTAMP(`dt_to`) > '$start_time')
									) AND (`status` = 'confirmed' OR `status`='pending')))")
					->findCount()
					->getData();
				if($cnt_tables > 0)
				{	
					$json = array('code' => 300, 'text' => '');
					unset($_SESSION[$this->defaultStore]['table_id']);
					pjAppController::jsonResponse($json);
				}
			}
			
			$payment = 'none';
			if(isset($FORM['payment_method']))
			{
				if ($FORM['payment_method'] && $FORM['payment_method'] == 'creditcard')
				{
					$data['cc_exp'] = $FORM['cc_exp_year'] . '-' . $FORM['cc_exp_month'];
				}
				
				if ($FORM['payment_method']){
					$payment = $FORM['payment_method'];
				}
			}
			
			$data = array_merge($FORM, $STORE, $data);
			
			$table_id = $this->_get('table_id');
			if ($_SESSION[$this->defaultStore]['check_result']['action'] == 'enquiry')
			{
				$data['status'] = 'enquiry';
			}
			
			$booking_id = $pjBookingModel->setAttributes($data)->insert()->getInsertId();
			if ($booking_id !== false)
			{
				$booking_arr = $pjBookingModel->reset()->find($booking_id)->getData();
				if ($table_id !== false && (int) $table_id > 0)
				{
					$pjBookingTableModel->reset()->setAttributes(array('booking_id' => $booking_id, 'table_id' => $table_id))->insert();
					if (count($booking_arr) > 0)
					{
						$booking_arr['table_arr'] = $pjBookingTableModel->reset()->select("t1.*, t2.name")
														->join('pjTable', 't1.table_id = t2.id')
														->where('t1.booking_id', $booking_id)
														->findAll()->getData();
											
					}
					$op = 'confirm';
					$json = array('code' => 200, 'text' => '', 'booking_id' => $booking_id, 'payment' => $payment);
				}else{
					$booking_arr['table_arr'] = array();
					$op = 'enquiry';
					$json = array('code' => 201, 'text' => '', 'booking_id' => $booking_id, 'payment' => $payment);
				}
				
				pjFront::pjActionConfirmSend($this->option_arr, $booking_arr, PJ_SALT, $op);
				
				unset($_SESSION[$this->defaultStore]);
				unset($_SESSION[$this->defaultForm]);
				unset($_SESSION[$this->firstLoad]);
			}else{
				$json = array('code' => 100, 'text' => '');
			}
			pjAppController::jsonResponse($json);
		}
	}
	
	public function pjActionConfirmSend($option_arr, $booking_arr, $salt, $opt)
	{
		$pjEmail = new pjEmail();
		$pjEmail->setContentType("text/html");
		
		$from_email = $this->getAdminEmail();
		if ($option_arr['o_send_email'] == 'smtp')
		{
			$pjEmail
				->setTransport('smtp')
				->setSmtpHost($option_arr['o_smtp_host'])
				->setSmtpPort($option_arr['o_smtp_port'])
				->setSmtpUser($option_arr['o_smtp_user'])
				->setSmtpPass($option_arr['o_smtp_pass'])
				->setSender($option_arr['o_smtp_user']);
			;
		}
		
		$data = pjAppController::getData($option_arr, $booking_arr, $salt, $this->getLocaleId(), false);
		
		$admin_email = $this->getAdminEmail();
		
		$pjMultiLangModel = pjMultiLangModel::factory();		
		if ($opt == 'payment')
		{
			$lang_message = $pjMultiLangModel->reset()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_email_payment_message')
											 ->limit(0, 1)
											 ->findAll()->getData();
			$lang_subject = $pjMultiLangModel->reset()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_email_payment_subject')
											 ->limit(0, 1)
											 ->findAll()->getData();
											 
			if (count($lang_message) === 1 && count($lang_subject) === 1)
			{
				$message = str_replace($data['search'], $data['replace'], $lang_message[0]['content']);
				$pjEmail
						->setTo($booking_arr['c_email'])
						->setFrom($from_email)
						->setSubject($lang_subject[0]['content'])
						->send(pjUtil::textToHtml($message));
			}
			
			$admin_lang_message = $pjMultiLangModel->reset()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_admin_email_payment_message')
											 ->limit(0, 1)
											 ->findAll()->getData();
			$admin_lang_subject = $pjMultiLangModel->reset()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_admin_email_payment_subject')
											 ->limit(0, 1)
											 ->findAll()->getData();
			if (count($admin_lang_message) === 1 && count($admin_lang_subject) === 1)
			{
				$message = str_replace($data['search'], $data['replace'], $admin_lang_message[0]['content']);
				$pjEmail
						->setTo($admin_email)
						->setFrom($from_email)
						->setSubject($admin_lang_subject[0]['content'])
						->send(pjUtil::textToHtml($message));
			}
		}
		
		if ($opt == 'confirm')
		{
			$lang_message = $pjMultiLangModel->reset()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_email_confirmation_message')
											 ->limit(0, 1)
											 ->findAll()->getData();
			$lang_subject = $pjMultiLangModel->reset()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_email_confirmation_subject')
											 ->limit(0, 1)
											 ->findAll()->getData();
											 
			if (count($lang_message) === 1 && count($lang_subject) === 1)
			{
				$message = str_replace($data['search'], $data['replace'], $lang_message[0]['content']);
				$pjEmail
						->setTo($booking_arr['c_email'])
						->setFrom($from_email)
						->setSubject($lang_subject[0]['content'])
						->send(pjUtil::textToHtml($message));
			}
			
			$admin_lang_message = $pjMultiLangModel->reset()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_admin_email_confirmation_message')
											 ->limit(0, 1)
											 ->findAll()->getData();
			$admin_lang_subject = $pjMultiLangModel->reset()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_admin_email_confirmation_subject')
											 ->limit(0, 1)
											 ->findAll()->getData();
			if (count($admin_lang_message) === 1 && count($admin_lang_subject) === 1)
			{
				$message = str_replace($data['search'], $data['replace'], $admin_lang_message[0]['content']);
				$pjEmail
						->setTo($admin_email)
						->setFrom($from_email)
						->setSubject($admin_lang_subject[0]['content'])
						->send(pjUtil::textToHtml($message));
			}
		}
		
		if ($opt == 'enquiry')
		{
			$lang_message = $pjMultiLangModel->reset()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_email_enquiry_message')
											 ->limit(0, 1)
											 ->findAll()->getData();
			$lang_subject = $pjMultiLangModel->reset()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_email_enquiry_subject')
											 ->limit(0, 1)
											 ->findAll()->getData();
											 
			if (count($lang_message) === 1 && count($lang_subject) === 1)
			{
				$message = str_replace($data['search'], $data['replace'], $lang_message[0]['content']);
				$pjEmail
						->setTo($booking_arr['c_email'])
						->setFrom($from_email)
						->setSubject($lang_subject[0]['content'])
						->send(pjUtil::textToHtml($message));
			}
			
			$admin_lang_message = $pjMultiLangModel->reset()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_admin_email_enquiry_message')
											 ->limit(0, 1)
											 ->findAll()->getData();
			$admin_lang_subject = $pjMultiLangModel->reset()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_admin_email_enquiry_subject')
											 ->limit(0, 1)
											 ->findAll()->getData();
			if (count($admin_lang_message) === 1 && count($admin_lang_subject) === 1)
			{
				$message = str_replace($data['search'], $data['replace'], $admin_lang_message[0]['content']);
				$pjEmail
						->setTo($admin_email)
						->setFrom($from_email)
						->setSubject($admin_lang_subject[0]['content'])
						->send(pjUtil::textToHtml($message));
			}
		}
		
		if ($opt == 'cancel')
		{
			$lang_message = $pjMultiLangModel->reset()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_email_cancel_message')
											 ->limit(0, 1)
											 ->findAll()->getData();
			$lang_subject = $pjMultiLangModel->reset()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_email_cancel_subject')
											 ->limit(0, 1)
											 ->findAll()->getData();
			
			if (count($lang_message) === 1 && count($lang_subject) === 1)
			{
				$message = str_replace($data['search'], $data['replace'], $lang_message[0]['content']);
				$pjEmail
					->setTo($booking_arr['c_email'])
					->setFrom($from_email)
					->setSubject($lang_subject[0]['content'])
					->send(pjUtil::textToHtml($message));
			}
			
			$admin_lang_message = $pjMultiLangModel->reset()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_admin_email_cancel_message')
											 ->limit(0, 1)
											 ->findAll()->getData();
			$admin_lang_subject = $pjMultiLangModel->reset()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_admin_email_cancel_subject')
											 ->limit(0, 1)
											 ->findAll()->getData();
			if (count($admin_lang_message) === 1 && count($admin_lang_subject) === 1)
			{
				$message = str_replace($data['search'], $data['replace'], $admin_lang_message[0]['content']);
				$pjEmail
					->setTo($admin_email)
					->setFrom($from_email)
					->setSubject($admin_lang_subject[0]['content'])
					->send(pjUtil::textToHtml($message));
			}											 											 
		}
	}
	
	public function pjActionGetPaymentForm()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$booking_arr = pjBookingModel::factory()->select('t1.*')
								  		  			->find($_GET['booking_id'])->getData();
			
			switch ($booking_arr['payment_method'])
			{
				case 'paypal':
					$this->set('params', array(
						'name' => 'rbPaypal',
						'id' => 'rbPaypal',
						'business' => $this->option_arr['o_paypal_address'],
						'item_name' => __('front_label_restaurant_reservations', true, false),
						'custom' => $booking_arr['id'],
						'amount' => number_format($booking_arr['total'], 2, '.', ''),
						'currency_code' => $this->option_arr['o_currency'],
						'return' => $this->option_arr['o_thank_you_page'],
						'notify_url' => PJ_INSTALL_URL . 'index.php?controller=pjFront&action=pjActionConfirmPaypal',
						'target' => '_self',
						'charset' => 'utf-8'
					));
					break;
				case 'authorize':
					$this->set('params', array(
						'name' => 'rbAuthorize',
						'id' => 'rbAuthorize',
						'timezone' => $this->option_arr['o_timezone'],
						'transkey' => $this->option_arr['o_authorize_transkey'],
						'x_login' => $this->option_arr['o_authorize_merchant_id'],
						'x_description' => __('front_label_restaurant_reservations', true, false),
						'x_amount' => number_format($booking_arr['total'], 2, '.', ''),
						'x_invoice_num' => $booking_arr['id'],
						'x_relay_url' => PJ_INSTALL_URL . 'index.php?controller=pjFront&action=pjActionConfirmAuthorize'
					));
					break;
			}
			
			$this->set('booking_arr', $booking_arr);
			$this->set('get', $_GET);
		}
	}
	
	public function pjActionConfirmAuthorize()
	{
		$this->setAjax(true);
		
		if (pjObject::getPlugin('pjAuthorize') === NULL)
		{
			$this->log('Authorize.NET plugin not installed');
			exit;
		}
	
		$booking_arr = pjBookingModel::factory()->select("t1.*, t2.name")
													->join('pjTable', 't1.table_id = t2.id')
													->find($_POST['x_invoice_num'])->getData();
									 
		if (count($booking_arr) == 0)
		{
			$this->log('No such booking');
			pjUtil::redirect($this->option_arr['o_thank_you_page']);
		}					
		
		if (count($booking_arr) > 0)
		{
			$params = array(
				'transkey' => $this->option_arr['o_authorize_transkey'],
				'x_login' => $this->option_arr['o_authorize_merchant_id'],
				'key' => md5($this->option_arr['private_key'] . PJ_SALT)
			);
			
			$response = $this->requestAction(array('controller' => 'pjAuthorize', 'action' => 'pjActionConfirm', 'params' => $params), array('return'));
			if ($response !== FALSE && $response['status'] === 'OK')
			{
				$pjBookingModel->reset()
					->setAttributes(array('id' => $response['transaction_id']))
					->modify(array('status' => $this->option_arr['o_payment_status'], 'is_paid' => 'T'));
					
				
				if (count($booking_arr) > 0)
				{
					$booking_arr['table_arr'] = pjBookingTableModel::factory()->select("t1.*, t2.name")
													->join('pjTable', 't1.table_id = t2.id')
													->where('t1.booking_id', $booking_arr['id'])
													->findAll()->getData();
										
				}
				
				pjFront::pjActionConfirmSend($this->option_arr, $booking_arr, PJ_SALT, 'payment');
				
			} elseif (!$response) {
				$this->log('Authorization failed');
			} else {
				$this->log('Booking not confirmed. ' . $response['response_reason_text']);
			}
			pjUtil::redirect($this->option_arr['o_thankyou_page']);
		}
	}

	public function pjActionConfirmPaypal()
	{
		$this->setAjax(true);
		
		if (pjObject::getPlugin('pjPaypal') === NULL)
		{
			$this->log('Paypal plugin not installed');
			exit;
		}
		$pjBookingModel = pjBookingModel::factory();
		
		$booking_arr = $pjBookingModel->select("t1.*, t3.name")
             ->join('pjBookingTable', 't1.id = t2.booking_id')
             ->join('pjTable', 't2.table_id = t3.id')
             ->find($_POST['custom'])->getData();
		if (count($booking_arr) == 0)
		{
			$this->log('No such booking');
			pjUtil::redirect($this->option_arr['o_thank_you_page']);
		}					
		
		$params = array(
			'txn_id' => @$booking_arr['txn_id'],
			'paypal_address' => $this->option_arr['o_paypal_address'],
			'deposit' => @$booking_arr['total'],
			'currency' => $this->option_arr['o_currency'],
			'key' => md5($this->option_arr['private_key'] . PJ_SALT)
		);
		$response = $this->requestAction(array('controller' => 'pjPaypal', 'action' => 'pjActionConfirm', 'params' => $params), array('return'));
		
		if ($response !== FALSE && $response['status'] === 'OK')
		{
			$this->log('Booking confirmed');
			$pjBookingModel->reset()->setAttributes(array('id' => $booking_arr['id']))->modify(array(
				'status' => $this->option_arr['o_payment_status'],
				'txn_id' => $response['transaction_id'],
				'is_paid' => 'T',
				'processed_on' => ':NOW()'
			));
			
			if (count($booking_arr) > 0)
			{
				$booking_arr['table_arr'] = pjBookingTableModel::factory()
												->select("t1.*, t2.name")
												->join('pjTable', 't1.table_id = t2.id')
												->where('t1.booking_id', $booking_arr['id'])
												->findAll()->getData();
			}
			
			pjFront::pjActionConfirmSend($this->option_arr, $booking_arr, PJ_SALT, 'payment');
			
		} elseif (!$response) {
			$this->log('Authorization failed');
		} else {
			$this->log('Booking not confirmed');
		}
		pjUtil::redirect($this->option_arr['o_thankyou_page']);
	}
	
	public function pjActionCancel()
	{
		$this->setLayout('pjActionEmpty');
		
		$pjBookingModel = pjBookingModel::factory();
		
		if (isset($_POST['booking_cancel']))
		{
			$booking_arr = pjBookingModel::factory()->find($_POST['id'])->getData();
			if (count($booking_arr) > 0)
			{
				$sql = "UPDATE `".$pjBookingModel->getTable()."` SET status = 'cancelled' WHERE SHA1(CONCAT(`id`, `created`, '".PJ_SALT."')) = '" . $_POST['hash'] . "'";
				
				$pjBookingModel->reset()->execute($sql);

				$booking_arr['table_arr'] = pjBookingTableModel::factory()->select("t1.*, t2.name")
												->join('pjTable', 't1.table_id = t2.id')
												->where('t1.booking_id', $booking_arr['id'])
												->findAll()->getData();
									
				pjFront::pjActionConfirmSend($this->option_arr, $booking_arr, PJ_SALT, 'cancel');
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjFront&action=pjActionCancel&err=200');
			}
		}else{
			if (isset($_GET['hash']) && isset($_GET['id']))
			{
				$arr = $pjBookingModel	->select('t1.*, t2.content as country_title')
										->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.c_country AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
										->find($_GET['id'])->getData();
				if (count($arr) == 0)
				{
					$this->set('status', 2);
				}else{
					if ($arr['status'] == 'cancelled')
					{
						$this->set('status', 2);
					}else{
						$hash = sha1($arr['id'] . $arr['created'] . PJ_SALT);
						if ($_GET['hash'] != $hash)
						{
							$this->set('status', 3);
						}else{
							
							$arr['table_arr'] = pjBookingTableModel::factory()->select('t1.*, t2.name')
														->join('pjTable', 't1.table_id = t2.id', 'left')
														->where('t1.booking_id', $_GET['id'])
														->findAll()->getData();

							$date = date('Y-m-d', strtotime($arr['dt']));
							$time = date('H:i:s', strtotime($arr['dt']));
							$price_arr = pjAppController::getPrice($this->option_arr, $date, $time, $arr['code']);
							
							$this->set('arr', $arr);
							$this->set('discount', isset($price_arr['discount_formated']) ? $price_arr['discount_formated'] : '');
						}
					}
				}
			}elseif (!isset($_GET['err'])) {
				$this->set('status', 1);
			}
		}
	}
	
	public function isXHR()
	{
		// CORS
		return parent::isXHR() || isset($_SERVER['HTTP_ORIGIN']);
	}
	
	static protected function allowCORS()
	{
		if (!isset($_SERVER['HTTP_ORIGIN']))
		{
			return;
		}
		
		header("Access-Control-Allow-Origin: " . $_SERVER['HTTP_ORIGIN']);
		header("Access-Control-Allow-Credentials: true");
		header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
		header("Access-Control-Allow-Headers: Origin, X-Requested-With");
		
		if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS')
		{
			exit;
		}
	}
}
?>