DROP TABLE IF EXISTS `restaurantbooking_users`;

CREATE TABLE `restaurantbooking_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `restaurantbooking_users` (`id`, `role_id`, `email`, `password`, `name`, `phone`, `created`, `last_login`, `status`, `is_active`, `ip`) VALUES('1', '1', 'andrea.visona@amdsoftware.it', 0xbfaa0650666b1ab886dc4b9e2273e948, 'Administrator', NULL, '2018-06-14 11:16:33', '2018-06-25 07:55:34', 'T', 'F', '82.112.222.70');

DROP TABLE IF EXISTS `restaurantbooking_multi_lang`;

CREATE TABLE `restaurantbooking_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB AUTO_INCREMENT=4063 DEFAULT CHARSET=utf8;

INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1', '1', 'pjField', '1', 'title', 'Add language', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2', '2', 'pjField', '1', 'title', 'Password reminder', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('3', '3', 'pjField', '1', 'title', 'Admin Login', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('4', '4', 'pjField', '1', 'title', 'Back-end titles', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('5', '5', 'pjField', '1', 'title', 'Add +', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('6', '6', 'pjField', '1', 'title', '« Back', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('7', '7', 'pjField', '1', 'title', 'Backup', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('8', '8', 'pjField', '1', 'title', 'Cancel', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('9', '9', 'pjField', '1', 'title', 'Continue', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('10', '10', 'pjField', '1', 'title', 'Delete', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('11', '11', 'pjField', '1', 'title', 'Login', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('12', '12', 'pjField', '1', 'title', 'Reset', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('13', '13', 'pjField', '1', 'title', 'Save', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('14', '14', 'pjField', '1', 'title', 'Search', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('15', '15', 'pjField', '1', 'title', 'Send', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('16', '16', 'pjField', '1', 'title', 'Update', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('17', '17', 'pjField', '1', 'title', 'DateTime', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('18', '18', 'pjField', '1', 'title', 'Email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('19', '19', 'pjField', '1', 'title', 'Dear {Name},Your password: {Password}', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('20', '20', 'pjField', '1', 'title', 'Password reminder', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('21', '21', 'pjField', '1', 'title', 'Front-end titles', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('22', '22', 'pjField', '1', 'title', 'Action confirmation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('23', '23', 'pjField', '1', 'title', 'Cancel', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('24', '24', 'pjField', '1', 'title', 'Delete', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('25', '25', 'pjField', '1', 'title', 'OK', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('26', '26', 'pjField', '1', 'title', 'Choose Action', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('27', '27', 'pjField', '1', 'title', 'Are you sure you want to delete selected record?', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('28', '28', 'pjField', '1', 'title', 'Delete confirmation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('29', '29', 'pjField', '1', 'title', 'No records found', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('30', '30', 'pjField', '1', 'title', 'Go to page:', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('31', '31', 'pjField', '1', 'title', 'Items per page', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('32', '32', 'pjField', '1', 'title', 'Next »', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('33', '33', 'pjField', '1', 'title', 'Next page', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('34', '34', 'pjField', '1', 'title', '« Prev', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('35', '35', 'pjField', '1', 'title', 'Prev page', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('36', '36', 'pjField', '1', 'title', 'Total items:', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('37', '37', 'pjField', '1', 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('38', '38', 'pjField', '1', 'title', 'Location and address', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('39', '39', 'pjField', '1', 'title', 'Listing Reservations Body', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('40', '40', 'pjField', '1', 'title', 'Listing Reservation Title', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('41', '41', 'pjField', '1', 'title', 'Listing Contact Body', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('42', '42', 'pjField', '1', 'title', 'Listing Contact Title', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('43', '43', 'pjField', '1', 'title', 'Extend exp.date Body', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('44', '44', 'pjField', '1', 'title', 'Extend exp.date Title', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('45', '45', 'pjField', '1', 'title', 'Listing Prices Body', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('46', '46', 'pjField', '1', 'title', 'Listing Prices Title', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('47', '47', 'pjField', '1', 'title', 'Languages Array Body', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('48', '48', 'pjField', '1', 'title', 'Languages Arrays Title', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('49', '49', 'pjField', '1', 'title', 'Languages Backend Body', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('50', '50', 'pjField', '1', 'title', 'Languages Backend Title', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('51', '51', 'pjField', '1', 'title', 'Languages Body', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('52', '52', 'pjField', '1', 'title', 'Languages Frontend Body', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('53', '53', 'pjField', '1', 'title', 'Languages Frontend Title', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('54', '54', 'pjField', '1', 'title', 'Languages Title', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('55', '55', 'pjField', '1', 'title', 'Add user', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('56', '56', 'pjField', '1', 'title', 'Backup database', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('57', '57', 'pjField', '1', 'title', 'Backup files', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('58', '58', 'pjField', '1', 'title', 'Choose', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('59', '59', 'pjField', '1', 'title', 'days', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('60', '60', 'pjField', '1', 'title', 'Delete', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('61', '61', 'pjField', '1', 'title', 'Error', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('62', '62', 'pjField', '1', 'title', 'Export', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('63', '63', 'pjField', '1', 'title', 'Forgot password', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('64', '64', 'pjField', '1', 'title', 'IP address', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('65', '65', 'pjField', '1', 'title', 'Is confirmed', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('66', '66', 'pjField', '1', 'title', 'Name', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('67', '67', 'pjField', '1', 'title', 'No', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('68', '68', 'pjField', '1', 'title', 'Option', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('69', '69', 'pjField', '1', 'title', 'Option list', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('70', '70', 'pjField', '1', 'title', 'Role', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('71', '71', 'pjField', '1', 'title', 'Status', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('72', '72', 'pjField', '1', 'title', 'Type', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('73', '73', 'pjField', '1', 'title', 'Update user', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('74', '74', 'pjField', '1', 'title', 'Registration date/time', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('75', '75', 'pjField', '1', 'title', 'Value', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('76', '76', 'pjField', '1', 'title', 'Yes', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('77', '77', 'pjField', '1', 'title', 'Back', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('78', '78', 'pjField', '1', 'title', 'Arrays titles', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('79', '79', 'pjField', '1', 'title', 'Languages', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('80', '80', 'pjField', '1', 'title', 'Flag', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('81', '81', 'pjField', '1', 'title', 'Is default', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('82', '82', 'pjField', '1', 'title', 'Order', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('83', '83', 'pjField', '1', 'title', 'Title', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('84', '84', 'pjField', '1', 'title', 'Backup', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('85', '85', 'pjField', '1', 'title', 'Dashboard', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('86', '86', 'pjField', '1', 'title', 'Multi Lang', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('87', '87', 'pjField', '1', 'title', 'Languages', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('88', '88', 'pjField', '1', 'title', 'Logout', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('89', '89', 'pjField', '1', 'title', 'Options', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('90', '90', 'pjField', '1', 'title', 'Plugins', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('91', '91', 'pjField', '1', 'title', 'Profile', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('92', '92', 'pjField', '1', 'title', 'Users', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('93', '93', 'pjField', '1', 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('94', '94', 'pjField', '1', 'title', 'Currency', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('95', '95', 'pjField', '1', 'title', 'Date format', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('96', '96', 'pjField', '1', 'title', 'Send email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('97', '97', 'pjField', '1', 'title', 'SMTP Host', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('98', '98', 'pjField', '1', 'title', 'SMTP Password', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('99', '99', 'pjField', '1', 'title', 'SMTP Port', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('100', '100', 'pjField', '1', 'title', 'SMTP Username', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('101', '101', 'pjField', '1', 'title', 'Timezone', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('102', '102', 'pjField', '1', 'title', 'First day of the week', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('103', '103', 'pjField', '1', 'title', 'Password', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('104', '125', 'pjField', '1', 'title', 'Revert status', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('105', '126', 'pjField', '1', 'title', 'URL', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('106', '127', 'pjField', '1', 'title', 'Username', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('107', '128', 'pjField', '1', 'title', 'Email address was already in use', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('108', '129', 'pjField', '1', 'title', 'Sunday', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('109', '130', 'pjField', '1', 'title', 'Monday', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('110', '131', 'pjField', '1', 'title', 'Tuesday', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('111', '132', 'pjField', '1', 'title', 'Wednesday', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('112', '133', 'pjField', '1', 'title', 'Thursday', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('113', '134', 'pjField', '1', 'title', 'Friday', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('114', '135', 'pjField', '1', 'title', 'Saturday', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('115', '136', 'pjField', '1', 'title', 'S', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('116', '137', 'pjField', '1', 'title', 'M', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('117', '138', 'pjField', '1', 'title', 'T', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('118', '139', 'pjField', '1', 'title', 'W', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('119', '140', 'pjField', '1', 'title', 'T', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('120', '141', 'pjField', '1', 'title', 'F', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('121', '142', 'pjField', '1', 'title', 'S', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('122', '143', 'pjField', '1', 'title', 'Given email address is not associated with any account.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('123', '144', 'pjField', '1', 'title', 'For further instructions please check your mailbox.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('124', '145', 'pjField', '1', 'title', 'We are sorry, please try again later.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('125', '146', 'pjField', '1', 'title', 'All the changes made to your profile have been saved.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('126', '147', 'pjField', '1', 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('127', '148', 'pjField', '1', 'title', 'All backup files have been saved.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('128', '149', 'pjField', '1', 'title', 'No option was selected.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('129', '150', 'pjField', '1', 'title', 'Backup not performed.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('130', '151', 'pjField', '1', 'title', 'All the changes made to titles have been saved.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('131', '152', 'pjField', '1', 'title', 'All the changes made to options have been saved.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('132', '153', 'pjField', '1', 'title', 'All the changes made to this user have been saved.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('133', '154', 'pjField', '1', 'title', 'All the changes made to this user have been saved.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('134', '155', 'pjField', '1', 'title', 'We are sorry, but the user has not been added.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('135', '156', 'pjField', '1', 'title', 'User your looking for is missing.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('136', '159', 'pjField', '1', 'title', 'Account not found!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('137', '160', 'pjField', '1', 'title', 'Password send!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('138', '161', 'pjField', '1', 'title', 'Password not send!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('139', '162', 'pjField', '1', 'title', 'Profile updated!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('140', '163', 'pjField', '1', 'title', 'Backup', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('141', '164', 'pjField', '1', 'title', 'Backup complete!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('142', '165', 'pjField', '1', 'title', 'Backup failed!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('143', '166', 'pjField', '1', 'title', 'Backup failed!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('144', '167', 'pjField', '1', 'title', 'Options updated!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('145', '168', 'pjField', '1', 'title', 'User updated!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('146', '169', 'pjField', '1', 'title', 'User added!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('147', '170', 'pjField', '1', 'title', 'User failed to add.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('148', '171', 'pjField', '1', 'title', 'User not found.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('149', '174', 'pjField', '1', 'title', 'Active', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('150', '175', 'pjField', '1', 'title', 'Inactive', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('151', '176', 'pjField', '1', 'title', 'Wrong username or password', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('152', '177', 'pjField', '1', 'title', 'Access denied', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('153', '178', 'pjField', '1', 'title', 'Account is disabled', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('154', '179', 'pjField', '1', 'title', 'January', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('155', '180', 'pjField', '1', 'title', 'October', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('156', '181', 'pjField', '1', 'title', 'November', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('157', '182', 'pjField', '1', 'title', 'December', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('158', '183', 'pjField', '1', 'title', 'February', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('159', '184', 'pjField', '1', 'title', 'March', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('160', '185', 'pjField', '1', 'title', 'April', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('161', '186', 'pjField', '1', 'title', 'May', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('162', '187', 'pjField', '1', 'title', 'June', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('163', '188', 'pjField', '1', 'title', 'July', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('164', '189', 'pjField', '1', 'title', 'August', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('165', '190', 'pjField', '1', 'title', 'September', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('166', '191', 'pjField', '1', 'title', 'Dr.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('167', '192', 'pjField', '1', 'title', 'Miss', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('168', '193', 'pjField', '1', 'title', 'Mr.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('169', '194', 'pjField', '1', 'title', 'Mrs.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('170', '195', 'pjField', '1', 'title', 'Ms.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('171', '196', 'pjField', '1', 'title', 'Other', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('172', '197', 'pjField', '1', 'title', 'Prof.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('173', '198', 'pjField', '1', 'title', 'Rev.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('174', '199', 'pjField', '1', 'title', 'Jan', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('175', '200', 'pjField', '1', 'title', 'Oct', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('176', '201', 'pjField', '1', 'title', 'Nov', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('177', '202', 'pjField', '1', 'title', 'Dec', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('178', '203', 'pjField', '1', 'title', 'Feb', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('179', '204', 'pjField', '1', 'title', 'Mar', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('180', '205', 'pjField', '1', 'title', 'Apr', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('181', '206', 'pjField', '1', 'title', 'May', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('182', '207', 'pjField', '1', 'title', 'Jun', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('183', '208', 'pjField', '1', 'title', 'Jul', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('184', '209', 'pjField', '1', 'title', 'Aug', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('185', '210', 'pjField', '1', 'title', 'Sep', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('186', '211', 'pjField', '1', 'title', 'You are not loged in.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('187', '212', 'pjField', '1', 'title', 'Your hosting account does not allow uploading such a large image.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('188', '213', 'pjField', '1', 'title', 'Access denied. You have not requisite rights to.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('189', '214', 'pjField', '1', 'title', 'Empty resultset.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('190', '215', 'pjField', '1', 'title', 'The operation is not allowed in demo mode.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('191', '216', 'pjField', '1', 'title', 'No property for the reservation found', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('192', '217', 'pjField', '1', 'title', 'No reservation found', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('193', '218', 'pjField', '1', 'title', 'No permisions to edit the reservation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('194', '219', 'pjField', '1', 'title', 'No permisions to edit the property', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('195', '220', 'pjField', '1', 'title', 'E-Mail address already exist', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('196', '221', 'pjField', '1', 'title', 'Your registration was successfull. Your account needs to be approved.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('197', '222', 'pjField', '1', 'title', 'Your registration was successfull.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('198', '223', 'pjField', '1', 'title', 'GMT-03:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('199', '224', 'pjField', '1', 'title', 'GMT-04:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('200', '225', 'pjField', '1', 'title', 'GMT-05:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('201', '226', 'pjField', '1', 'title', 'GMT-06:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('202', '227', 'pjField', '1', 'title', 'GMT-07:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('203', '228', 'pjField', '1', 'title', 'GMT-08:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('204', '229', 'pjField', '1', 'title', 'GMT-09:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('205', '230', 'pjField', '1', 'title', 'GMT-01:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('206', '231', 'pjField', '1', 'title', 'GMT-10:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('207', '232', 'pjField', '1', 'title', 'GMT-11:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('208', '233', 'pjField', '1', 'title', 'GMT-12:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('209', '234', 'pjField', '1', 'title', 'GMT-02:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('210', '235', 'pjField', '1', 'title', 'GMT', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('211', '236', 'pjField', '1', 'title', 'GMT+03:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('212', '237', 'pjField', '1', 'title', 'GMT+04:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('213', '238', 'pjField', '1', 'title', 'GMT+05:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('214', '239', 'pjField', '1', 'title', 'GMT+06:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('215', '240', 'pjField', '1', 'title', 'GMT+07:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('216', '241', 'pjField', '1', 'title', 'GMT+08:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('217', '242', 'pjField', '1', 'title', 'GMT+09:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('218', '243', 'pjField', '1', 'title', 'GMT+01:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('219', '244', 'pjField', '1', 'title', 'GMT+10:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('220', '245', 'pjField', '1', 'title', 'GMT+11:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('221', '246', 'pjField', '1', 'title', 'GMT+12:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('222', '247', 'pjField', '1', 'title', 'GMT+13:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('223', '248', 'pjField', '1', 'title', 'GMT+02:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('224', '249', 'pjField', '1', 'title', 'Inactive', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('225', '250', 'pjField', '1', 'title', 'Active', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('226', '251', 'pjField', '1', 'title', 'No', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('227', '252', 'pjField', '1', 'title', 'Yes', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('228', '253', 'pjField', '1', 'title', 'Delete selected', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('229', '254', 'pjField', '1', 'title', 'Are you sure that you want to delete selected record(s)?', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('230', '255', 'pjField', '1', 'title', 'All', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('231', '256', 'pjField', '1', 'title', 'Email address was already in use.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('232', '308', 'pjField', '1', 'title', 'Restaurant', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('233', '309', 'pjField', '1', 'title', 'Reservation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('234', '310', 'pjField', '1', 'title', 'Vouchers', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('235', '311', 'pjField', '1', 'title', 'Install', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('236', '312', 'pjField', '1', 'title', 'Preview', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('237', '313', 'pjField', '1', 'title', 'Last login', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('238', '314', 'pjField', '1', 'title', 'Time format', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('239', '315', 'pjField', '1', 'title', 'Reservation options', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('240', '316', 'pjField', '1', 'title', 'Modify the options below and click Save button.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('241', '318', 'pjField', '1', 'title', 'Reservation options updated', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('242', '319', 'pjField', '1', 'title', 'All changes made to the Reservation options have been saved.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('243', '320', 'pjField', '1', 'title', 'Deposit fee', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('244', '321', 'pjField', '1', 'title', 'set default reservation price', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('245', '322', 'pjField', '1', 'title', 'Default reservation length, value is in minutes', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('246', '323', 'pjField', '1', 'title', 'set the default reservation length, values in minutes', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('247', '324', 'pjField', '1', 'title', 'Reserve X hours earlier', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('248', '325', 'pjField', '1', 'title', 'how many hours earlier, you can reserve a table', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('249', '326', 'pjField', '1', 'title', 'All reservations which are only made but NOT paid will be set with the following status:', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('250', '327', 'pjField', '1', 'title', 'set the default status for each reservation after it is made', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('251', '328', 'pjField', '1', 'title', 'All reservations which are made and paid will be set with the following status:', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('252', '329', 'pjField', '1', 'title', 'set the default status for each reservation after payment is made for it', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('253', '330', 'pjField', '1', 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('254', '331', 'pjField', '1', 'title', 'this is the page where people will be redirected after paying', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('255', '332', 'pjField', '1', 'title', 'Select ''Yes'' if you want to disable payments and only collect reservation details', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('256', '333', 'pjField', '1', 'title', 'to disable payments and only accept reservations, set this to "Yes"', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('257', '334', 'pjField', '1', 'title', 'Allow payments with Paypal', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('258', '335', 'pjField', '1', 'title', 'PayPal business email address', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('259', '336', 'pjField', '1', 'title', 'Allow payments with Authorize.net', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('260', '337', 'pjField', '1', 'title', 'Authorize.net transaction key', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('261', '338', 'pjField', '1', 'title', 'Authorize.net merchant ID', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('262', '339', 'pjField', '1', 'title', 'Allow payment with cash', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('263', '340', 'pjField', '1', 'title', 'Collect Credit Card details for offline processing', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('264', '341', 'pjField', '1', 'title', 'Provide Bank account details for wire transfers', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('265', '342', 'pjField', '1', 'title', 'Bank Account', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('266', '343', 'pjField', '1', 'title', 'Reservation form', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('267', '344', 'pjField', '1', 'title', 'Confirmation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('268', '345', 'pjField', '1', 'title', 'Terms', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('269', '346', 'pjField', '1', 'title', 'Reminder', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('270', '347', 'pjField', '1', 'title', 'Email Confirmations', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('271', '348', 'pjField', '1', 'title', 'There are 4 types of email confirmations - one after reservation form is submitted , one after payment is made, one is enquiry email and one when cancelled the reservation. Use the available tokens to personalize the email messages.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('272', '349', 'pjField', '1', 'title', 'Notification email address', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('273', '350', 'pjField', '1', 'title', 'Send confirmation email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('274', '351', 'pjField', '1', 'title', 'select if and when confirmation email should be sent to clients after they make a reservation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('275', '352', 'pjField', '1', 'title', 'Confirmation email subject', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('276', '353', 'pjField', '1', 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{DtFrom}<br/>{Table}<br/>{People}<br/>{BookingID}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('277', '354', 'pjField', '1', 'title', 'Confirmation email message', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('278', '355', 'pjField', '1', 'title', 'Send payment confirmation email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('279', '356', 'pjField', '1', 'title', 'select if and when confirmation email should be sent to clients after they make a payment for their booking', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('280', '357', 'pjField', '1', 'title', 'Payment email message', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('281', '358', 'pjField', '1', 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{DtFrom}<br/>{Table}<br/>{People}<br/>{BookingID}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('282', '359', 'pjField', '1', 'title', 'Send enquiry email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('283', '360', 'pjField', '1', 'title', 'select if and when confirmation email should be sent to clients after they make a enquiry for booking', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('284', '361', 'pjField', '1', 'title', 'Enquiry email subject', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('285', '362', 'pjField', '1', 'title', 'Enquiry email message', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('286', '363', 'pjField', '1', 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{DtFrom}<br/>{People}<br/>{UniqueID}<br/>{CancelURL}<br/>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('287', '364', 'pjField', '1', 'title', 'Payment email subject', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('288', '365', 'pjField', '1', 'title', 'Send cancel email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('289', '366', 'pjField', '1', 'title', 'select if and when confirmation email should be sent to clients after they cancel for their booking', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('290', '367', 'pjField', '1', 'title', 'Cancel email subject', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('291', '368', 'pjField', '1', 'title', 'Cancel email message', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('292', '369', 'pjField', '1', 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{DtFrom}<br/>{Table}<br/>{People}<br/>{BookingID}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('293', '421', 'pjField', '1', 'title', 'Reservation Form Options', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('294', '422', 'pjField', '1', 'title', 'Choose the fields that should be available on the reservation form and click SAVE button.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('295', '423', 'pjField', '1', 'title', 'Title', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('296', '424', 'pjField', '1', 'title', 'Select "Yes" if you want to include the field on the reservation form, otherwise select "No"', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('297', '425', 'pjField', '1', 'title', 'First name', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('298', '426', 'pjField', '1', 'title', 'Last name', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('299', '427', 'pjField', '1', 'title', 'Phone', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('300', '428', 'pjField', '1', 'title', 'Email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('301', '429', 'pjField', '1', 'title', 'Company', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('302', '430', 'pjField', '1', 'title', 'Address', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('303', '431', 'pjField', '1', 'title', 'Notes', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('304', '432', 'pjField', '1', 'title', 'Voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('305', '433', 'pjField', '1', 'title', 'City', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('306', '434', 'pjField', '1', 'title', 'State', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('307', '435', 'pjField', '1', 'title', 'Zip', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('308', '436', 'pjField', '1', 'title', 'Country', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('309', '437', 'pjField', '1', 'title', 'Captcha', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('310', '438', 'pjField', '1', 'title', 'Terms and Conditions', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('311', '439', 'pjField', '1', 'title', 'Please write down the Terms and Conditions for making reservation and click SAVE button.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('312', '440', 'pjField', '1', 'title', 'Terms and Conditions', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('313', '441', 'pjField', '1', 'title', 'Enquiry', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('314', '442', 'pjField', '1', 'title', 'Reminder Options', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('315', '443', 'pjField', '1', 'title', 'Let set the options for Reminder and click SAVE button. It includes email notification and SMS message.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('316', '444', 'pjField', '1', 'title', 'Enable notifications', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('317', '445', 'pjField', '1', 'title', 'Send email reminder', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('318', '446', 'pjField', '1', 'title', 'Email Reminder subject', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('319', '447', 'pjField', '1', 'title', 'Email Reminder message', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('320', '448', 'pjField', '1', 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{DtFrom}<br/>{Table}<br/>{People}<br/>{BookingID}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('321', '449', 'pjField', '1', 'title', 'Send SMS reminder', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('322', '450', 'pjField', '1', 'title', 'SMS api key', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('323', '451', 'pjField', '1', 'title', 'SMS message', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('324', '452', 'pjField', '1', 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{DtFrom}<br/>{Table}<br/>{People}<br/>{BookingID}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('325', '453', 'pjField', '1', 'title', 'Cron script', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('326', '454', 'pjField', '1', 'title', 'You need to set up a cron job using your hosting account control panel which should execute every hour. Depending on your web server you should use either the URL or script path.<br /><br/>Server path:<br /><span class="bold">{PATH}</span><br /><br />URL:<br /><span class="bold">{URL}</span>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('327', '455', 'pjField', '1', 'title', 'hours before', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('328', '456', 'pjField', '1', 'title', 'Reservation Form Options Updated', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('329', '457', 'pjField', '1', 'title', 'Your settings for reservation form have been saved successfully.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('330', '458', 'pjField', '1', 'title', 'Confirmation Options Updated', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('331', '459', 'pjField', '1', 'title', 'Your settings for confirmation have been saved successfully.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('332', '460', 'pjField', '1', 'title', 'Terms and Conditions updated', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('333', '461', 'pjField', '1', 'title', 'All changes you made on the Terms and Conditions options have been saved.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('334', '462', 'pjField', '1', 'title', 'Reminder updated', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('335', '463', 'pjField', '1', 'title', 'Your settings for reminder options have been saved successfully.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('336', '464', 'pjField', '1', 'title', 'get key', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('337', '555', 'pjField', '1', 'title', 'Voucher code', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('338', '556', 'pjField', '1', 'title', 'Discount', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('339', '558', 'pjField', '1', 'title', 'Valid', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('340', '559', 'pjField', '1', 'title', 'Add voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('341', '560', 'pjField', '1', 'title', 'Voucher List', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('342', '561', 'pjField', '1', 'title', 'Below is the list of vouchers. If you wan to add new voucher, click on the "Add voucher" Tab. To edit or delete a certain voucher, click on corresponding icons on the row. You can also export the list of vouchers or delete multiple selected vouchers by using the popup menu at the bottom of the table.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('343', '562', 'pjField', '1', 'title', 'The voucher code is already used.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('344', '563', 'pjField', '1', 'title', 'Add Voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('345', '564', 'pjField', '1', 'title', 'Please fill out the form below to add voucher code and discount. You can add a voucher for specific date, day of the week or date range.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('346', '565', 'pjField', '1', 'title', 'Amount', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('347', '566', 'pjField', '1', 'title', 'Percent', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('348', '567', 'pjField', '1', 'title', 'Fixed', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('349', '568', 'pjField', '1', 'title', 'Period', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('350', '569', 'pjField', '1', 'title', 'Recurring', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('351', '570', 'pjField', '1', 'title', 'Date', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('352', '571', 'pjField', '1', 'title', 'Time from', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('353', '572', 'pjField', '1', 'title', 'Time to', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('354', '573', 'pjField', '1', 'title', 'From date/time', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('355', '574', 'pjField', '1', 'title', 'To date/time', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('356', '575', 'pjField', '1', 'title', 'Monday', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('357', '576', 'pjField', '1', 'title', 'Tuesday', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('358', '577', 'pjField', '1', 'title', 'Wednesday', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('359', '578', 'pjField', '1', 'title', 'Thursday', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('360', '579', 'pjField', '1', 'title', 'Friday', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('361', '580', 'pjField', '1', 'title', 'Saturday', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('362', '581', 'pjField', '1', 'title', 'Sunday', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('363', '582', 'pjField', '1', 'title', 'Every', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('364', '583', 'pjField', '1', 'title', 'Voucher updated', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('365', '584', 'pjField', '1', 'title', 'All changes made to the voucher have been saved.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('366', '585', 'pjField', '1', 'title', 'Voucher added', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('367', '586', 'pjField', '1', 'title', 'A new voucher has been added to the list. You can now add another voucher.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('368', '587', 'pjField', '1', 'title', 'Voucher failed to add', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('369', '588', 'pjField', '1', 'title', 'We sorry that the voucher could not bee added successfully.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('370', '589', 'pjField', '1', 'title', 'Voucher not found', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('371', '590', 'pjField', '1', 'title', 'Voucher you are looking for is missing.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('372', '591', 'pjField', '1', 'title', 'Update voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('373', '592', 'pjField', '1', 'title', 'Update voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('374', '593', 'pjField', '1', 'title', 'Please make any change you want on the form below to update voucher information and click SAVE button.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('375', '594', 'pjField', '1', 'title', 'Working Time', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('376', '595', 'pjField', '1', 'title', 'Seat Map', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('377', '596', 'pjField', '1', 'title', 'Tables', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('378', '597', 'pjField', '1', 'title', 'Default', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('379', '598', 'pjField', '1', 'title', 'Custom', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('380', '599', 'pjField', '1', 'title', 'Day of Week', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('381', '600', 'pjField', '1', 'title', 'Start Time', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('382', '601', 'pjField', '1', 'title', 'End Time', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('383', '602', 'pjField', '1', 'title', 'Is Day off', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('384', '603', 'pjField', '1', 'title', 'Working Time Updated', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('385', '604', 'pjField', '1', 'title', 'All changes made to the working time have been saved.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('386', '605', 'pjField', '1', 'title', 'Custom working time saved', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('387', '606', 'pjField', '1', 'title', 'Custom working time has been saved successfully.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('388', '697', 'pjField', '1', 'title', 'Map', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('389', '698', 'pjField', '1', 'title', 'Options', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('390', '699', 'pjField', '1', 'title', 'Seat Map', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('391', '700', 'pjField', '1', 'title', 'Check ''Use seat map'' checkbox to enable map table selection. You need to upload a JPG image map of your restaurant. Once image is uploaded click on the map to create a click-able hot spot for each table. You can click on each hot spot and position it on the map. To delete a hot spot click on it and then click on ''Delete'' button. To rename a hot spot (table) and set people capacity just click on it.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('392', '701', 'pjField', '1', 'title', 'Hot spot sizes', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('393', '702', 'pjField', '1', 'title', 'Below you can set the size for the hot spots that you create on the map. You can create different sized hot spots on each map. Just enter the desired size, click on Save button and go to Update map tab to create the new hot spot. Visit <a href="http://www.phpjabbers.com/knowledgebase.php?product=134" target="_blank">Knowledgebase</a> to watch video showing how to create a map.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('394', '703', 'pjField', '1', 'title', 'Use seat map', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('395', '704', 'pjField', '1', 'title', 'File', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('396', '705', 'pjField', '1', 'title', 'Delete this image file', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('397', '706', 'pjField', '1', 'title', 'Are you sure you want to delete this image file? If yes, the image file will be deleted and will not be possible to restore it.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('398', '707', 'pjField', '1', 'title', 'Update Map', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('399', '708', 'pjField', '1', 'title', 'Add a custom name for this spot on the map (VIP sector, Sector A, etc..). Also set how many available seats can be reserved in this sector.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('400', '709', 'pjField', '1', 'title', 'Capacity', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('401', '710', 'pjField', '1', 'title', 'Minimum', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('402', '711', 'pjField', '1', 'title', 'Map settings updated', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('403', '712', 'pjField', '1', 'title', 'All settings made to the map have been saved.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('404', '713', 'pjField', '1', 'title', 'You are using a seat map.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('405', '714', 'pjField', '1', 'title', 'Width', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('406', '715', 'pjField', '1', 'title', 'Height', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('407', '716', 'pjField', '1', 'title', 'Table list', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('408', '717', 'pjField', '1', 'title', 'Add table', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('409', '718', 'pjField', '1', 'title', 'Add new table', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('410', '719', 'pjField', '1', 'title', 'Add new table and set number of people allowed to reserve a table. For example if Minimum is set to 2 and Capacity is set to 4 then only reservation for 2, 3 or 4 people will be accepted for this table.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('411', '720', 'pjField', '1', 'title', 'Table name was already used.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('412', '721', 'pjField', '1', 'title', 'Table added', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('413', '722', 'pjField', '1', 'title', 'A new table has been added to the list.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('414', '723', 'pjField', '1', 'title', 'Table failed to add', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('415', '724', 'pjField', '1', 'title', 'We are sorry that the table could not be added successfully.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('416', '725', 'pjField', '1', 'title', 'Table updated', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('417', '726', 'pjField', '1', 'title', 'All changes made to the table have been saved.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('418', '727', 'pjField', '1', 'title', 'Table not found', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('419', '728', 'pjField', '1', 'title', 'The table you are looking for is missing.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('420', '729', 'pjField', '1', 'title', 'Update table', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('421', '730', 'pjField', '1', 'title', 'Update table', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('422', '731', 'pjField', '1', 'title', 'On the for below you can set number of people allowed to reserve a table. For example if Minimum is set to 2 and Capacity is set to 4 then only reservation for 2, 3 or 4 people will be accepted for this table.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('423', '732', 'pjField', '1', 'title', 'Update', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('424', '733', 'pjField', '1', 'title', 'Schedule', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('425', '734', 'pjField', '1', 'title', 'Reservations List', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('426', '735', 'pjField', '1', 'title', 'Print', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('427', '736', 'pjField', '1', 'title', 'Filter', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('428', '737', 'pjField', '1', 'title', 'No tables found', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('429', '738', 'pjField', '1', 'title', '%s is day off', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('430', '739', 'pjField', '1', 'title', 'Confirmed', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('431', '740', 'pjField', '1', 'title', 'Cancelled', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('432', '741', 'pjField', '1', 'title', 'Pending', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('433', '742', 'pjField', '1', 'title', 'Enquiry', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('434', '743', 'pjField', '1', 'title', 'From date/time', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('435', '744', 'pjField', '1', 'title', 'Date/time format', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('436', '745', 'pjField', '1', 'title', 'Date from', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('437', '746', 'pjField', '1', 'title', 'Date to', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('438', '747', 'pjField', '1', 'title', 'Table', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('439', '748', 'pjField', '1', 'title', 'Phone', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('440', '749', 'pjField', '1', 'title', 'Reservation not found', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('441', '750', 'pjField', '1', 'title', 'We are sorry that the reservation you are looking for is missing.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('442', '751', 'pjField', '1', 'title', 'Reservation Details', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('443', '752', 'pjField', '1', 'title', 'Client Details', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('444', '753', 'pjField', '1', 'title', 'Update Reservation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('445', '754', 'pjField', '1', 'title', 'Unique ID', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('446', '755', 'pjField', '1', 'title', 'Deposit paid', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('447', '756', 'pjField', '1', 'title', 'Yes', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('448', '757', 'pjField', '1', 'title', 'No', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('449', '758', 'pjField', '1', 'title', 'Paypal', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('450', '759', 'pjField', '1', 'title', 'Authorize.net', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('451', '760', 'pjField', '1', 'title', 'Credit Card', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('452', '761', 'pjField', '1', 'title', 'Cash', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('453', '762', 'pjField', '1', 'title', 'Bank Account', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('454', '763', 'pjField', '1', 'title', 'Payment method', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('455', '764', 'pjField', '1', 'title', 'CC type', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('456', '765', 'pjField', '1', 'title', 'Visa', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('457', '766', 'pjField', '1', 'title', 'MasterCard', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('458', '767', 'pjField', '1', 'title', 'Maestro', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('459', '768', 'pjField', '1', 'title', 'AmericanExpress', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('460', '769', 'pjField', '1', 'title', 'CC number', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('461', '770', 'pjField', '1', 'title', 'CC expiration date', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('462', '771', 'pjField', '1', 'title', 'CC security code', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('463', '772', 'pjField', '1', 'title', 'Total', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('464', '773', 'pjField', '1', 'title', 'People', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('465', '774', 'pjField', '1', 'title', 'Table name', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('466', '775', 'pjField', '1', 'title', 'View availability', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('467', '776', 'pjField', '1', 'title', 'Availability', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('468', '777', 'pjField', '1', 'title', 'Mr', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('469', '778', 'pjField', '1', 'title', 'Mrs', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('470', '779', 'pjField', '1', 'title', 'Ms', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('471', '780', 'pjField', '1', 'title', 'Dr', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('472', '781', 'pjField', '1', 'title', 'Prof', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('473', '782', 'pjField', '1', 'title', 'Rev', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('474', '783', 'pjField', '1', 'title', 'Other', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('475', '784', 'pjField', '1', 'title', 'Title', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('476', '785', 'pjField', '1', 'title', 'First name', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('477', '786', 'pjField', '1', 'title', 'Last name', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('478', '787', 'pjField', '1', 'title', 'Phone', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('479', '788', 'pjField', '1', 'title', 'Email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('480', '789', 'pjField', '1', 'title', 'Notes', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('481', '790', 'pjField', '1', 'title', 'Company name', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('482', '791', 'pjField', '1', 'title', 'Address', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('483', '792', 'pjField', '1', 'title', 'City', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('484', '793', 'pjField', '1', 'title', 'County/Region/State', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('485', '794', 'pjField', '1', 'title', 'Postcode/Zip', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('486', '795', 'pjField', '1', 'title', 'Country', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('487', '796', 'pjField', '1', 'title', 'Reservation updated', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('488', '797', 'pjField', '1', 'title', 'All changes made to the reservation have been saved.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('489', '798', 'pjField', '1', 'title', 'Print Reservation Details', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('490', '799', 'pjField', '1', 'title', 'Re-send confirmation email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('491', '800', 'pjField', '1', 'title', 'ID', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('492', '801', 'pjField', '1', 'title', 'Created', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('493', '802', 'pjField', '1', 'title', 'Paypal Transaction ID', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('494', '803', 'pjField', '1', 'title', 'Processed on', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('495', '805', 'pjField', '1', 'title', 'Reminder email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('496', '806', 'pjField', '1', 'title', 'You can make any change on the form below and click SEND button to send the reminder message.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('497', '807', 'pjField', '1', 'title', 'To', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('498', '808', 'pjField', '1', 'title', 'Subject', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('499', '809', 'pjField', '1', 'title', 'Message', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('500', '810', 'pjField', '1', 'title', 'Reminder email sent', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('501', '811', 'pjField', '1', 'title', 'The reminder email has been sent to the give email address.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('502', '812', 'pjField', '1', 'title', 'Reminder failed to send', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('503', '813', 'pjField', '1', 'title', 'The reminder email could not be sent successfully. Please check again.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('504', '814', 'pjField', '1', 'title', 'Client name', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('505', '815', 'pjField', '1', 'title', 'Person', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('506', '816', 'pjField', '1', 'title', 'No reservations found', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('507', '817', 'pjField', '1', 'title', 'Print', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('508', '818', 'pjField', '1', 'title', 'Install code', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('509', '819', 'pjField', '1', 'title', 'Copy the code below and put it on your web page. It will show the front end booking engine. Please, note that the code should be used on a web page from the same domain name where script is installed.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('510', '820', 'pjField', '1', 'title', 'Language options', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('511', '821', 'pjField', '1', 'title', 'Language', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('512', '822', 'pjField', '1', 'title', 'Hide language selector', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('513', '823', 'pjField', '1', 'title', 'Step 1 (Required)', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('514', '824', 'pjField', '1', 'title', 'Select date and time for your reservation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('515', '825', 'pjField', '1', 'title', 'Date', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('516', '826', 'pjField', '1', 'title', 'Time', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('517', '827', 'pjField', '1', 'title', 'People', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('518', '828', 'pjField', '1', 'title', 'Check Availability', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('519', '829', 'pjField', '1', 'title', 'Available tables for %1s person(s) on %2s at %3s. Click on a table to book it.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('520', '830', 'pjField', '1', 'title', 'Book', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('521', '831', 'pjField', '1', 'title', 'Send Enquiry', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('522', '832', 'pjField', '1', 'title', 'There is no table available. Click on SEND ENQUIRY button to make an enquiry.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('523', '833', 'pjField', '1', 'title', 'Selected table', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('524', '834', 'pjField', '1', 'title', 'Booking details', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('525', '835', 'pjField', '1', 'title', 'Reservation form<br/><span>fill the form to reserve a table</span>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('526', '926', 'pjField', '1', 'title', 'Date and time', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('527', '927', 'pjField', '1', 'title', 'Table for %s person(s)', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('528', '928', 'pjField', '1', 'title', 'change selection', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('529', '929', 'pjField', '1', 'title', 'Title', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('530', '930', 'pjField', '1', 'title', 'First name', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('531', '931', 'pjField', '1', 'title', 'Last name', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('532', '932', 'pjField', '1', 'title', 'Phone', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('533', '933', 'pjField', '1', 'title', 'Email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('534', '934', 'pjField', '1', 'title', 'Company name', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('535', '935', 'pjField', '1', 'title', 'Notes', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('536', '936', 'pjField', '1', 'title', 'Address', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('537', '937', 'pjField', '1', 'title', 'City', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('538', '938', 'pjField', '1', 'title', 'State', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('539', '939', 'pjField', '1', 'title', 'Zip', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('540', '940', 'pjField', '1', 'title', 'Country', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('541', '941', 'pjField', '1', 'title', 'Checkout', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('542', '942', 'pjField', '1', 'title', 'discount', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('543', '943', 'pjField', '1', 'title', 'Payment is required to secure your reservation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('544', '944', 'pjField', '1', 'title', 'Price', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('545', '945', 'pjField', '1', 'title', 'Voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('546', '946', 'pjField', '1', 'title', 'Add Voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('547', '947', 'pjField', '1', 'title', 'Added voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('548', '948', 'pjField', '1', 'title', 'Remove voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('549', '949', 'pjField', '1', 'title', 'Invalid voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('550', '950', 'pjField', '1', 'title', 'Payment method', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('551', '951', 'pjField', '1', 'title', 'CC type', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('552', '952', 'pjField', '1', 'title', 'CC number', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('553', '953', 'pjField', '1', 'title', 'CC expiration date', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('554', '954', 'pjField', '1', 'title', 'CC security code', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('555', '955', 'pjField', '1', 'title', 'Captcha', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('556', '1046', 'pjField', '1', 'title', 'This field is required.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('557', '1047', 'pjField', '1', 'title', 'Email is not valid.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('558', '1048', 'pjField', '1', 'title', 'Captcha is not correct.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('559', '1049', 'pjField', '1', 'title', 'Expiration month is required.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('560', '1050', 'pjField', '1', 'title', 'Expiration year is required.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('561', '1051', 'pjField', '1', 'title', 'I have read and accept reservation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('562', '1052', 'pjField', '1', 'title', 'Terms and Conditions', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('563', '1053', 'pjField', '1', 'title', 'Reservation summary<br/><span>detail information</span>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('564', '1054', 'pjField', '1', 'title', 'Confirm Reservation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('565', '1055', 'pjField', '1', 'title', 'Back', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('566', '1056', 'pjField', '1', 'title', 'Reservation failed to save.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('567', '1057', 'pjField', '1', 'title', 'Your reservation is saved. Redirecting to PayPal...', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('568', '1058', 'pjField', '1', 'title', 'Your reservation is saved. Redirecting to Authorize.net...', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('569', '1059', 'pjField', '1', 'title', 'Your reservation is saved. [STAG]Start over[ETAG].', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('570', '1060', 'pjField', '1', 'title', 'Your enquiry has been sent. [STAG]Start over[ETAG].', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('571', '1061', 'pjField', '1', 'title', 'Reservation is being processed...', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('572', '1062', 'pjField', '1', 'title', 'Error! Some parameters are missing. ', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('573', '1063', 'pjField', '1', 'title', 'Restaurant Reservations', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('574', '1064', 'pjField', '1', 'title', 'Cancel Reservation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('575', '1065', 'pjField', '1', 'title', 'Missing parameters', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('576', '1066', 'pjField', '1', 'title', 'Reservation with such ID does not exist.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('577', '1067', 'pjField', '1', 'title', 'Security hash did not match', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('578', '1068', 'pjField', '1', 'title', 'Reservation is already cancelled.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('579', '1069', 'pjField', '1', 'title', 'Reservation has been cancelled successfully.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('580', '1070', 'pjField', '1', 'title', 'Your reservation details', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('581', '1071', 'pjField', '1', 'title', 'Date/Time From', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('582', '1072', 'pjField', '1', 'title', 'People', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('583', '1073', 'pjField', '1', 'title', 'Promo code', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('584', '1074', 'pjField', '1', 'title', 'Title', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('585', '1075', 'pjField', '1', 'title', 'Description', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('586', '1076', 'pjField', '1', 'title', 'Date/time', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('587', '1077', 'pjField', '1', 'title', 'First name', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('588', '1078', 'pjField', '1', 'title', 'Last name', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('589', '1079', 'pjField', '1', 'title', 'Email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('590', '1080', 'pjField', '1', 'title', 'Phone', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('591', '1081', 'pjField', '1', 'title', 'Company', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('592', '1082', 'pjField', '1', 'title', 'Country', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('593', '1083', 'pjField', '1', 'title', 'City', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('594', '1084', 'pjField', '1', 'title', 'State', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('595', '1085', 'pjField', '1', 'title', 'Zip', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('596', '1086', 'pjField', '1', 'title', 'Address', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('597', '1087', 'pjField', '1', 'title', 'Payment', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('598', '1088', 'pjField', '1', 'title', 'Total', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('599', '1089', 'pjField', '1', 'title', 'Table', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('600', '1090', 'pjField', '1', 'title', 'Cancel Reservation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('601', '1091', 'pjField', '1', 'title', 'Personal Details', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('602', '1182', 'pjField', '1', 'title', 'Cancel', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('603', '1183', 'pjField', '1', 'title', '%1s available table(s) found.<br/>click on a table to reserve it', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('604', '1184', 'pjField', '1', 'title', 'Loading tables ...', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('605', '1185', 'pjField', '1', 'title', 'Working Time Settings', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('606', '1186', 'pjField', '1', 'title', 'Below is the form to set the working time for the restaurant. You can also set different settings for some specific dates by clicking on the Tab Custom.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('607', '1187', 'pjField', '1', 'title', 'There is no working time for day off.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('608', '1188', 'pjField', '1', 'title', 'Today', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('609', '1189', 'pjField', '1', 'title', 'Tomorrow', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('610', '1190', 'pjField', '1', 'title', 'The selected date is day off.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('611', '1191', 'pjField', '1', 'title', 'You must reserve [HOUR] hours before.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('612', '1192', 'pjField', '1', 'title', 'We are not open yet.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('613', '1193', 'pjField', '1', 'title', 'We are close.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('614', '1194', 'pjField', '1', 'title', 'Authorize.net time zone', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('615', '1195', 'pjField', '1', 'title', 'Authorize.net MD5 hash', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('616', '1196', 'pjField', '1', 'title', 'Table / Hour', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('617', '1198', 'pjField', '1', 'title', 'Add Reservation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('618', '1199', 'pjField', '1', 'title', 'Price', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('619', '1202', 'pjField', '1', 'title', 'Reservation Added', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('620', '1203', 'pjField', '1', 'title', 'A new reservation has been added to the list.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('621', '1204', 'pjField', '1', 'title', 'Reservation could not be added.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('622', '1206', 'pjField', '1', 'title', 'Cancel', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('623', '1297', 'pjField', '1', 'title', 'General', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('624', '1388', 'pjField', '1', 'title', 'Reservations', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('625', '1389', 'pjField', '1', 'title', 'Client', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('626', '1390', 'pjField', '1', 'title', 'Administrator', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('627', '1391', 'pjField', '1', 'title', 'Please send an enquiry and we will manually confirm your reservation.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('628', '1392', 'pjField', '1', 'title', 'Back', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('629', '1393', 'pjField', '1', 'title', 'Error! Please, [STAG]start over[ETAG]', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('630', '1394', 'pjField', '1', 'title', 'Deposit fee', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('631', '1395', 'pjField', '1', 'title', 'Schedule', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('632', '1396', 'pjField', '1', 'title', 'By default below you see today''s schedule. Use the date picker to switch to any date. You can also print the schedule by clicking on the Print button.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('633', '1397', 'pjField', '1', 'title', 'Add new reservation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('634', '1398', 'pjField', '1', 'title', 'Fill in the form below to add a new reservation.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('635', '1399', 'pjField', '1', 'title', 'Update reservation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('636', '1400', 'pjField', '1', 'title', 'Update reservation details', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('637', '1401', 'pjField', '1', 'title', 'Reservations list', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('638', '1402', 'pjField', '1', 'title', 'Below you can see all the reservations and enquiries made. Click on any of them to view and edit it. Using the buttons you can filter the reservation by their status. Use the advance search to quickly locate a reservation.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('639', '1494', 'pjField', '1', 'title', 'Email Confirmations', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('640', '1495', 'pjField', '1', 'title', 'There are 4 types of email confirmations - one after reservation form is submitted , one after payment is made, one is enquiry email and one when cancelled the reservation. Use the available tokens to personalize the email messages.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('641', '1498', 'pjField', '1', 'title', 'Made on', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('642', '1499', 'pjField', '1', 'title', 'IP address', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('643', '1500', 'pjField', '1', 'title', 'Cancel reservation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('644', '1501', 'pjField', '1', 'title', 'CRON job completed.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('645', '1502', 'pjField', '1', 'title', 'Please enter positive number.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('646', '1503', 'pjField', '1', 'title', 'Minimum cannot be greater than capacity.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('647', '1504', 'pjField', '1', 'title', 'Unique ID was used.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('648', '1505', 'pjField', '1', 'title', 'End time must be greater than start time.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('649', '1506', 'pjField', '1', 'title', 'To date/time must be greater than From date/time.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('650', '1507', 'pjField', '1', 'title', 'Price after discount applied', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('651', '1508', 'pjField', '1', 'title', 'This field is required.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('652', '1509', 'pjField', '1', 'title', 'To date/time must be greater than From date/time.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('653', '1510', 'pjField', '1', 'title', 'Voucher is out of range date or time.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('654', '1511', 'pjField', '1', 'title', 'Reservation ID', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('655', '1', 'pjOption', '1', 'o_reminder_subject', 'Booking Reminder', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('656', '1', 'pjOption', '1', 'o_reminder_body', 'You''ve just made a booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nDate/Time From: {DtFrom}\r\nTable: {Table}\r\nPeople: {People}\r\nBooking ID: {BookingID}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('657', '1', 'pjOption', '1', 'o_reminder_sms_message', '{FirstName}, booking reminder\r\n\r\n{Table}', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('658', '1', 'pjOption', '1', 'o_terms', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse eu ipsum consectetur arcu commodo egestas nec eu ante. Aenean nec enim lorem. Proin accumsan luctus luctus. Vivamus pulvinar mollis orci, id convallis eros ultricies vel. Nullam adipiscing, risus non pellentesque aliquam, nibh ligula dictum justo, quis commodo nisi dolor ut nulla. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam ante leo, ultricies quis gravida id, vestibulum nec risus. Mauris adipiscing vestibulum nibh non ullamcorper. Suspendisse justo turpis, mattis a cursus ac, vulputate quis metus. Fusce vestibulum faucibus dignissim. Aliquam fermentum mauris felis, a ultrices sem.', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('659', '1', 'pjOption', '1', 'o_enquiry', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse eu ipsum consectetur arcu commodo egestas nec eu ante. Aenean nec enim lorem. Proin accumsan luctus luctus. Vivamus pulvinar mollis orci, id convallis eros ultricies vel. Nullam adipiscing, risus non pellentesque aliquam, nibh ligula dictum justo, quis commodo nisi dolor ut nulla. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam ante leo, ultricies quis gravida id, vestibulum nec risus. Mauris adipiscing vestibulum nibh non ullamcorper. Suspendisse justo turpis, mattis a cursus ac, vulputate quis metus. Fusce vestibulum faucibus dignissim. Aliquam fermentum mauris felis, a ultrices sem.', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('660', '1', 'pjOption', '1', 'o_email_confirmation_subject', 'Confirmation message', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('661', '1', 'pjOption', '1', 'o_email_confirmation_message', 'You''ve just made a booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nDate/Time From: {DtFrom}\r\nTable: {Table}\r\nPeople: {People}\r\nBooking ID: {BookingID}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('662', '1', 'pjOption', '1', 'o_email_payment_subject', 'Payment message', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('663', '1', 'pjOption', '1', 'o_email_payment_message', 'You''ve just made a booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nDate/Time From: {DtFrom}\r\nTable: {Table}\r\nPeople: {People}\r\nBooking ID: {BookingID}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('664', '1', 'pjOption', '1', 'o_email_cancel_subject', 'Cancel booking message', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('665', '1', 'pjOption', '1', 'o_email_cancel_message', 'You''ve just cancel a booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nDate/Time From: {DtFrom}\r\nTable: {Table}\r\nPeople: {People}\r\nBooking ID: {BookingID}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nThank you!', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('666', '1', 'pjOption', '1', 'o_email_enquiry_subject', 'Enquiry message', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('667', '1', 'pjOption', '1', 'o_email_enquiry_message', 'You''ve just made an enquiry.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nEnquiry details:\r\nDate/Time From: {DtFrom}\r\nPeople: {People}\r\nUnique ID: {UniqueID}\r\n\r\nIf you want to cancel your enquiry follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('668', '1', 'pjOption', '1', 'o_admin_email_confirmation_subject', 'Confirmation message', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('669', '1', 'pjOption', '1', 'o_admin_email_confirmation_message', 'You''ve just received a booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nDate/Time From: {DtFrom}\r\nTable: {Table}\r\nPeople: {People}\r\nBooking ID: {BookingID}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nThank you!', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('670', '1', 'pjOption', '1', 'o_admin_email_payment_subject', 'Payment message', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('671', '1', 'pjOption', '1', 'o_admin_email_payment_message', 'You''ve just receive the payment for the following booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nDate/Time From: {DtFrom}\r\nTable: {Table}\r\nPeople: {People}\r\nBooking ID: {BookingID}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\n\r\nThank you!', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('672', '1', 'pjOption', '1', 'o_admin_email_enquiry_subject', 'Enquiry message', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('673', '1', 'pjOption', '1', 'o_admin_email_enquiry_message', 'You''ve just received an enquiry.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nEnquiry details:\r\nDate/Time From: {DtFrom}\r\nPeople: {People}\r\nUnique ID: {UniqueID}\r\n\r\n\r\nThank you!', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('674', '1', 'pjOption', '1', 'o_admin_email_cancel_subject', 'Cancel booking message', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('675', '1', 'pjOption', '1', 'o_admin_email_cancel_message', 'A booking has been cancelled.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nDate/Time From: {DtFrom}\r\nTable: {Table}\r\nPeople: {People}\r\nBooking ID: {BookingID}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nThank you!', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('676', '1512', 'pjField', '1', 'title', 'Languages', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('677', '1513', 'pjField', '1', 'title', 'Translate', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('678', '1514', 'pjField', '1', 'title', 'Languages', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('679', '1515', 'pjField', '1', 'title', 'Add as many languages as you need to your script. For each of the languages added you need to translate all the text titles.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('680', '1516', 'pjField', '1', 'title', 'Titles', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('681', '1517', 'pjField', '1', 'title', 'Using the form below you can edit all the text in the software.<br /><br />Each piece of text used in the software is saved in the database and has its own unique ID. In the first column below you can see the ID for each piece of text. To show these IDs in the script itself check the "Show IDs" checkbox and click Save button next to it. This will show the corresponding :ID: for each text message. Please, note that ONLY you will see these IDs. Now you can search for any ID and easily change and/or translate the text. Have in mind that you should use : before and after the ID when you search for it.  <br /><br />Check our <a target="_blank" href="http://www.phpjabbers.com/knowledgebase/other">knowledgebase</a> and watch video tutorial how to change and/or translate the text.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('682', '1518', 'pjField', '1', 'title', 'Title', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('683', '1519', 'pjField', '1', 'title', 'Flag', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('684', '1520', 'pjField', '1', 'title', 'Is default', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('685', '1521', 'pjField', '1', 'title', 'Order', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('686', '1522', 'pjField', '1', 'title', 'Add Language', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('687', '1523', 'pjField', '1', 'title', 'Field', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('688', '1524', 'pjField', '1', 'title', 'Value', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('689', '1525', 'pjField', '1', 'title', 'Back-end title', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('690', '1526', 'pjField', '1', 'title', 'Front-end title', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('691', '1527', 'pjField', '1', 'title', 'Special title', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('692', '1528', 'pjField', '1', 'title', 'Titles Updated', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('693', '1529', 'pjField', '1', 'title', 'All the changes made to titles have been saved.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('694', '1530', 'pjField', '1', 'title', 'Per page', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('695', '1531', 'pjField', '1', 'title', 'Import error', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('696', '1532', 'pjField', '1', 'title', 'Import failed due missing parameters.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('697', '1533', 'pjField', '1', 'title', 'Import complete', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('698', '1534', 'pjField', '1', 'title', 'The import was performed successfully.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('699', '1535', 'pjField', '1', 'title', 'Import error', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('700', '1536', 'pjField', '1', 'title', 'Import failed due empty data.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('701', '1537', 'pjField', '1', 'title', 'Import error', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('702', '1538', 'pjField', '1', 'title', 'Import failed because file cannot be open.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('703', '1539', 'pjField', '1', 'title', 'Import / Export', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('704', '1540', 'pjField', '1', 'title', 'Import', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('705', '1541', 'pjField', '1', 'title', 'Export', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('706', '1542', 'pjField', '1', 'title', 'Browse your computer', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('707', '1543', 'pjField', '1', 'title', 'Import / Export', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('708', '1544', 'pjField', '1', 'title', 'Use the form below to Import or Export CSV with all titles. Please, do not change first row and first and second column in the CSV file.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('709', '1545', 'pjField', '1', 'title', 'ID:', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('710', '1546', 'pjField', '1', 'title', 'Show IDs', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('711', '1547', 'pjField', '1', 'title', 'Delimiter', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('712', '1548', 'pjField', '1', 'title', 'Comma', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('713', '1549', 'pjField', '1', 'title', 'Semicolon', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('714', '1550', 'pjField', '1', 'title', 'Tab', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('715', '1551', 'pjField', '1', 'title', 'The following languages have been found. Select those you want to import.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('716', '1552', 'pjField', '1', 'title', 'Import confirmation', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('717', '1553', 'pjField', '1', 'title', 'Import failed', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('718', '1554', 'pjField', '1', 'title', 'Missing, empty or invalid parameters.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('719', '1555', 'pjField', '1', 'title', 'Import failed', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('720', '1556', 'pjField', '1', 'title', 'File have not been uploaded.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('721', '1557', 'pjField', '1', 'title', 'Import failed', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('722', '1558', 'pjField', '1', 'title', 'Uploaded file cannot open for reading.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('723', '1559', 'pjField', '1', 'title', 'Import failed', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('724', '1560', 'pjField', '1', 'title', 'New line(s) have been found.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('725', '1561', 'pjField', '1', 'title', 'Import failed', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('726', '1562', 'pjField', '1', 'title', 'Uploaded file doesn''t contain the necessary columns.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('727', '1563', 'pjField', '1', 'title', 'Import failed', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('728', '1564', 'pjField', '1', 'title', 'Number of columns are not equal on every row.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('729', '1565', 'pjField', '1', 'title', 'Import failed', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('730', '1566', 'pjField', '1', 'title', 'Invalid data found.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('731', '1567', 'pjField', '1', 'title', 'Import failed', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('732', '1568', 'pjField', '1', 'title', 'Missing columns.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('733', '1569', 'pjField', '1', 'title', 'Import failed', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('734', '1570', 'pjField', '1', 'title', 'Invalid data found.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('735', '1571', 'pjField', '1', 'title', 'Show IDs', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('736', '1572', 'pjField', '1', 'title', 'ID will be displayed next to each text found in the software. You can then search for an ID to easily change or translate the text.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('737', '1573', 'pjField', '1', 'title', 'Confirm', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('738', '1574', 'pjField', '1', 'title', 'Cancel', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('739', '1575', 'pjField', '1', 'title', 'default', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('740', '1576', 'pjField', '1', 'title', 'Text direction', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('741', '1577', 'pjField', '1', 'title', 'Front-end title', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('742', '1578', 'pjField', '1', 'title', 'Left to Right', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('743', '1579', 'pjField', '1', 'title', 'Right to Left', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('744', '1580', 'pjField', '1', 'title', 'Reset flag', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('745', '1581', 'pjField', '1', 'title', 'Are you sure you want to reset selected flag?', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('746', '1582', 'pjField', '1', 'title', 'Reset', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('747', '1583', 'pjField', '1', 'title', 'Click to upload', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('748', '1584', 'pjField', '1', 'title', 'Click to reset', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('749', '1585', 'pjField', '1', 'title', 'Language', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('750', '1586', 'pjField', '1', 'title', 'Close', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('751', '1587', 'pjField', '1', 'title', 'Info message', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('752', '1588', 'pjField', '1', 'title', 'The error was found at line: %s', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('753', '1589', 'pjField', '1', 'title', 'Reset search', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('754', '1590', 'pjField', '1', 'title', 'Backup', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('755', '1591', 'pjField', '1', 'title', 'Backup complete!', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('756', '1592', 'pjField', '1', 'title', 'Backup failed!', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('757', '1593', 'pjField', '1', 'title', 'Backup failed!', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('758', '1594', 'pjField', '1', 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('759', '1595', 'pjField', '1', 'title', 'All backup files have been saved.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('760', '1596', 'pjField', '1', 'title', 'No option was selected.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('761', '1597', 'pjField', '1', 'title', 'Backup not performed.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('762', '1598', 'pjField', '1', 'title', 'Backup', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('763', '1599', 'pjField', '1', 'title', 'Backup database', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('764', '1600', 'pjField', '1', 'title', 'Backup files', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('765', '1601', 'pjField', '1', 'title', 'Backup', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('766', '1602', 'pjField', '1', 'title', 'Backup failed!', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('767', '1603', 'pjField', '1', 'title', 'Backup folder not found. Please ensure that "app/web/backup" folder exists.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('768', '1604', 'pjField', '1', 'title', 'Backup failed!', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('769', '1605', 'pjField', '1', 'title', 'You need to set write permissions (chmod 777) to "app/web/backup" folder.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('770', '1606', 'pjField', '1', 'title', 'Date/time', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('771', '1607', 'pjField', '1', 'title', 'Type', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('772', '1608', 'pjField', '1', 'title', 'File', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('773', '1609', 'pjField', '1', 'title', 'Are you sure you want to delete selected file?', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('774', '1610', 'pjField', '1', 'title', 'Delete selected', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('775', '1611', 'pjField', '1', 'title', 'Size', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('776', '1612', 'pjField', '1', 'title', 'SizeXXXX', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('777', '1613', 'pjField', '1', 'title', 'Log', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('778', '1614', 'pjField', '1', 'title', 'Config log', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('779', '1615', 'pjField', '1', 'title', 'Empty log', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('780', '1616', 'pjField', '1', 'title', 'Config log updated.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('781', '1617', 'pjField', '1', 'title', 'The config log have been updated.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('782', '1618', 'pjField', '1', 'title', 'List', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('783', '1619', 'pjField', '1', 'title', '+ Add', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('784', '1620', 'pjField', '1', 'title', 'Information', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('785', '1621', 'pjField', '1', 'title', 'Please, note that after changing the scripts in the list below you will need to refresh the page to apply the new updates in the "One admiN" menu.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('786', '1622', 'pjField', '1', 'title', 'Date/Time', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('787', '1623', 'pjField', '1', 'title', 'MC Gross', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('788', '1624', 'pjField', '1', 'title', 'MC Currency', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('789', '1625', 'pjField', '1', 'title', 'Payer email', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('790', '1626', 'pjField', '1', 'title', 'Txn type', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('791', '1627', 'pjField', '1', 'title', 'Txn ID', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('792', '1628', 'pjField', '1', 'title', 'Subscription ID', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('793', '1629', 'pjField', '1', 'title', 'Foreign ID', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('794', '1630', 'pjField', '1', 'title', 'Close', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('795', '1631', 'pjField', '1', 'title', 'Transaction details', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('796', '1632', 'pjField', '1', 'title', 'View', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('797', '1633', 'pjField', '1', 'title', 'IPN', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('798', '1634', 'pjField', '1', 'title', 'Country name', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('799', '1635', 'pjField', '1', 'title', 'Alpha 2', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('800', '1636', 'pjField', '1', 'title', 'Alpha 3', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('801', '1637', 'pjField', '1', 'title', 'Status', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('802', '1638', 'pjField', '1', 'title', 'Add +', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('803', '1639', 'pjField', '1', 'title', 'Active', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('804', '1640', 'pjField', '1', 'title', 'Inactive', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('805', '1641', 'pjField', '1', 'title', 'Save', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('806', '1642', 'pjField', '1', 'title', 'Cancel', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('807', '1643', 'pjField', '1', 'title', 'Countries', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('808', '1644', 'pjField', '1', 'title', 'Country updated', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('809', '1645', 'pjField', '1', 'title', 'Country added', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('810', '1646', 'pjField', '1', 'title', 'Country failed to add', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('811', '1647', 'pjField', '1', 'title', 'Country not found', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('812', '1648', 'pjField', '1', 'title', 'Add country', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('813', '1649', 'pjField', '1', 'title', 'Update country', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('814', '1650', 'pjField', '1', 'title', 'Manage countries', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('815', '1651', 'pjField', '1', 'title', 'Country has been updated successfully.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('816', '1652', 'pjField', '1', 'title', 'Country has been added successfully.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('817', '1653', 'pjField', '1', 'title', 'Country has not been added successfully.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('818', '1654', 'pjField', '1', 'title', 'Country you are looking for has not been found.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('819', '1655', 'pjField', '1', 'title', 'Use form below to add a country.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('820', '1656', 'pjField', '1', 'title', 'Use form below to update a country.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('821', '1657', 'pjField', '1', 'title', 'Use grid below to organize your country list.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('822', '1658', 'pjField', '1', 'title', 'Are you sure you want to delete selected country?', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('823', '1659', 'pjField', '1', 'title', 'Delete selected', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('824', '1660', 'pjField', '1', 'title', 'All', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('825', '1661', 'pjField', '1', 'title', 'Search', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('826', '1', 'pjCountry', '1', 'name', 'Afghanistan', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('827', '2', 'pjCountry', '1', 'name', 'Åland Islands', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('828', '3', 'pjCountry', '1', 'name', 'Albania', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('829', '4', 'pjCountry', '1', 'name', 'Algeria', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('830', '5', 'pjCountry', '1', 'name', 'American Samoa', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('831', '6', 'pjCountry', '1', 'name', 'Andorra', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('832', '7', 'pjCountry', '1', 'name', 'Angola', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('833', '8', 'pjCountry', '1', 'name', 'Anguilla', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('834', '9', 'pjCountry', '1', 'name', 'Antarctica', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('835', '10', 'pjCountry', '1', 'name', 'Antigua and Barbuda', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('836', '11', 'pjCountry', '1', 'name', 'Argentina', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('837', '12', 'pjCountry', '1', 'name', 'Armenia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('838', '13', 'pjCountry', '1', 'name', 'Aruba', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('839', '14', 'pjCountry', '1', 'name', 'Australia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('840', '15', 'pjCountry', '1', 'name', 'Austria', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('841', '16', 'pjCountry', '1', 'name', 'Azerbaijan', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('842', '17', 'pjCountry', '1', 'name', 'Bahamas', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('843', '18', 'pjCountry', '1', 'name', 'Bahrain', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('844', '19', 'pjCountry', '1', 'name', 'Bangladesh', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('845', '20', 'pjCountry', '1', 'name', 'Barbados', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('846', '21', 'pjCountry', '1', 'name', 'Belarus', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('847', '22', 'pjCountry', '1', 'name', 'Belgium', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('848', '23', 'pjCountry', '1', 'name', 'Belize', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('849', '24', 'pjCountry', '1', 'name', 'Benin', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('850', '25', 'pjCountry', '1', 'name', 'Bermuda', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('851', '26', 'pjCountry', '1', 'name', 'Bhutan', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('852', '27', 'pjCountry', '1', 'name', 'Bolivia, Plurinational State of', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('853', '28', 'pjCountry', '1', 'name', 'Bonaire, Sint Eustatius and Saba', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('854', '29', 'pjCountry', '1', 'name', 'Bosnia and Herzegovina', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('855', '30', 'pjCountry', '1', 'name', 'Botswana', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('856', '31', 'pjCountry', '1', 'name', 'Bouvet Island', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('857', '32', 'pjCountry', '1', 'name', 'Brazil', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('858', '33', 'pjCountry', '1', 'name', 'British Indian Ocean Territory', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('859', '34', 'pjCountry', '1', 'name', 'Brunei Darussalam', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('860', '35', 'pjCountry', '1', 'name', 'Bulgaria', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('861', '36', 'pjCountry', '1', 'name', 'Burkina Faso', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('862', '37', 'pjCountry', '1', 'name', 'Burundi', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('863', '38', 'pjCountry', '1', 'name', 'Cambodia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('864', '39', 'pjCountry', '1', 'name', 'Cameroon', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('865', '40', 'pjCountry', '1', 'name', 'Canada', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('866', '41', 'pjCountry', '1', 'name', 'Cape Verde', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('867', '42', 'pjCountry', '1', 'name', 'Cayman Islands', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('868', '43', 'pjCountry', '1', 'name', 'Central African Republic', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('869', '44', 'pjCountry', '1', 'name', 'Chad', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('870', '45', 'pjCountry', '1', 'name', 'Chile', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('871', '46', 'pjCountry', '1', 'name', 'China', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('872', '47', 'pjCountry', '1', 'name', 'Christmas Island', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('873', '48', 'pjCountry', '1', 'name', 'Cocos array(Keeling) Islands', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('874', '49', 'pjCountry', '1', 'name', 'Colombia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('875', '50', 'pjCountry', '1', 'name', 'Comoros', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('876', '51', 'pjCountry', '1', 'name', 'Congo', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('877', '52', 'pjCountry', '1', 'name', 'Congo, the Democratic Republic of the', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('878', '53', 'pjCountry', '1', 'name', 'Cook Islands', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('879', '54', 'pjCountry', '1', 'name', 'Costa Rica', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('880', '55', 'pjCountry', '1', 'name', 'Côte d''Ivoire', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('881', '56', 'pjCountry', '1', 'name', 'Croatia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('882', '57', 'pjCountry', '1', 'name', 'Cuba', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('883', '58', 'pjCountry', '1', 'name', 'Curaçao', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('884', '59', 'pjCountry', '1', 'name', 'Cyprus', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('885', '60', 'pjCountry', '1', 'name', 'Czech Republic', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('886', '61', 'pjCountry', '1', 'name', 'Denmark', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('887', '62', 'pjCountry', '1', 'name', 'Djibouti', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('888', '63', 'pjCountry', '1', 'name', 'Dominica', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('889', '64', 'pjCountry', '1', 'name', 'Dominican Republic', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('890', '65', 'pjCountry', '1', 'name', 'Ecuador', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('891', '66', 'pjCountry', '1', 'name', 'Egypt', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('892', '67', 'pjCountry', '1', 'name', 'El Salvador', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('893', '68', 'pjCountry', '1', 'name', 'Equatorial Guinea', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('894', '69', 'pjCountry', '1', 'name', 'Eritrea', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('895', '70', 'pjCountry', '1', 'name', 'Estonia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('896', '71', 'pjCountry', '1', 'name', 'Ethiopia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('897', '72', 'pjCountry', '1', 'name', 'Falkland Islands array(Malvinas)', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('898', '73', 'pjCountry', '1', 'name', 'Faroe Islands', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('899', '74', 'pjCountry', '1', 'name', 'Fiji', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('900', '75', 'pjCountry', '1', 'name', 'Finland', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('901', '76', 'pjCountry', '1', 'name', 'France', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('902', '77', 'pjCountry', '1', 'name', 'French Guiana', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('903', '78', 'pjCountry', '1', 'name', 'French Polynesia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('904', '79', 'pjCountry', '1', 'name', 'French Southern Territories', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('905', '80', 'pjCountry', '1', 'name', 'Gabon', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('906', '81', 'pjCountry', '1', 'name', 'Gambia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('907', '82', 'pjCountry', '1', 'name', 'Georgia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('908', '83', 'pjCountry', '1', 'name', 'Germany', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('909', '84', 'pjCountry', '1', 'name', 'Ghana', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('910', '85', 'pjCountry', '1', 'name', 'Gibraltar', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('911', '86', 'pjCountry', '1', 'name', 'Greece', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('912', '87', 'pjCountry', '1', 'name', 'Greenland', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('913', '88', 'pjCountry', '1', 'name', 'Grenada', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('914', '89', 'pjCountry', '1', 'name', 'Guadeloupe', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('915', '90', 'pjCountry', '1', 'name', 'Guam', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('916', '91', 'pjCountry', '1', 'name', 'Guatemala', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('917', '92', 'pjCountry', '1', 'name', 'Guernsey', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('918', '93', 'pjCountry', '1', 'name', 'Guinea', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('919', '94', 'pjCountry', '1', 'name', 'Guinea-Bissau', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('920', '95', 'pjCountry', '1', 'name', 'Guyana', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('921', '96', 'pjCountry', '1', 'name', 'Haiti', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('922', '97', 'pjCountry', '1', 'name', 'Heard Island and McDonald Islands', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('923', '98', 'pjCountry', '1', 'name', 'Holy See array(Vatican City State)', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('924', '99', 'pjCountry', '1', 'name', 'Honduras', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('925', '100', 'pjCountry', '1', 'name', 'Hong Kong', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('926', '101', 'pjCountry', '1', 'name', 'Hungary', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('927', '102', 'pjCountry', '1', 'name', 'Iceland', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('928', '103', 'pjCountry', '1', 'name', 'India', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('929', '104', 'pjCountry', '1', 'name', 'Indonesia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('930', '105', 'pjCountry', '1', 'name', 'Iran, Islamic Republic of', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('931', '106', 'pjCountry', '1', 'name', 'Iraq', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('932', '107', 'pjCountry', '1', 'name', 'Ireland', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('933', '108', 'pjCountry', '1', 'name', 'Isle of Man', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('934', '109', 'pjCountry', '1', 'name', 'Israel', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('935', '110', 'pjCountry', '1', 'name', 'Italy', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('936', '111', 'pjCountry', '1', 'name', 'Jamaica', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('937', '112', 'pjCountry', '1', 'name', 'Japan', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('938', '113', 'pjCountry', '1', 'name', 'Jersey', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('939', '114', 'pjCountry', '1', 'name', 'Jordan', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('940', '115', 'pjCountry', '1', 'name', 'Kazakhstan', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('941', '116', 'pjCountry', '1', 'name', 'Kenya', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('942', '117', 'pjCountry', '1', 'name', 'Kiribati', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('943', '118', 'pjCountry', '1', 'name', 'Korea, Democratic People''s Republic of', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('944', '119', 'pjCountry', '1', 'name', 'Korea, Republic of', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('945', '120', 'pjCountry', '1', 'name', 'Kuwait', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('946', '121', 'pjCountry', '1', 'name', 'Kyrgyzstan', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('947', '122', 'pjCountry', '1', 'name', 'Lao People''s Democratic Republic', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('948', '123', 'pjCountry', '1', 'name', 'Latvia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('949', '124', 'pjCountry', '1', 'name', 'Lebanon', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('950', '125', 'pjCountry', '1', 'name', 'Lesotho', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('951', '126', 'pjCountry', '1', 'name', 'Liberia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('952', '127', 'pjCountry', '1', 'name', 'Libya', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('953', '128', 'pjCountry', '1', 'name', 'Liechtenstein', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('954', '129', 'pjCountry', '1', 'name', 'Lithuania', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('955', '130', 'pjCountry', '1', 'name', 'Luxembourg', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('956', '131', 'pjCountry', '1', 'name', 'Macao', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('957', '132', 'pjCountry', '1', 'name', 'Macedonia, The Former Yugoslav Republic of', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('958', '133', 'pjCountry', '1', 'name', 'Madagascar', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('959', '134', 'pjCountry', '1', 'name', 'Malawi', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('960', '135', 'pjCountry', '1', 'name', 'Malaysia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('961', '136', 'pjCountry', '1', 'name', 'Maldives', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('962', '137', 'pjCountry', '1', 'name', 'Mali', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('963', '138', 'pjCountry', '1', 'name', 'Malta', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('964', '139', 'pjCountry', '1', 'name', 'Marshall Islands', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('965', '140', 'pjCountry', '1', 'name', 'Martinique', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('966', '141', 'pjCountry', '1', 'name', 'Mauritania', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('967', '142', 'pjCountry', '1', 'name', 'Mauritius', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('968', '143', 'pjCountry', '1', 'name', 'Mayotte', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('969', '144', 'pjCountry', '1', 'name', 'Mexico', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('970', '145', 'pjCountry', '1', 'name', 'Micronesia, Federated States of', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('971', '146', 'pjCountry', '1', 'name', 'Moldova, Republic of', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('972', '147', 'pjCountry', '1', 'name', 'Monaco', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('973', '148', 'pjCountry', '1', 'name', 'Mongolia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('974', '149', 'pjCountry', '1', 'name', 'Montenegro', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('975', '150', 'pjCountry', '1', 'name', 'Montserrat', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('976', '151', 'pjCountry', '1', 'name', 'Morocco', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('977', '152', 'pjCountry', '1', 'name', 'Mozambique', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('978', '153', 'pjCountry', '1', 'name', 'Myanmar', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('979', '154', 'pjCountry', '1', 'name', 'Namibia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('980', '155', 'pjCountry', '1', 'name', 'Nauru', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('981', '156', 'pjCountry', '1', 'name', 'Nepal', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('982', '157', 'pjCountry', '1', 'name', 'Netherlands', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('983', '158', 'pjCountry', '1', 'name', 'New Caledonia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('984', '159', 'pjCountry', '1', 'name', 'New Zealand', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('985', '160', 'pjCountry', '1', 'name', 'Nicaragua', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('986', '161', 'pjCountry', '1', 'name', 'Niger', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('987', '162', 'pjCountry', '1', 'name', 'Nigeria', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('988', '163', 'pjCountry', '1', 'name', 'Niue', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('989', '164', 'pjCountry', '1', 'name', 'Norfolk Island', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('990', '165', 'pjCountry', '1', 'name', 'Northern Mariana Islands', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('991', '166', 'pjCountry', '1', 'name', 'Norway', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('992', '167', 'pjCountry', '1', 'name', 'Oman', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('993', '168', 'pjCountry', '1', 'name', 'Pakistan', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('994', '169', 'pjCountry', '1', 'name', 'Palau', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('995', '170', 'pjCountry', '1', 'name', 'Palestine, State of', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('996', '171', 'pjCountry', '1', 'name', 'Panama', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('997', '172', 'pjCountry', '1', 'name', 'Papua New Guinea', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('998', '173', 'pjCountry', '1', 'name', 'Paraguay', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('999', '174', 'pjCountry', '1', 'name', 'Peru', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1000', '175', 'pjCountry', '1', 'name', 'Philippines', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1001', '176', 'pjCountry', '1', 'name', 'Pitcairn', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1002', '177', 'pjCountry', '1', 'name', 'Poland', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1003', '178', 'pjCountry', '1', 'name', 'Portugal', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1004', '179', 'pjCountry', '1', 'name', 'Puerto Rico', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1005', '180', 'pjCountry', '1', 'name', 'Qatar', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1006', '181', 'pjCountry', '1', 'name', 'Réunion', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1007', '182', 'pjCountry', '1', 'name', 'Romania', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1008', '183', 'pjCountry', '1', 'name', 'Russian Federation', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1009', '184', 'pjCountry', '1', 'name', 'Rwanda', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1010', '185', 'pjCountry', '1', 'name', 'Saint Barthélemy', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1011', '186', 'pjCountry', '1', 'name', 'Saint Helena, Ascension and Tristan da Cunha', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1012', '187', 'pjCountry', '1', 'name', 'Saint Kitts and Nevis', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1013', '188', 'pjCountry', '1', 'name', 'Saint Lucia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1014', '189', 'pjCountry', '1', 'name', 'Saint Martin array(French part)', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1015', '190', 'pjCountry', '1', 'name', 'Saint Pierre and Miquelon', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1016', '191', 'pjCountry', '1', 'name', 'Saint Vincent and the Grenadines', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1017', '192', 'pjCountry', '1', 'name', 'Samoa', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1018', '193', 'pjCountry', '1', 'name', 'San Marino', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1019', '194', 'pjCountry', '1', 'name', 'Sao Tome and Principe', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1020', '195', 'pjCountry', '1', 'name', 'Saudi Arabia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1021', '196', 'pjCountry', '1', 'name', 'Senegal', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1022', '197', 'pjCountry', '1', 'name', 'Serbia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1023', '198', 'pjCountry', '1', 'name', 'Seychelles', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1024', '199', 'pjCountry', '1', 'name', 'Sierra Leone', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1025', '200', 'pjCountry', '1', 'name', 'Singapore', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1026', '201', 'pjCountry', '1', 'name', 'Sint Maarten array(Dutch part)', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1027', '202', 'pjCountry', '1', 'name', 'Slovakia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1028', '203', 'pjCountry', '1', 'name', 'Slovenia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1029', '204', 'pjCountry', '1', 'name', 'Solomon Islands', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1030', '205', 'pjCountry', '1', 'name', 'Somalia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1031', '206', 'pjCountry', '1', 'name', 'South Africa', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1032', '207', 'pjCountry', '1', 'name', 'South Georgia and the South Sandwich Islands', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1033', '208', 'pjCountry', '1', 'name', 'South Sudan', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1034', '209', 'pjCountry', '1', 'name', 'Spain', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1035', '210', 'pjCountry', '1', 'name', 'Sri Lanka', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1036', '211', 'pjCountry', '1', 'name', 'Sudan', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1037', '212', 'pjCountry', '1', 'name', 'Suriname', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1038', '213', 'pjCountry', '1', 'name', 'Svalbard and Jan Mayen', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1039', '214', 'pjCountry', '1', 'name', 'Swaziland', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1040', '215', 'pjCountry', '1', 'name', 'Sweden', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1041', '216', 'pjCountry', '1', 'name', 'Switzerland', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1042', '217', 'pjCountry', '1', 'name', 'Syrian Arab Republic', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1043', '218', 'pjCountry', '1', 'name', 'Taiwan, Province of China', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1044', '219', 'pjCountry', '1', 'name', 'Tajikistan', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1045', '220', 'pjCountry', '1', 'name', 'Tanzania, United Republic of', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1046', '221', 'pjCountry', '1', 'name', 'Thailand', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1047', '222', 'pjCountry', '1', 'name', 'Timor-Leste', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1048', '223', 'pjCountry', '1', 'name', 'Togo', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1049', '224', 'pjCountry', '1', 'name', 'Tokelau', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1050', '225', 'pjCountry', '1', 'name', 'Tonga', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1051', '226', 'pjCountry', '1', 'name', 'Trinidad and Tobago', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1052', '227', 'pjCountry', '1', 'name', 'Tunisia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1053', '228', 'pjCountry', '1', 'name', 'Turkey', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1054', '229', 'pjCountry', '1', 'name', 'Turkmenistan', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1055', '230', 'pjCountry', '1', 'name', 'Turks and Caicos Islands', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1056', '231', 'pjCountry', '1', 'name', 'Tuvalu', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1057', '232', 'pjCountry', '1', 'name', 'Uganda', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1058', '233', 'pjCountry', '1', 'name', 'Ukraine', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1059', '234', 'pjCountry', '1', 'name', 'United Arab Emirates', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1060', '235', 'pjCountry', '1', 'name', 'United Kingdom', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1061', '236', 'pjCountry', '1', 'name', 'United States', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1062', '237', 'pjCountry', '1', 'name', 'United States Minor Outlying Islands', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1063', '238', 'pjCountry', '1', 'name', 'Uruguay', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1064', '239', 'pjCountry', '1', 'name', 'Uzbekistan', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1065', '240', 'pjCountry', '1', 'name', 'Vanuatu', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1066', '241', 'pjCountry', '1', 'name', 'Venezuela, Bolivarian Republic of', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1067', '242', 'pjCountry', '1', 'name', 'Viet Nam', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1068', '243', 'pjCountry', '1', 'name', 'Virgin Islands, British', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1069', '244', 'pjCountry', '1', 'name', 'Virgin Islands, U.S.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1070', '245', 'pjCountry', '1', 'name', 'Wallis and Futuna', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1071', '246', 'pjCountry', '1', 'name', 'Western Sahara', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1072', '247', 'pjCountry', '1', 'name', 'Yemen', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1073', '248', 'pjCountry', '1', 'name', 'Zambia', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1074', '249', 'pjCountry', '1', 'name', 'Zimbabwe', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1075', '1662', 'pjField', '1', 'title', 'Revert status', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1076', '1663', 'pjField', '1', 'title', 'SMS', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1077', '1664', 'pjField', '1', 'title', 'SMS Config', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1078', '1665', 'pjField', '1', 'title', 'Phone number', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1079', '1666', 'pjField', '1', 'title', 'Message', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1080', '1667', 'pjField', '1', 'title', 'Status', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1081', '1668', 'pjField', '1', 'title', 'Date/Time sent', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1082', '1669', 'pjField', '1', 'title', 'API Key', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1083', '1670', 'pjField', '1', 'title', 'SMS', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1084', '1671', 'pjField', '1', 'title', 'To send SMS you need a valid API Key. Please, contact StivaSoft to purchase an API key.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1085', '1672', 'pjField', '1', 'title', 'SMS API key updated!', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1086', '1673', 'pjField', '1', 'title', 'All changes have been saved.', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1087', '1674', 'pjField', '1', 'title', 'Reset search', 'plugin');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1088', '1675', 'pjField', '1', 'title', 'We are sorry, but your reservation failed. The selected table has just been booked by other while you were placing your order. You can [STAG]start over[ETAG] searching for other table.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1089', '1676', 'pjField', '1', 'title', 'The selected table was reserved.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1090', '1677', 'pjField', '1', 'title', 'Su', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1091', '1678', 'pjField', '1', 'title', 'Mo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1092', '1679', 'pjField', '1', 'title', 'Tu', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1093', '1680', 'pjField', '1', 'title', 'We', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1094', '1681', 'pjField', '1', 'title', 'Th', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1095', '1682', 'pjField', '1', 'title', 'Fr', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1096', '1683', 'pjField', '1', 'title', 'Sa', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1097', '1684', 'pjField', '1', 'title', 'Missing parameters', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1098', '1685', 'pjField', '1', 'title', 'Hour', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1099', '1686', 'pjField', '1', 'title', 'Minute', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1100', '1687', 'pjField', '1', 'title', 'Please select a table.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1101', '1688', 'pjField', '1', 'title', 'Step 1', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1102', '1689', 'pjField', '1', 'title', 'Step 2', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1103', '1690', 'pjField', '1', 'title', 'Step 3', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1104', '1691', 'pjField', '1', 'title', 'Step 4', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1105', '1692', 'pjField', '1', 'title', 'Reservation form', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1106', '1693', 'pjField', '1', 'title', 'fill the form to reserve a table', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1107', '1694', 'pjField', '1', 'title', 'This field is required.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1108', '1695', 'pjField', '1', 'title', 'Email address is invalid.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1109', '1696', 'pjField', '1', 'title', 'Bank account', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1110', '1697', 'pjField', '1', 'title', 'Thank you for your reservation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1111', '1698', 'pjField', '1', 'title', 'Preview front end', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1112', '1699', 'pjField', '1', 'title', 'There are multiple color schemes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1113', '1700', 'pjField', '1', 'title', 'Choose theme', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1114', '1701', 'pjField', '1', 'title', 'Theme 1', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1115', '1702', 'pjField', '1', 'title', 'Theme 2', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1116', '1703', 'pjField', '1', 'title', 'Theme 3', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1117', '1704', 'pjField', '1', 'title', 'Theme 4', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1118', '1705', 'pjField', '1', 'title', 'Theme 5', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1119', '1706', 'pjField', '1', 'title', 'Theme 6', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1120', '1707', 'pjField', '1', 'title', 'Theme 7', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1121', '1708', 'pjField', '1', 'title', 'Theme 8', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1122', '1709', 'pjField', '1', 'title', 'Theme 9', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1123', '1710', 'pjField', '1', 'title', 'Theme 10', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1124', '1711', 'pjField', '1', 'title', 'Currently in use', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1125', '1712', 'pjField', '1', 'title', 'Use this theme', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1126', '1713', 'pjField', '1', 'title', 'Available tables for %1s person(s) on %2s at %3s.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1127', '1714', 'pjField', '1', 'title', 'click on an available table to book it', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1128', '1715', 'pjField', '1', 'title', 'There is no available table on %1s at %2s.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1129', '1716', 'pjField', '1', 'title', 'Please, change date and/or time and check availability', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1130', '1717', 'pjField', '1', 'title', 'Step empty message 2', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1131', '1718', 'pjField', '1', 'title', 'Enquiry details', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1132', '1719', 'pjField', '1', 'title', 'Enquiry form', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1133', '1720', 'pjField', '1', 'title', 'fill the form to make an enquiry', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1134', '1721', 'pjField', '1', 'title', 'Table', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1135', '1722', 'pjField', '1', 'title', 'for %s person(s)', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1136', '1723', 'pjField', '1', 'title', '+ Add reservation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1137', '1724', 'pjField', '1', 'title', '+ Add voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1138', '1725', 'pjField', '1', 'title', '+ Add user', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1139', '1726', 'pjField', '1', 'title', 'Users', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1140', '1727', 'pjField', '1', 'title', 'Below is a list of all users. You can add new users, edit user details and change user status.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1141', '1728', 'pjField', '1', 'title', 'Add user', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1142', '1729', 'pjField', '1', 'title', 'Fill in the form below and "save" to add a new user.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1143', '1730', 'pjField', '1', 'title', 'Update user', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1144', '1731', 'pjField', '1', 'title', 'You can make any changes on the form below and click "Save" button to update the user information.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1145', '1732', 'pjField', '1', 'title', 'Preview & Install', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1146', '1733', 'pjField', '1', 'title', 'Send Cancellation Email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1147', '1734', 'pjField', '1', 'title', 'Send Cancellation Email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1148', '1735', 'pjField', '1', 'title', 'Email subject', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1149', '1736', 'pjField', '1', 'title', 'Email message', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1150', '1737', 'pjField', '1', 'title', 'Send', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1151', '1738', 'pjField', '1', 'title', 'Cancel', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1152', '1739', 'pjField', '1', 'title', 'Send Confirmation Email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1153', '1740', 'pjField', '1', 'title', 'Price after discount is applied', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1154', '1741', 'pjField', '1', 'title', 'PHP mail()', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1155', '1742', 'pjField', '1', 'title', 'SMTP', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1156', '1743', 'pjField', '1', 'title', 'Confirmed', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1157', '1744', 'pjField', '1', 'title', 'Pending', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1158', '1745', 'pjField', '1', 'title', 'Cancelled', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1159', '1746', 'pjField', '1', 'title', 'Yes', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1160', '1747', 'pjField', '1', 'title', 'No', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1161', '1748', 'pjField', '1', 'title', 'No', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1162', '1749', 'pjField', '1', 'title', 'Yes', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1163', '1750', 'pjField', '1', 'title', 'Yes (required)', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1164', '1751', 'pjField', '1', 'title', 'Delete', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1165', '1752', 'pjField', '1', 'title', 'Save', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1166', '1', 'pjField', '2', 'title', 'Aggiungi lingua', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1167', '2', 'pjField', '2', 'title', 'Ricorda password', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1168', '3', 'pjField', '2', 'title', 'Login amministratore', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1169', '4', 'pjField', '2', 'title', 'Titoli di back-end', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1170', '5', 'pjField', '2', 'title', 'Aggiungi +', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1171', '6', 'pjField', '2', 'title', '« Indietro', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1172', '7', 'pjField', '2', 'title', 'Backup', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1173', '8', 'pjField', '2', 'title', 'Annulla', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1174', '9', 'pjField', '2', 'title', 'Continua', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1175', '10', 'pjField', '2', 'title', 'Elimina', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1176', '11', 'pjField', '2', 'title', 'Login', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1177', '12', 'pjField', '2', 'title', 'Reset', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1178', '13', 'pjField', '2', 'title', 'Salva', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1179', '14', 'pjField', '2', 'title', 'Ricerca', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1180', '15', 'pjField', '2', 'title', 'Invia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1181', '16', 'pjField', '2', 'title', 'Aggiorna', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1182', '17', 'pjField', '2', 'title', 'Appuntamento', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1183', '18', 'pjField', '2', 'title', 'Email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1184', '19', 'pjField', '2', 'title', 'Gentile {nome}, la tua password: {password}', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1185', '20', 'pjField', '2', 'title', 'Ricorda password', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1186', '21', 'pjField', '2', 'title', 'Titoli di front-end', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1187', '22', 'pjField', '2', 'title', 'Conferma azione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1188', '23', 'pjField', '2', 'title', 'Annulla', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1189', '24', 'pjField', '2', 'title', 'Elimina', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1190', '25', 'pjField', '2', 'title', 'OK', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1191', '26', 'pjField', '2', 'title', 'Scegli un''azione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1192', '27', 'pjField', '2', 'title', 'Sei sicuro di voler eliminare il record selezionato?', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1193', '28', 'pjField', '2', 'title', 'Conferma elimina', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1194', '29', 'pjField', '2', 'title', 'Nessun record trovato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1195', '30', 'pjField', '2', 'title', 'Vai alla pagina:', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1196', '31', 'pjField', '2', 'title', 'Oggetti per pagina', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1197', '32', 'pjField', '2', 'title', 'Avanti »', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1198', '33', 'pjField', '2', 'title', 'Prossima pagina', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1199', '34', 'pjField', '2', 'title', '« Precedente', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1200', '35', 'pjField', '2', 'title', 'Pagina precedente', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1201', '36', 'pjField', '2', 'title', 'Totale elementi:', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1202', '37', 'pjField', '2', 'title', 'Puoi mostrare una mappa con la posizione dell''alloggio nella pagina dei dettagli dell''elenco. Invia prima l''indirizzo completo e poi fai clic su "Ottieni le coordinate dal pulsante API di Google Maps". Salva i tuoi dati.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1203', '38', 'pjField', '2', 'title', 'Posizione e indirizzo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1204', '39', 'pjField', '2', 'title', 'Elenco corpo prenotazioni', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1205', '40', 'pjField', '2', 'title', 'Elenco titoli prenotazioni', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1206', '41', 'pjField', '2', 'title', 'Elenco corpo contatto', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1207', '42', 'pjField', '2', 'title', 'Elenco titolo contatto', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1208', '43', 'pjField', '2', 'title', 'Estendi exp. dati corpo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1209', '44', 'pjField', '2', 'title', 'Estendi exp. dati titolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1210', '45', 'pjField', '2', 'title', 'Listino prezzi corpo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1211', '46', 'pjField', '2', 'title', 'Listino Prezzi Titolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1212', '47', 'pjField', '2', 'title', 'Lingue Array Corpo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1213', '48', 'pjField', '2', 'title', 'Lingue Array Titolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1214', '49', 'pjField', '2', 'title', 'Lingue Backend corpo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1215', '50', 'pjField', '2', 'title', 'Lingue Backend titolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1216', '51', 'pjField', '2', 'title', 'Lingue corpo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1217', '52', 'pjField', '2', 'title', 'Lingue Frontend corpo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1218', '53', 'pjField', '2', 'title', 'Lingue Frontend titolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1219', '54', 'pjField', '2', 'title', 'Lingue titolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1220', '55', 'pjField', '2', 'title', 'Aggiungi utente', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1221', '56', 'pjField', '2', 'title', 'Backup database', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1222', '57', 'pjField', '2', 'title', 'Backup files', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1223', '58', 'pjField', '2', 'title', 'Scegliere', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1224', '59', 'pjField', '2', 'title', 'giorni', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1225', '60', 'pjField', '2', 'title', 'Elimina', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1226', '61', 'pjField', '2', 'title', 'Error', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1227', '62', 'pjField', '2', 'title', 'Export', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1228', '63', 'pjField', '2', 'title', 'Ha dimenticato la password', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1229', '64', 'pjField', '2', 'title', 'IP address', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1230', '65', 'pjField', '2', 'title', 'E'' confermato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1231', '66', 'pjField', '2', 'title', 'Nome', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1232', '67', 'pjField', '2', 'title', 'No', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1233', '68', 'pjField', '2', 'title', 'Opzioni', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1234', '69', 'pjField', '2', 'title', 'Lista opzioni', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1235', '70', 'pjField', '2', 'title', 'Ruolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1236', '71', 'pjField', '2', 'title', 'Status', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1237', '72', 'pjField', '2', 'title', 'Tipo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1238', '73', 'pjField', '2', 'title', 'Aggiorna utente', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1239', '74', 'pjField', '2', 'title', 'Data / ora di registrazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1240', '75', 'pjField', '2', 'title', 'Valore', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1241', '76', 'pjField', '2', 'title', 'Sì', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1242', '77', 'pjField', '2', 'title', 'Indietro', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1243', '78', 'pjField', '2', 'title', 'Array titoli', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1244', '79', 'pjField', '2', 'title', 'Linguaggi', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1245', '80', 'pjField', '2', 'title', 'Flag', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1246', '81', 'pjField', '2', 'title', 'E'' predefinito', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1247', '82', 'pjField', '2', 'title', 'Ordine', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1248', '83', 'pjField', '2', 'title', 'Titolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1249', '84', 'pjField', '2', 'title', 'Backup', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1250', '85', 'pjField', '2', 'title', 'Dashboard', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1251', '86', 'pjField', '2', 'title', 'Multi lingua', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1252', '87', 'pjField', '2', 'title', 'Linguaggi', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1253', '88', 'pjField', '2', 'title', 'Logout', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1254', '89', 'pjField', '2', 'title', 'Opzioni', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1255', '90', 'pjField', '2', 'title', 'Plugins', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1256', '91', 'pjField', '2', 'title', 'Profilo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1257', '92', 'pjField', '2', 'title', 'Utenti', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1258', '93', 'pjField', '2', 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1259', '94', 'pjField', '2', 'title', 'Valuta', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1260', '95', 'pjField', '2', 'title', 'Formato data', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1261', '96', 'pjField', '2', 'title', 'Invia email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1262', '97', 'pjField', '2', 'title', 'SMTP Host', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1263', '98', 'pjField', '2', 'title', 'SMTP Password', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1264', '99', 'pjField', '2', 'title', 'SMTP Port', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1265', '100', 'pjField', '2', 'title', 'SMTP Username', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1266', '101', 'pjField', '2', 'title', 'Fuso orario', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1267', '102', 'pjField', '2', 'title', 'Primo giorno della settimana', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1268', '103', 'pjField', '2', 'title', 'Password', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1269', '125', 'pjField', '2', 'title', 'Ripristina lo stato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1270', '126', 'pjField', '2', 'title', 'URL', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1271', '127', 'pjField', '2', 'title', 'Nome utente', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1272', '128', 'pjField', '2', 'title', 'L''indirizzo email era già in uso', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1273', '129', 'pjField', '2', 'title', 'Domenica', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1274', '130', 'pjField', '2', 'title', 'Lunedì', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1275', '131', 'pjField', '2', 'title', 'Martedì', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1276', '132', 'pjField', '2', 'title', 'Mercoledì', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1277', '133', 'pjField', '2', 'title', 'Giovedì', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1278', '134', 'pjField', '2', 'title', 'Venerdì', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1279', '135', 'pjField', '2', 'title', 'Sabato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1280', '136', 'pjField', '2', 'title', 'Dom', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1281', '137', 'pjField', '2', 'title', 'Lun', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1282', '138', 'pjField', '2', 'title', 'Mar', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1283', '139', 'pjField', '2', 'title', 'Mer', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1284', '140', 'pjField', '2', 'title', 'Gio', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1285', '141', 'pjField', '2', 'title', 'Ven', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1286', '142', 'pjField', '2', 'title', 'Sab', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1287', '143', 'pjField', '2', 'title', 'l''indirizzo email inserito non è associato ad alcun account.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1288', '144', 'pjField', '2', 'title', 'Per ulteriori istruzioni si prega di controllare la vostra casella di posta.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1289', '145', 'pjField', '2', 'title', 'Siamo spiacenti, per favore riprova più tardi.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1290', '146', 'pjField', '2', 'title', 'Tutte le modifiche apportate al tuo profilo sono state salvate.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1291', '147', 'pjField', '2', 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1292', '148', 'pjField', '2', 'title', 'Tutti i file di backup sono stati salvati.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1293', '149', 'pjField', '2', 'title', 'Nessuna opzione è stata selezionata.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1294', '150', 'pjField', '2', 'title', 'Backup non eseguito.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1295', '151', 'pjField', '2', 'title', 'Tutte le modifiche apportate ai titoli sono state salvate.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1296', '152', 'pjField', '2', 'title', 'Tutte le modifiche apportate alle opzioni sono state salvate.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1297', '153', 'pjField', '2', 'title', 'Tutte le modifiche apportate a questo utente sono state salvate.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1298', '154', 'pjField', '2', 'title', 'Tutte le modifiche apportate a questo utente sono state salvate.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1299', '155', 'pjField', '2', 'title', 'Siamo spiacenti, ma l''utente non è stato aggiunto.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1300', '156', 'pjField', '2', 'title', 'Manca l''utente che stai cercando.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1301', '159', 'pjField', '2', 'title', 'Account non trovato!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1302', '160', 'pjField', '2', 'title', 'Invia la password!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1303', '161', 'pjField', '2', 'title', 'Password non inviata!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1304', '162', 'pjField', '2', 'title', 'Profilo aggiornato!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1305', '163', 'pjField', '2', 'title', 'Backup', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1306', '164', 'pjField', '2', 'title', 'Backup completato!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1307', '165', 'pjField', '2', 'title', 'Backup fallito!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1308', '166', 'pjField', '2', 'title', 'Backup fallito!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1309', '167', 'pjField', '2', 'title', 'Opzioni aggiornate!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1310', '168', 'pjField', '2', 'title', 'Utente aggiornato!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1311', '169', 'pjField', '2', 'title', 'Utente aggiunto!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1312', '170', 'pjField', '2', 'title', 'Non è possibile aggiungere l''utente', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1313', '171', 'pjField', '2', 'title', 'Utente non trovato.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1314', '174', 'pjField', '2', 'title', 'Attivo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1315', '175', 'pjField', '2', 'title', 'Inattivo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1316', '176', 'pjField', '2', 'title', 'Nome utente o password errati', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1317', '177', 'pjField', '2', 'title', 'Accessp negato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1318', '178', 'pjField', '2', 'title', 'Account disabilitato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1319', '179', 'pjField', '2', 'title', 'Gennaio', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1320', '180', 'pjField', '2', 'title', 'Ottobre', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1321', '181', 'pjField', '2', 'title', 'Novembre', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1322', '182', 'pjField', '2', 'title', 'Dicembre', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1323', '183', 'pjField', '2', 'title', 'Febbraio', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1324', '184', 'pjField', '2', 'title', 'Marzo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1325', '185', 'pjField', '2', 'title', 'Aprile', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1326', '186', 'pjField', '2', 'title', 'Maggio', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1327', '187', 'pjField', '2', 'title', 'Giugno', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1328', '188', 'pjField', '2', 'title', 'Luglio', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1329', '189', 'pjField', '2', 'title', 'Agosto', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1330', '190', 'pjField', '2', 'title', 'Settembre', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1331', '191', 'pjField', '2', 'title', 'Dr.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1332', '192', 'pjField', '2', 'title', 'Miss', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1333', '193', 'pjField', '2', 'title', 'Mr.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1334', '194', 'pjField', '2', 'title', 'Mrs.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1335', '195', 'pjField', '2', 'title', 'Ms.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1336', '196', 'pjField', '2', 'title', 'Altro', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1337', '197', 'pjField', '2', 'title', 'Prof.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1338', '198', 'pjField', '2', 'title', 'Rev.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1339', '199', 'pjField', '2', 'title', 'Gen', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1340', '200', 'pjField', '2', 'title', 'Ott', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1341', '201', 'pjField', '2', 'title', 'Nov', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1342', '202', 'pjField', '2', 'title', 'Dic', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1343', '203', 'pjField', '2', 'title', 'Feb', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1344', '204', 'pjField', '2', 'title', 'Mar', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1345', '205', 'pjField', '2', 'title', 'Apr', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1346', '206', 'pjField', '2', 'title', 'Mag', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1347', '207', 'pjField', '2', 'title', 'Giu', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1348', '208', 'pjField', '2', 'title', 'Lug', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1349', '209', 'pjField', '2', 'title', 'Ago', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1350', '210', 'pjField', '2', 'title', 'Set', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1351', '211', 'pjField', '2', 'title', 'Non sei loggato.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1352', '212', 'pjField', '2', 'title', 'Il tuo account di hosting non consente il caricamento di un''immagine così grande.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1353', '213', 'pjField', '2', 'title', 'Accesso negato. Non hai i requisiti per.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1354', '214', 'pjField', '2', 'title', 'Risultato vuoto.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1355', '215', 'pjField', '2', 'title', 'L''operazione non è consentita in modalità demo.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1356', '216', 'pjField', '2', 'title', 'Nessuna proprietà per la prenotazione trovata', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1357', '217', 'pjField', '2', 'title', 'Nessuna prenotazione trovata', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1358', '218', 'pjField', '2', 'title', 'Nessuna autorizzazione per modificare la prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1359', '219', 'pjField', '2', 'title', 'Nessuna autorizzazione per modificare la prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1360', '220', 'pjField', '2', 'title', 'L''indirizzo di posta elettronica esiste già', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1361', '221', 'pjField', '2', 'title', 'La tua registrazione è andata a buon fine. Il tuo account deve essere approvato.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1362', '222', 'pjField', '2', 'title', 'La tua registrazione è andata a buon fine.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1363', '223', 'pjField', '2', 'title', 'GMT-03:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1364', '224', 'pjField', '2', 'title', 'GMT-04:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1365', '225', 'pjField', '2', 'title', 'GMT-05:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1366', '226', 'pjField', '2', 'title', 'GMT-06:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1367', '227', 'pjField', '2', 'title', 'GMT-07:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1368', '228', 'pjField', '2', 'title', 'GMT-08:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1369', '229', 'pjField', '2', 'title', 'GMT-09:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1370', '230', 'pjField', '2', 'title', 'GMT-01:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1371', '231', 'pjField', '2', 'title', 'GMT-10:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1372', '232', 'pjField', '2', 'title', 'GMT-11:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1373', '233', 'pjField', '2', 'title', 'GMT-12:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1374', '234', 'pjField', '2', 'title', 'GMT-02:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1375', '235', 'pjField', '2', 'title', 'GMT', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1376', '236', 'pjField', '2', 'title', 'GMT+03:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1377', '237', 'pjField', '2', 'title', 'GMT+04:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1378', '238', 'pjField', '2', 'title', 'GMT+05:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1379', '239', 'pjField', '2', 'title', 'GMT+06:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1380', '240', 'pjField', '2', 'title', 'GMT+07:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1381', '241', 'pjField', '2', 'title', 'GMT+08:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1382', '242', 'pjField', '2', 'title', 'GMT+09:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1383', '243', 'pjField', '2', 'title', 'GMT+01:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1384', '244', 'pjField', '2', 'title', 'GMT+10:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1385', '245', 'pjField', '2', 'title', 'GMT+11:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1386', '246', 'pjField', '2', 'title', 'GMT+12:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1387', '247', 'pjField', '2', 'title', 'GMT+13:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1388', '248', 'pjField', '2', 'title', 'GMT+02:00', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1389', '249', 'pjField', '2', 'title', 'Inattivo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1390', '250', 'pjField', '2', 'title', 'Attivo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1391', '251', 'pjField', '2', 'title', 'No', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1392', '252', 'pjField', '2', 'title', 'Sì', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1393', '253', 'pjField', '2', 'title', 'Elimina selezionato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1394', '254', 'pjField', '2', 'title', 'Sei sicuro di voler eliminare i record(s) selezionati?', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1395', '255', 'pjField', '2', 'title', 'Tutti', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1396', '256', 'pjField', '2', 'title', 'L''indirizzo email era già in uso.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1397', '308', 'pjField', '2', 'title', 'Ristorante', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1398', '309', 'pjField', '2', 'title', 'Prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1399', '310', 'pjField', '2', 'title', 'Voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1400', '311', 'pjField', '2', 'title', 'Install', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1401', '312', 'pjField', '2', 'title', 'Anteprima', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1402', '313', 'pjField', '2', 'title', 'Ultimo accesso', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1403', '314', 'pjField', '2', 'title', 'Formato ora', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1404', '315', 'pjField', '2', 'title', 'Opzioni di prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1405', '316', 'pjField', '2', 'title', 'Modifica le opzioni di seguito e fai clic sul pulsante Salva.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1406', '318', 'pjField', '2', 'title', 'Opzioni di prenotazione aggiornate', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1407', '319', 'pjField', '2', 'title', 'Tutte le modifiche apportate alle opzioni di prenotazione sono state salvate.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1408', '320', 'pjField', '2', 'title', 'Tassa di deposito', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1409', '321', 'pjField', '2', 'title', 'Imposta il prezzo di prenotazione predefinito', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1410', '322', 'pjField', '2', 'title', 'Lunghezza della prenotazione predefinita, il valore è espresso in minuti', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1411', '323', 'pjField', '2', 'title', 'Imposta la lunghezza della prenotazione predefinita, i valori in minuti', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1412', '324', 'pjField', '2', 'title', 'Prenota X ore prima', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1413', '325', 'pjField', '2', 'title', 'quante ore prima, puoi prenotare un tavolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1414', '326', 'pjField', '2', 'title', 'Tutte le prenotazioni che vengono fatte ma NON pagate verranno impostate con il seguente stato:', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1415', '327', 'pjField', '2', 'title', 'imposta lo stato predefinito per ogni prenotazione dopo che è stata effettuata', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1416', '328', 'pjField', '2', 'title', 'Tutte le prenotazioni effettuate e pagate verranno impostate con il seguente stato:', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1417', '329', 'pjField', '2', 'title', 'imposta lo stato predefinito per ogni prenotazione dopo aver effettuato il pagamento', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1418', '330', 'pjField', '2', 'title', 'URL per la pagina web in cui i tuoi clienti verranno reindirizzati dopo il pagamento tramite PayPal o Authorize.net', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1419', '331', 'pjField', '2', 'title', 'questa è la pagina in cui le persone verranno reindirizzate dopo aver pagato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1420', '332', 'pjField', '2', 'title', 'Selezionare "Sì" se si desidera disabilitare i pagamenti e solo raccogliere i dettagli della prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1421', '333', 'pjField', '2', 'title', 'per disabilitare i pagamenti e accettare solo prenotazioni, impostare su "Sì"', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1422', '334', 'pjField', '2', 'title', 'Consenti pagamenti con Paypal', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1423', '335', 'pjField', '2', 'title', 'Indirizzo email aziendale PayPal', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1424', '336', 'pjField', '2', 'title', 'Consenti pagamenti con Authorize.net', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1425', '337', 'pjField', '2', 'title', 'Consenti pagamenti con Authorize.net', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1426', '338', 'pjField', '2', 'title', 'ID commerciante Authorize.net', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1427', '339', 'pjField', '2', 'title', 'Consentire il pagamento in contanti', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1428', '340', 'pjField', '2', 'title', 'Raccogli i dettagli della carta di credito per l''elaborazione offline', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1429', '341', 'pjField', '2', 'title', 'Fornire i dettagli del conto bancario per i bonifici bancari', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1430', '342', 'pjField', '2', 'title', 'Conto bancario', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1431', '343', 'pjField', '2', 'title', 'Form Prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1432', '344', 'pjField', '2', 'title', 'Conferma', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1433', '345', 'pjField', '2', 'title', 'Condizioni', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1434', '346', 'pjField', '2', 'title', 'Promemoria', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1435', '347', 'pjField', '2', 'title', 'E-mail di conferma', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1436', '348', 'pjField', '2', 'title', 'Esistono 4 tipi di conferma e-mail: una dopo che è stato inviato il modulo di prenotazione, uno dopo il pagamento, uno è l''e-mail di richiesta e uno al momento della cancellazione della prenotazione. Utilizza i token disponibili per personalizzare i messaggi e-mail.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1437', '349', 'pjField', '2', 'title', 'Indirizzo email di notifica', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1438', '350', 'pjField', '2', 'title', 'Invia email di conferma', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1439', '351', 'pjField', '2', 'title', 'seleziona se e quando l''e-mail di conferma deve essere inviata ai clienti dopo aver effettuato una prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1440', '352', 'pjField', '2', 'title', 'Oggetto della mail di conferma', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1441', '353', 'pjField', '2', 'title', '<u>Token disponibili:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{DtFrom}<br/>{Table}<br/>{People}<br/>{BookingID}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1442', '354', 'pjField', '2', 'title', 'Messaggio e-mail di conferma', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1443', '355', 'pjField', '2', 'title', 'Invia email di conferma del pagamento', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1444', '356', 'pjField', '2', 'title', 'seleziona se e quando l''e-mail di conferma deve essere inviata ai clienti dopo aver effettuato un pagamento per la loro prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1445', '357', 'pjField', '2', 'title', 'Messaggio e-mail di pagamento', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1446', '358', 'pjField', '2', 'title', '<u>Token disponibili:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{DtFrom}<br/>{Table}<br/>{People}<br/>{BookingID}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1447', '359', 'pjField', '2', 'title', 'Invia email di richiesta', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1448', '360', 'pjField', '2', 'title', 'selezionare se e quando l''e-mail di conferma deve essere inviata ai clienti dopo aver effettuato una richiesta per la prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1449', '361', 'pjField', '2', 'title', 'Oggetto dell''email di richiesta', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1450', '362', 'pjField', '2', 'title', 'Messaggio e-mail di richiesta', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1451', '363', 'pjField', '2', 'title', '<u>Token disponibili:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{DtFrom}<br/>{People}<br/>{UniqueID}<br/>{CancelURL}<br/>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1452', '364', 'pjField', '2', 'title', 'Oggetto in email pagamento', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1453', '365', 'pjField', '2', 'title', 'Invia email di cancellazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1454', '366', 'pjField', '2', 'title', 'selezionare se e quando l''e-mail di conferma deve essere inviata ai clienti dopo la cancellazione per la loro prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1455', '367', 'pjField', '2', 'title', 'Oggetto email di cancellazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1456', '368', 'pjField', '2', 'title', 'Messaggio email cancellazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1457', '369', 'pjField', '2', 'title', '<u>Token disponibili:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{DtFrom}<br/>{Table}<br/>{People}<br/>{BookingID}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1458', '421', 'pjField', '2', 'title', 'Opzioni del modulo di prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1459', '422', 'pjField', '2', 'title', 'Scegli i campi che dovrebbero essere disponibili sul modulo di prenotazione e clicca sul pulsante SALVA.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1460', '423', 'pjField', '2', 'title', 'Titolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1461', '424', 'pjField', '2', 'title', 'Selezionare "Sì" se si desidera includere il campo nel modulo di prenotazione, altrimenti selezionare "No"', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1462', '425', 'pjField', '2', 'title', 'Nome', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1463', '426', 'pjField', '2', 'title', 'Cognome', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1464', '427', 'pjField', '2', 'title', 'Telefono', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1465', '428', 'pjField', '2', 'title', 'Email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1466', '429', 'pjField', '2', 'title', 'Società', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1467', '430', 'pjField', '2', 'title', 'Indirizzo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1468', '431', 'pjField', '2', 'title', 'Note', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1469', '432', 'pjField', '2', 'title', 'Voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1470', '433', 'pjField', '2', 'title', 'Città', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1471', '434', 'pjField', '2', 'title', 'Nazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1472', '435', 'pjField', '2', 'title', 'Cap', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1473', '436', 'pjField', '2', 'title', 'Paese', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1474', '437', 'pjField', '2', 'title', 'Captcha', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1475', '438', 'pjField', '2', 'title', 'Termini e Condizioni', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1476', '439', 'pjField', '2', 'title', 'Si prega di scrivere i termini e le condizioni per effettuare la prenotazione e fare clic sul pulsante Salva.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1477', '440', 'pjField', '2', 'title', 'Termini e Condizioni', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1478', '441', 'pjField', '2', 'title', 'Richiesta', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1479', '442', 'pjField', '2', 'title', 'Opzioni promemoria', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1480', '443', 'pjField', '2', 'title', 'Lasciare impostare le opzioni per Promemoria e fare clic sul pulsante SALVA. Include la notifica e-mail e il messaggio SMS.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1481', '444', 'pjField', '2', 'title', 'Attivare le notifiche', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1482', '445', 'pjField', '2', 'title', 'Invia un promemoria via email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1483', '446', 'pjField', '2', 'title', 'Oggetto email promemoria', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1484', '447', 'pjField', '2', 'title', 'Messaggio email promemoria', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1485', '448', 'pjField', '2', 'title', '<u>Token disponibili:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{DtFrom}<br/>{Table}<br/>{People}<br/>{BookingID}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1486', '449', 'pjField', '2', 'title', 'Invia promemoria via SMS', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1487', '450', 'pjField', '2', 'title', 'SMS api key', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1488', '451', 'pjField', '2', 'title', 'SMS messaggio', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1489', '452', 'pjField', '2', 'title', '<u>Token disponibili:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{DtFrom}<br/>{Table}<br/>{People}<br/>{BookingID}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1490', '453', 'pjField', '2', 'title', 'Script di Cron', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1491', '454', 'pjField', '2', 'title', 'E'' necessario impostare un cron job utilizzando il pannello di controllo dell''account di hosting che deve essere eseguito ogni ora. A seconda del tuo server web, dovresti utilizzare l''URL o il percorso di script.<br /><br/>Server path:<br /><span class="bold">{PATH}</span><br /><br />URL:<br /><span class="bold">{URL}</span>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1492', '455', 'pjField', '2', 'title', 'ore prima', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1493', '456', 'pjField', '2', 'title', 'Opzioni del modulo di prenotazione aggiornate', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1494', '457', 'pjField', '2', 'title', 'Le tue impostazioni per il modulo di prenotazione sono state salvate correttamente.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1495', '458', 'pjField', '2', 'title', 'Opzioni di conferma aggiornate', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1496', '459', 'pjField', '2', 'title', 'Le tue impostazioni per la conferma sono state salvate correttamente.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1497', '460', 'pjField', '2', 'title', 'Termini e condizioni aggiornati', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1498', '461', 'pjField', '2', 'title', 'Tutte le modifiche apportate alle opzioni Termini e condizioni sono state salvate.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1499', '462', 'pjField', '2', 'title', 'Promemoria aggiornato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1500', '463', 'pjField', '2', 'title', 'Le tue impostazioni per le opzioni di promemoria sono state salvate correttamente.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1501', '464', 'pjField', '2', 'title', 'prendi la chiave', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1502', '555', 'pjField', '2', 'title', 'codice promozionale', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1503', '556', 'pjField', '2', 'title', 'Sconto', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1504', '558', 'pjField', '2', 'title', 'Valido', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1505', '559', 'pjField', '2', 'title', 'Aggiungi voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1506', '560', 'pjField', '2', 'title', 'Lista Voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1507', '561', 'pjField', '2', 'title', 'Di seguito è riportato l''elenco dei buoni. Se desideri aggiungere un nuovo voucher, fai clic sulla scheda "Aggiungi voucher". Per modificare o eliminare un determinato buono, fare clic sulle icone corrispondenti sulla riga. Puoi anche esportare l''elenco dei voucher o eliminare più voucher selezionati utilizzando il menù popup nella parte inferiore della tabella.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1508', '562', 'pjField', '2', 'title', 'Il codice voucher è già utilizzato.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1509', '563', 'pjField', '2', 'title', 'Aggiungi voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1510', '564', 'pjField', '2', 'title', 'Si prega di compilare il modulo sottostante per aggiungere il codice voucher e lo sconto. E'' possibile aggiungere un buono per data, giorno della settimana o intervallo di date specifici.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1511', '565', 'pjField', '2', 'title', 'importo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1512', '566', 'pjField', '2', 'title', 'Percentuale', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1513', '567', 'pjField', '2', 'title', 'Fisso', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1514', '568', 'pjField', '2', 'title', 'Periodo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1515', '569', 'pjField', '2', 'title', 'Periodico', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1516', '570', 'pjField', '2', 'title', 'Data', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1517', '571', 'pjField', '2', 'title', 'Dalle ore', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1518', '572', 'pjField', '2', 'title', 'Alle ore', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1519', '573', 'pjField', '2', 'title', 'Dalla data / ora', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1520', '574', 'pjField', '2', 'title', 'Alla data / ora', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1521', '575', 'pjField', '2', 'title', 'Lunedì', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1522', '576', 'pjField', '2', 'title', 'Martedì', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1523', '577', 'pjField', '2', 'title', 'Mercoledì', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1524', '578', 'pjField', '2', 'title', 'Giovedi', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1525', '579', 'pjField', '2', 'title', 'Venerdì', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1526', '580', 'pjField', '2', 'title', 'Sabato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1527', '581', 'pjField', '2', 'title', 'Domenica', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1528', '582', 'pjField', '2', 'title', 'Ogni', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1529', '583', 'pjField', '2', 'title', 'Voucher aggiornato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1530', '584', 'pjField', '2', 'title', 'Tutte le modifiche apportate al voucher sono state salvate.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1531', '585', 'pjField', '2', 'title', 'Voucher aggiunto', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1532', '586', 'pjField', '2', 'title', 'Un nuovo buono è stato aggiunto alla lista. Ora puoi aggiungere un altro buono.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1533', '587', 'pjField', '2', 'title', 'Il buono non è stato aggiunto', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1534', '588', 'pjField', '2', 'title', 'Siamo spiacenti che il voucher non possa essere aggiunto con successo.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1535', '589', 'pjField', '2', 'title', 'Voucher non trovato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1536', '590', 'pjField', '2', 'title', 'Manca il buono che stai cercando.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1537', '591', 'pjField', '2', 'title', 'Aggiorna il voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1538', '592', 'pjField', '2', 'title', 'Aggiorna il voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1539', '593', 'pjField', '2', 'title', 'Si prega di apportare le modifiche desiderate nel modulo sottostante per aggiornare le informazioni del voucher e fare clic sul pulsante SALVA.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1540', '594', 'pjField', '2', 'title', 'Orario di lavoro', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1541', '595', 'pjField', '2', 'title', 'Mappa dei tavoli', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1542', '596', 'pjField', '2', 'title', 'Tavoli', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1543', '597', 'pjField', '2', 'title', 'Default', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1544', '598', 'pjField', '2', 'title', 'Custom', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1545', '599', 'pjField', '2', 'title', 'Giorno della settimana', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1546', '600', 'pjField', '2', 'title', 'Ora di inizio', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1547', '601', 'pjField', '2', 'title', 'Ora di fine', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1548', '602', 'pjField', '2', 'title', 'Chiusura', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1549', '603', 'pjField', '2', 'title', 'Orario di lavoro aggiornato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1550', '604', 'pjField', '2', 'title', 'Tutte le modifiche apportate all''orario di lavoro sono state salvate.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1551', '605', 'pjField', '2', 'title', 'Orario di lavoro personalizzato salvato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1552', '606', 'pjField', '2', 'title', 'L''orario di lavoro personalizzato è stato salvato con successo.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1553', '697', 'pjField', '2', 'title', 'Mappa', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1554', '698', 'pjField', '2', 'title', 'Opzioni', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1555', '699', 'pjField', '2', 'title', 'Mappa dei tavoli', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1556', '700', 'pjField', '2', 'title', 'Seleziona la casella di controllo "Usa mappa del posto" per abilitare la selezione della tabella della mappa. Devi caricare una mappa immagine JPG del tuo ristorante. Una volta che l''immagine è stata caricata clicca sulla mappa per creare un punto caldo cliccabile per ogni tavolo. Puoi cliccare su ciascun hot spot e posizionarlo sulla mappa. Per eliminare un hot spot fare clic su di esso e quindi fare clic sul pulsante ''Elimina''. Per rinominare un punto caldo (tabella) e impostare la capacità delle persone basta fare clic su di esso.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1557', '701', 'pjField', '2', 'title', 'Dimensioni hot spot', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1558', '702', 'pjField', '2', 'title', 'Qui sotto puoi impostare la dimensione dei punti caldi che crei sulla mappa. E'' possibile creare hot spot di dimensioni diverse su ciascuna mappa. Basta inserire la dimensione desiderata, fare click sul pulsante Salva e andare alla scheda Aggiorna mappa per creare il nuovo hot spot. Visita la <a href="http://www.phpjabbers.com/knowledgebase.php?product=134" target="_blank">Knowledgebase</a> per guardare il video che mostra come creare una mappa.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1559', '703', 'pjField', '2', 'title', 'Usa la mappa dei tavoli', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1560', '704', 'pjField', '2', 'title', 'File', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1561', '705', 'pjField', '2', 'title', 'Elimina questo file immagine', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1562', '706', 'pjField', '2', 'title', 'Sei sicuro di voler eliminare questo file immagine? Se sì, il file immagine verrà eliminato e non sarà possibile ripristinarlo.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1563', '707', 'pjField', '2', 'title', 'Aggiorna mappa', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1564', '708', 'pjField', '2', 'title', 'Aggiungi un nome personalizzato per questo posto sulla mappa (settore VIP, settore A, ecc.). Imposta anche quanti posti disponibili possono essere riservati in questo settore.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1565', '709', 'pjField', '2', 'title', 'Capacità', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1566', '710', 'pjField', '2', 'title', 'Minimo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1567', '711', 'pjField', '2', 'title', 'Impostazioni della mappa aggiornate', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1568', '712', 'pjField', '2', 'title', 'Tutte le impostazioni fatte sulla mappa sono state salvate.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1569', '713', 'pjField', '2', 'title', 'Stai usando una mappa dei tavoli.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1570', '714', 'pjField', '2', 'title', 'Larghezza', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1571', '715', 'pjField', '2', 'title', 'Altezza', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1572', '716', 'pjField', '2', 'title', 'Lista tavoli', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1573', '717', 'pjField', '2', 'title', 'Aggiungi tavolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1574', '718', 'pjField', '2', 'title', 'Aggiungi nuovo tavolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1575', '719', 'pjField', '2', 'title', 'Aggiungi una nuova tabella e imposta il numero di persone autorizzate a prenotare un tavolo. Ad esempio, se minimo è impostato su 2 e capacità è impostato su 4, per questa tavolo verrà accettata solo la prenotazione per 2, 3 o 4 persone.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1576', '720', 'pjField', '2', 'title', 'Il nome della tabella era già utilizzato.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1577', '721', 'pjField', '2', 'title', 'Aggiunto tavolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1578', '722', 'pjField', '2', 'title', 'Un nuovo tavolo è stato aggiunto alla lista.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1579', '723', 'pjField', '2', 'title', 'Non sono riuscito ad aggiungere il tavolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1580', '724', 'pjField', '2', 'title', 'Siamo spiacenti che il tavolo non possa essere aggiunto con successo.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1581', '725', 'pjField', '2', 'title', 'Tavolo aggiornato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1582', '726', 'pjField', '2', 'title', 'Tutte le modifiche apportate al tavolo sono state salvate.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1583', '727', 'pjField', '2', 'title', 'Tavolo non trovato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1584', '728', 'pjField', '2', 'title', 'Il tavolo che stai cercando manca.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1585', '729', 'pjField', '2', 'title', 'Aggiornare tavolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1586', '730', 'pjField', '2', 'title', 'Aggiornare tavolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1587', '731', 'pjField', '2', 'title', 'Sotto puoi impostare il numero di persone autorizzate a prenotare un tavolo. Ad esempio, se minimo è impostato su 2 e capacità è impostato su 4, per questo tavolo verrà accettata solo la prenotazione per 2, 3 o 4 persone.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1588', '732', 'pjField', '2', 'title', 'Aggiornare', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1589', '733', 'pjField', '2', 'title', 'Orario', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1590', '734', 'pjField', '2', 'title', 'Elenco prenotazioni', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1591', '735', 'pjField', '2', 'title', 'Stampa', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1592', '736', 'pjField', '2', 'title', 'Filtri', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1593', '737', 'pjField', '2', 'title', 'Tavoli non trovati', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1594', '738', 'pjField', '2', 'title', '%s Chiuso', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1595', '739', 'pjField', '2', 'title', 'Confermato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1596', '740', 'pjField', '2', 'title', 'Cancellato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1597', '741', 'pjField', '2', 'title', 'in attesa di', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1598', '742', 'pjField', '2', 'title', 'Ricerca', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1599', '743', 'pjField', '2', 'title', 'Dalla data / ora', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1600', '744', 'pjField', '2', 'title', 'Formato data / ora', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1601', '745', 'pjField', '2', 'title', 'Dalla data', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1602', '746', 'pjField', '2', 'title', 'Alla data', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1603', '747', 'pjField', '2', 'title', 'Tavolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1604', '748', 'pjField', '2', 'title', 'Telefono', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1605', '749', 'pjField', '2', 'title', 'Prenotazione non trovata', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1606', '750', 'pjField', '2', 'title', 'Ci dispiace che manchi la prenotazione che stai cercando.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1607', '751', 'pjField', '2', 'title', 'Dettagli della prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1608', '752', 'pjField', '2', 'title', 'Dettagli del cliente', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1609', '753', 'pjField', '2', 'title', 'Aggiornamento Prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1610', '754', 'pjField', '2', 'title', 'ID univoco', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1611', '755', 'pjField', '2', 'title', 'Deposito pagato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1612', '756', 'pjField', '2', 'title', 'Sì', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1613', '757', 'pjField', '2', 'title', 'No', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1614', '758', 'pjField', '2', 'title', 'Paypal', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1615', '759', 'pjField', '2', 'title', 'Authorize.net', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1616', '760', 'pjField', '2', 'title', 'Carta di credito', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1617', '761', 'pjField', '2', 'title', 'Contanti', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1618', '762', 'pjField', '2', 'title', 'Conto bancario', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1619', '763', 'pjField', '2', 'title', 'Metodo di pagamento', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1620', '764', 'pjField', '2', 'title', 'Tipo CC', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1621', '765', 'pjField', '2', 'title', 'Visa', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1622', '766', 'pjField', '2', 'title', 'MasterCard', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1623', '767', 'pjField', '2', 'title', 'Maestro', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1624', '768', 'pjField', '2', 'title', 'AmericanExpress', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1625', '769', 'pjField', '2', 'title', 'Numero CC', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1626', '770', 'pjField', '2', 'title', 'Data di scadenza CC', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1627', '771', 'pjField', '2', 'title', 'Codice di sicurezza CC', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1628', '772', 'pjField', '2', 'title', 'Totale', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1629', '773', 'pjField', '2', 'title', 'Persone', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1630', '774', 'pjField', '2', 'title', 'Nome tavolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1631', '775', 'pjField', '2', 'title', 'Visualizza disponibilità', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1632', '776', 'pjField', '2', 'title', 'Disponibilità', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1633', '777', 'pjField', '2', 'title', 'Mr', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1634', '778', 'pjField', '2', 'title', 'Mrs', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1635', '779', 'pjField', '2', 'title', 'Ms', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1636', '780', 'pjField', '2', 'title', 'Dr', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1637', '781', 'pjField', '2', 'title', 'Prof', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1638', '782', 'pjField', '2', 'title', 'Rev', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1639', '783', 'pjField', '2', 'title', 'Altro', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1640', '784', 'pjField', '2', 'title', 'Titolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1641', '785', 'pjField', '2', 'title', 'Nome', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1642', '786', 'pjField', '2', 'title', 'Cognome', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1643', '787', 'pjField', '2', 'title', 'Telefono', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1644', '788', 'pjField', '2', 'title', 'Email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1645', '789', 'pjField', '2', 'title', 'Note', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1646', '790', 'pjField', '2', 'title', 'Nome società', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1647', '791', 'pjField', '2', 'title', 'Indirizzo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1648', '792', 'pjField', '2', 'title', 'Città', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1649', '793', 'pjField', '2', 'title', 'Contea/Regione/Stato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1650', '794', 'pjField', '2', 'title', 'CAP / Zip', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1651', '795', 'pjField', '2', 'title', 'Nazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1652', '796', 'pjField', '2', 'title', 'Prenotazione aggiornata', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1653', '797', 'pjField', '2', 'title', 'Tutte le modifiche apportate alla prenotazione sono state salvate.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1654', '798', 'pjField', '2', 'title', 'Stampa i dettagli della prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1655', '799', 'pjField', '2', 'title', 'Reinvia email di conferma', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1656', '800', 'pjField', '2', 'title', 'ID', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1657', '801', 'pjField', '2', 'title', 'Creato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1658', '802', 'pjField', '2', 'title', 'Paypal ID transazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1659', '803', 'pjField', '2', 'title', 'Processato ON', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1660', '805', 'pjField', '2', 'title', 'Email di promemoria', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1661', '806', 'pjField', '2', 'title', 'E'' possibile apportare qualsiasi modifica al modulo sottostante e fare clic sul pulsante INVIA per inviare il messaggio di promemoria.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1662', '807', 'pjField', '2', 'title', 'A', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1663', '808', 'pjField', '2', 'title', 'Oggetto', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1664', '809', 'pjField', '2', 'title', 'Messaggio', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1665', '810', 'pjField', '2', 'title', 'Email di promemoria inviata', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1666', '811', 'pjField', '2', 'title', 'L''e-mail di promemoria è stata inviata all''indirizzo di posta elettronica fornito.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1667', '812', 'pjField', '2', 'title', 'Promemoria non è riuscito a inviare', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1668', '813', 'pjField', '2', 'title', 'L''email di promemoria non può essere inviata correttamente. Si prega di controllare di nuovo.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1669', '814', 'pjField', '2', 'title', 'Nome cliente', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1670', '815', 'pjField', '2', 'title', 'Persona', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1671', '816', 'pjField', '2', 'title', 'Nessuna prenotazione trovata', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1672', '817', 'pjField', '2', 'title', 'Stampa', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1673', '818', 'pjField', '2', 'title', 'Installa il codice', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1674', '819', 'pjField', '2', 'title', 'Copia il codice qui sotto e inseriscilo nella tua pagina web. Mostrerò il motore di prenotazione front-end. Si noti che il codice deve essere utilizzato su una pagina Web dallo stesso nome di dominio in cui è installato lo script.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1675', '820', 'pjField', '2', 'title', 'Opzioni linguaggio', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1676', '821', 'pjField', '2', 'title', 'Linguaggio', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1677', '822', 'pjField', '2', 'title', 'Nascondi il selettore di lingua', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1678', '823', 'pjField', '2', 'title', 'Step 1 (Richiesto)', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1679', '824', 'pjField', '2', 'title', 'Seleziona la data e l''ora per la tua prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1680', '825', 'pjField', '2', 'title', 'Data', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1681', '826', 'pjField', '2', 'title', 'Ora', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1682', '827', 'pjField', '2', 'title', 'Persona', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1683', '828', 'pjField', '2', 'title', 'Verificare la disponibilità', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1684', '829', 'pjField', '2', 'title', 'Tabelle disponibili per% 1s persona / e su% 2s a% 3s. Clicca su un tavolo per prenotare.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1685', '830', 'pjField', '2', 'title', 'Prenotare', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1686', '831', 'pjField', '2', 'title', 'Invia richiesta', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1687', '832', 'pjField', '2', 'title', 'Non c''è tavolo disponibile. Fare click sul pulsante INVIA RICHIESTA per effettuare una richiesta.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1688', '833', 'pjField', '2', 'title', 'Tavolo selezionato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1689', '834', 'pjField', '2', 'title', 'Dettagli della prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1690', '835', 'pjField', '2', 'title', 'Modulo di prenotazione <br/> <span> compila il modulo per prenotare una tabella </ span>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1691', '926', 'pjField', '2', 'title', 'Date e Ora', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1692', '927', 'pjField', '2', 'title', 'Tavolo per% s persona / e', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1693', '928', 'pjField', '2', 'title', 'cambia selezione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1694', '929', 'pjField', '2', 'title', 'Titolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1695', '930', 'pjField', '2', 'title', 'Nome', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1696', '931', 'pjField', '2', 'title', 'Cognome', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1697', '932', 'pjField', '2', 'title', 'Telefono', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1698', '933', 'pjField', '2', 'title', 'Email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1699', '934', 'pjField', '2', 'title', 'Nome Società', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1700', '935', 'pjField', '2', 'title', 'Note', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1701', '936', 'pjField', '2', 'title', 'Indirizzo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1702', '937', 'pjField', '2', 'title', 'Città', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1703', '938', 'pjField', '2', 'title', 'Stato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1704', '939', 'pjField', '2', 'title', 'CAP', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1705', '940', 'pjField', '2', 'title', 'Nazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1706', '941', 'pjField', '2', 'title', 'Check-out', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1707', '942', 'pjField', '2', 'title', 'sconto', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1708', '943', 'pjField', '2', 'title', 'Il pagamento è richiesto per garantire la prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1709', '944', 'pjField', '2', 'title', 'Prezzo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1710', '945', 'pjField', '2', 'title', 'Voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1711', '946', 'pjField', '2', 'title', 'Aggiungi voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1712', '947', 'pjField', '2', 'title', 'Aggiunto voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1713', '948', 'pjField', '2', 'title', 'Rimuovi voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1714', '949', 'pjField', '2', 'title', 'Voucher non valido', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1715', '950', 'pjField', '2', 'title', 'Metodo di pagamento', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1716', '951', 'pjField', '2', 'title', 'Tipo CC', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1717', '952', 'pjField', '2', 'title', 'Numero CC', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1718', '953', 'pjField', '2', 'title', 'Data di scadenza CC', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1719', '954', 'pjField', '2', 'title', 'Codice di sicurezza CC', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1720', '955', 'pjField', '2', 'title', 'Captcha', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1721', '1046', 'pjField', '2', 'title', 'Questo campo è obbligatorio.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1722', '1047', 'pjField', '2', 'title', 'L''email non è valida.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1723', '1048', 'pjField', '2', 'title', 'Captcha non è corretto.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1724', '1049', 'pjField', '2', 'title', 'E'' richiesto il mese di scadenza.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1725', '1050', 'pjField', '2', 'title', 'E'' richiesto l''anno di scadenza.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1726', '1051', 'pjField', '2', 'title', 'Ho letto e accetto la prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1727', '1052', 'pjField', '2', 'title', 'Termini e Condizioni', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1728', '1053', 'pjField', '2', 'title', 'Riepilogo prenotazione <br/> <span> informazioni dettagliate </ span>', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1729', '1054', 'pjField', '2', 'title', 'Conferma prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1730', '1055', 'pjField', '2', 'title', 'Indietro', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1731', '1056', 'pjField', '2', 'title', 'Prenotazione non salvata.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1732', '1057', 'pjField', '2', 'title', 'La tua prenotazione è stata salvata. Reindirizzamento a PayPal ...', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1733', '1058', 'pjField', '2', 'title', 'La tua prenotazione è stata salvata. Reindirizzamento a Authorize.net ...', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1734', '1059', 'pjField', '2', 'title', 'La tua prenotazione è stata salvata. [STAG] Ricomincia [ETAG].', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1735', '1060', 'pjField', '2', 'title', 'La tua richiesta è stata inviata. [STAG] Ricomincia [ETAG].', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1736', '1061', 'pjField', '2', 'title', 'La prenotazione è in elaborazione ...', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1737', '1062', 'pjField', '2', 'title', 'Errore! Alcuni parametri sono mancanti', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1738', '1063', 'pjField', '2', 'title', 'Prenotazioni al ristorante', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1739', '1064', 'pjField', '2', 'title', 'Cancella prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1740', '1065', 'pjField', '2', 'title', 'Parametri mancanti', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1741', '1066', 'pjField', '2', 'title', 'La prenotazione con ID non esiste.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1742', '1067', 'pjField', '2', 'title', 'L''hash della sicurezza non corrisponde', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1743', '1068', 'pjField', '2', 'title', 'La prenotazione è già stata cancellata.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1744', '1069', 'pjField', '2', 'title', 'La prenotazione è stata cancellata con successo.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1745', '1070', 'pjField', '2', 'title', 'I dettagli della tua prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1746', '1071', 'pjField', '2', 'title', 'Da Data / Ora', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1747', '1072', 'pjField', '2', 'title', 'Persone', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1748', '1073', 'pjField', '2', 'title', 'Codice Voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1749', '1074', 'pjField', '2', 'title', 'Titolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1750', '1075', 'pjField', '2', 'title', 'Descrizione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1751', '1076', 'pjField', '2', 'title', 'Data / Ora', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1752', '1077', 'pjField', '2', 'title', 'Nome', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1753', '1078', 'pjField', '2', 'title', 'Cognome', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1754', '1079', 'pjField', '2', 'title', 'Email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1755', '1080', 'pjField', '2', 'title', 'Telefono', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1756', '1081', 'pjField', '2', 'title', 'Società', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1757', '1082', 'pjField', '2', 'title', 'Nazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1758', '1083', 'pjField', '2', 'title', 'Città', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1759', '1084', 'pjField', '2', 'title', 'Stato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1760', '1085', 'pjField', '2', 'title', 'CAP', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1761', '1086', 'pjField', '2', 'title', 'Indirizzo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1762', '1087', 'pjField', '2', 'title', 'Pagamento', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1763', '1088', 'pjField', '2', 'title', 'Totale', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1764', '1089', 'pjField', '2', 'title', 'Tavolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1765', '1090', 'pjField', '2', 'title', 'Cancella prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1766', '1091', 'pjField', '2', 'title', 'Dati personali', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1767', '1182', 'pjField', '2', 'title', 'Cancellare', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1768', '1183', 'pjField', '2', 'title', '% 1s tabella / i disponibile / i trovata. <br/> fai clic su un tavolo per prenotare', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1769', '1184', 'pjField', '2', 'title', 'Caricamento tavoli ...', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1770', '1185', 'pjField', '2', 'title', 'Impostazioni dell''orario di lavoro', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1771', '1186', 'pjField', '2', 'title', 'Di seguito è riportato il modulo per impostare l''orario di lavoro del ristorante. E'' inoltre possibile impostare diverse impostazioni per alcune date specifiche facendo click sulla scheda personalizzata.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1772', '1187', 'pjField', '2', 'title', 'Non c''è orario di lavoro per il giorno libero.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1773', '1188', 'pjField', '2', 'title', 'Oggi', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1774', '1189', 'pjField', '2', 'title', 'Domani', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1775', '1190', 'pjField', '2', 'title', 'La data selezionata è giorno di chiusura.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1776', '1191', 'pjField', '2', 'title', 'Devi prenotare [HOUR] ore prima.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1777', '1192', 'pjField', '2', 'title', 'Non siamo ancora aperti.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1778', '1193', 'pjField', '2', 'title', 'Siamo chiusi.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1779', '1194', 'pjField', '2', 'title', 'Authorize.net time zone', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1780', '1195', 'pjField', '2', 'title', 'Authorize.net MD5 hash', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1781', '1196', 'pjField', '2', 'title', 'Tavolo / Ora', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1782', '1198', 'pjField', '2', 'title', 'Inserisci prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1783', '1199', 'pjField', '2', 'title', 'Prezzo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1784', '1202', 'pjField', '2', 'title', 'Prenotazione inserita', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1785', '1203', 'pjField', '2', 'title', 'Una nuova prenotazione è stata aggiunta alla lista.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1786', '1204', 'pjField', '2', 'title', 'La prenotazione non può essere aggiunta.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1787', '1206', 'pjField', '2', 'title', 'Annulla', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1788', '1297', 'pjField', '2', 'title', 'Generale', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1789', '1388', 'pjField', '2', 'title', 'Prenotazioni', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1790', '1389', 'pjField', '2', 'title', 'Cliente', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1791', '1390', 'pjField', '2', 'title', 'Amministratore', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1792', '1391', 'pjField', '2', 'title', 'Si prega di inviare una richiesta e confermeremo manualmente la prenotazione.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1793', '1392', 'pjField', '2', 'title', 'Indietro', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1794', '1393', 'pjField', '2', 'title', 'Errore! Per favore, [STAG] ricomincia [ETAG]', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1795', '1394', 'pjField', '2', 'title', 'Tassa di deposito', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1796', '1395', 'pjField', '2', 'title', 'Programma', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1797', '1396', 'pjField', '2', 'title', 'Di default sotto vedi il programma di oggi. Usa il selettore di date per passare a qualsiasi data. E'' inoltre possibile stampare la pianificazione facendo click sul pulsante Stampa.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1798', '1397', 'pjField', '2', 'title', 'Aggiungi nuova prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1799', '1398', 'pjField', '2', 'title', 'Compila il modulo sottostante per aggiungere una nuova prenotazione.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1800', '1399', 'pjField', '2', 'title', 'Aggiorna prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1801', '1400', 'pjField', '2', 'title', 'Aggiorna i dettagli della prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1802', '1401', 'pjField', '2', 'title', 'Lista delle prenotazioni', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1803', '1402', 'pjField', '2', 'title', 'Qui sotto puoi vedere tutte le prenotazioni e le richieste fatte. Fare click su uno di essi per visualizzarlo e modificarlo. Utilizzando i pulsanti è possibile filtrare la prenotazione in base al loro stato. Utilizzare la ricerca avanzata per individuare rapidamente una prenotazione.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1804', '1494', 'pjField', '2', 'title', 'E-mail di conferma', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1805', '1495', 'pjField', '2', 'title', 'Esistono 4 tipi di conferma e-mail: una dopo che è stato inviato il modulo di prenotazione, uno dopo il pagamento, uno è l''email di richiesta e uno al momento della cancellazione della prenotazione. Utilizza i token disponibili per personalizzare i messaggi e-mail.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1806', '1498', 'pjField', '2', 'title', 'Fatto su', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1807', '1499', 'pjField', '2', 'title', 'IP address', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1808', '1500', 'pjField', '2', 'title', 'Cancella prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1809', '1501', 'pjField', '2', 'title', 'CRON job completato.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1810', '1502', 'pjField', '2', 'title', 'Si prega di inserire il numero positivo.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1811', '1503', 'pjField', '2', 'title', 'Il minimo non può essere maggiore della capacità.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1812', '1504', 'pjField', '2', 'title', 'E'' stato utilizzato un ID univoco.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1813', '1505', 'pjField', '2', 'title', 'L''ora di fine deve essere maggiore dell''ora di inizio.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1814', '1506', 'pjField', '2', 'title', 'A data / ora deve essere maggiore di Da data / ora.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1815', '1507', 'pjField', '2', 'title', 'Prezzo dopo lo sconto applicato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1816', '1508', 'pjField', '2', 'title', 'Questo campo è obbligatorio.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1817', '1509', 'pjField', '2', 'title', 'A data / ora deve essere maggiore di Da data / ora.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1818', '1510', 'pjField', '2', 'title', 'Il voucher non è compreso nella data o nell''ora.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1819', '1511', 'pjField', '2', 'title', 'ID prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1820', '1', 'pjOption', '2', 'o_reminder_subject', 'Promemoria di prenotazione', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1821', '1', 'pjOption', '2', 'o_reminder_body', 'Hai appena fatto una prenotazione.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nDate/Time From: {DtFrom}\r\nTable: {Table}\r\nPeople: {People}\r\nBooking ID: {BookingID}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1822', '1', 'pjOption', '2', 'o_reminder_sms_message', '{FirstName}, booking reminder\r\n\r\n{Table}', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1823', '1', 'pjOption', '2', 'o_terms', 'Gentile Ospite, grazie per aver scelto il nostro locale.\r\n\r\nVi informiamo che richiediamo la conferma della prenotazione con carta di credito a garanzia. La prenotazione è gratuita e può essere modificata fino a 4 ore prima dell''arrivo previsto. Verrà applicata una penale di 40 € per persona solo in caso di modifiche della prenotazione oltre questo limite di tempo o in caso di non presentazione (no show). Vi ricorderemo della prenotazione tramite SMS e email. Vi aspettiamo!\r\n', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1824', '1', 'pjOption', '2', 'o_enquiry', NULL, 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1825', '1', 'pjOption', '2', 'o_email_confirmation_subject', 'Conferma prenotazione', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1826', '1', 'pjOption', '2', 'o_email_confirmation_message', 'Hai appena fatto una prenotazione.\r\n\r\nDati personali:\r\nTitolo: {Title}\r\nNome: {FirstName}\r\nCognome: {LastName}\r\nE-Mail: {Email}\r\nTelefono: {Phone}\r\nNote: {Notes}\r\nCittà: {City}\r\n\r\nDettagli della prenotazione:\r\nDate/Ora : {DtFrom}\r\nTavolo: {Table}\r\nPersone: {People}\r\nID prenotazione: {BookingID}\r\nID univoco: {UniqueID}\r\nTotale: {Total}\r\n\r\nSe vuoi cancellare la tua prenotazione segui il link seguente: {CancelURL}\r\n\r\nGrazie, ti contatteremo al più presto.', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1827', '1', 'pjOption', '2', 'o_email_payment_subject', 'Informazioni su pagamento', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1828', '1', 'pjOption', '2', 'o_email_payment_message', 'Hai appena fatto una prenotazione.\r\n\r\nDati personali:\r\nTitolo: {Title}\r\nNome: {FirstName}\r\nCognome: {LastName}\r\nE-Mail: {Email}\r\nTelefono: {Phone}\r\nNote: {Notes}\r\nCittà: {City}\r\n\r\nDettagli della prenotazione:\r\nDate/Ora : {DtFrom}\r\nTavolo: {Table}\r\nPersone: {People}\r\nID prenotazione: {BookingID}\r\nID univoco: {UniqueID}\r\nTotale: {Total}\r\n\r\nSe vuoi cancellare la tua prenotazione segui il link seguente: {CancelURL}\r\n\r\nGrazie, ti contatteremo al più presto.', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1829', '1', 'pjOption', '2', 'o_email_cancel_subject', 'Cancellazione prenotazione', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1830', '1', 'pjOption', '2', 'o_email_cancel_message', 'Hai appena cancellato una prenotazione.\r\n\r\nDati personali:\r\nTitolo: {Title}\r\nNome: {FirstName}\r\nCognome: {LastName}\r\nE-Mail: {Email}\r\nTelefono: {Phone}\r\nNote: {Notes}\r\nCittà: {City}\r\n\r\nDettagli della prenotazione:\r\nDate/Ora : {DtFrom}\r\nTavolo: {Table}\r\nPersone: {People}\r\nID prenotazione: {BookingID}\r\nID univoco: {UniqueID}\r\nTotale: {Total}\r\n\r\nGrazie!', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1831', '1', 'pjOption', '2', 'o_email_enquiry_subject', 'Richiesta informazioni', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1832', '1', 'pjOption', '2', 'o_email_enquiry_message', 'Hai appena fatto una richiesta.\r\n\r\nDati personali:\r\nTitolo: {Title}\r\nNome: {FirstName}\r\nCognome: {LastName}\r\nE-Mail: {Email}\r\nTelefono: {Phone}\r\nNote: {Notes}\r\nCittà: {City}\r\n\r\nDettagli di richiesta:\r\nData/Ora: {DtFrom}\r\nPersone: {People}\r\nID univoco: {UniqueID}\r\n\r\nSe vuoi cancellare la tua richiesta segui il link seguente: {CancelURL}\r\n\r\nGrazie, ti contatteremo al più presto.', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1833', '1', 'pjOption', '2', 'o_admin_email_confirmation_subject', 'Conferma prenotazione', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1834', '1', 'pjOption', '2', 'o_admin_email_confirmation_message', 'Hai appena fatto una prenotazione.\r\n\r\nDati personali:\r\nTitolo: {Title}\r\nNome: {FirstName}\r\nCognome: {LastName}\r\nE-Mail: {Email}\r\nTelefono: {Phone}\r\nNote: {Notes}\r\nCittà: {City}\r\n\r\nDettagli della prenotazione:\r\nDate/Ora : {DtFrom}\r\nTavolo: {Table}\r\nPersone: {People}\r\nID prenotazione: {BookingID}\r\nID univoco: {UniqueID}\r\nTotale: {Total}\r\n\r\nGrazie!', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1835', '1', 'pjOption', '2', 'o_admin_email_payment_subject', 'Informazioni su pagamento', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1836', '1', 'pjOption', '2', 'o_admin_email_payment_message', 'Hai appena fatto una prenotazione.\r\n\r\nDati personali:\r\nTitolo: {Title}\r\nNome: {FirstName}\r\nCognome: {LastName}\r\nE-Mail: {Email}\r\nTelefono: {Phone}\r\nNote: {Notes}\r\nCittà: {City}\r\n\r\nDettagli della prenotazione:\r\nDate/Ora : {DtFrom}\r\nTavolo: {Table}\r\nPersone: {People}\r\nID prenotazione: {BookingID}\r\nID univoco: {UniqueID}\r\nTotale: {Total}\r\n\r\nGrazie!', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1837', '1', 'pjOption', '2', 'o_admin_email_enquiry_subject', 'Richiesta informazioni', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1838', '1', 'pjOption', '2', 'o_admin_email_enquiry_message', 'Hai appena fatto una richiesta.\r\n\r\nDati personali:\r\nTitolo: {Title}\r\nNome: {FirstName}\r\nCognome: {LastName}\r\nE-Mail: {Email}\r\nTelefono: {Phone}\r\nNote: {Notes}\r\nCittà: {City}\r\n\r\nDettagli di richiesta:\r\nData/Ora: {DtFrom}\r\nPersone: {People}\r\nID univoco: {UniqueID}\r\n\r\nGrazie!', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1839', '1', 'pjOption', '2', 'o_admin_email_cancel_subject', 'Cancellazione prenotazione', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1840', '1', 'pjOption', '2', 'o_admin_email_cancel_message', 'Hai appena cancellato una prenotazione.\r\n\r\nDati personali:\r\nTitolo: {Title}\r\nNome: {FirstName}\r\nCognome: {LastName}\r\nE-Mail: {Email}\r\nTelefono: {Phone}\r\nNote: {Notes}\r\nCittà: {City}\r\n\r\nDettagli della prenotazione:\r\nDate/Ora : {DtFrom}\r\nTavolo: {Table}\r\nPersone: {People}\r\nID prenotazione: {BookingID}\r\nID univoco: {UniqueID}\r\nTotale: {Total}\r\n\r\nGrazie!', 'data');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1841', '1512', 'pjField', '2', 'title', 'Linguaggi', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1842', '1513', 'pjField', '2', 'title', 'Tradurre', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1843', '1514', 'pjField', '2', 'title', 'Linguaggi', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1844', '1515', 'pjField', '2', 'title', 'Aggiungi tutte le lingue necessarie al tuo script. Per ciascuna delle lingue aggiunte è necessario tradurre tutti i titoli di testo.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1845', '1516', 'pjField', '2', 'title', 'Titoli', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1846', '1517', 'pjField', '2', 'title', 'Utilizzando il modulo sottostante è possibile modificare tutto il testo nel software. <br /> <br /> Ogni parte di testo utilizzata nel software viene salvata nel database e ha un proprio ID univoco. Nella prima colonna qui sotto puoi vedere l''ID per ogni pezzo di testo. Per mostrare questi ID nello script stesso, seleziona la casella di controllo "Mostra ID" e fai clic sul pulsante Salva accanto ad esso. Questo mostrerà il corrispondente: ID: per ogni messaggio di testo. Si prega di notare che SOLO vedrete questi ID. Ora puoi cercare qualsiasi ID e cambiare e / o tradurre facilmente il testo. Tieni presente che dovresti usare: prima e dopo l''ID quando lo cerchi. <br /> <br /> Consulta la nostra <a target="_blank" href="http://www.phpjabbers.com/knowledgebase/other"> knowledgebase </a> e guarda tutorial video su come cambiare e / o tradurre il testo.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1847', '1518', 'pjField', '2', 'title', 'Titolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1848', '1519', 'pjField', '2', 'title', 'Flag', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1849', '1520', 'pjField', '2', 'title', 'E'' predefinito', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1850', '1521', 'pjField', '2', 'title', 'Ordine', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1851', '1522', 'pjField', '2', 'title', 'Inserisci lingua', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1852', '1523', 'pjField', '2', 'title', 'Campo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1853', '1524', 'pjField', '2', 'title', 'Valore', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1854', '1525', 'pjField', '2', 'title', 'Titolo di back-end', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1855', '1526', 'pjField', '2', 'title', 'Titolo di front-end', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1856', '1527', 'pjField', '2', 'title', 'Titolo speciale', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1857', '1528', 'pjField', '2', 'title', 'Titoli aggiornati', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1858', '1529', 'pjField', '2', 'title', 'Tutte le modifiche apportate ai titoli sono state salvate.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1859', '1530', 'pjField', '2', 'title', 'Per pagina', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1860', '1531', 'pjField', '2', 'title', 'Errore di importazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1861', '1532', 'pjField', '2', 'title', 'Importazione non riuscita a causa di parametri mancanti.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1862', '1533', 'pjField', '2', 'title', 'Import completato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1863', '1534', 'pjField', '2', 'title', 'L''importazione è stata eseguita con successo.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1864', '1535', 'pjField', '2', 'title', 'Errore di importazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1865', '1536', 'pjField', '2', 'title', 'Importazione non riuscita a causa di dati vuoti.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1866', '1537', 'pjField', '2', 'title', 'Errore di importazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1867', '1538', 'pjField', '2', 'title', 'Importazione non riuscita perché il file non può essere aperto.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1868', '1539', 'pjField', '2', 'title', 'Import / Export', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1869', '1540', 'pjField', '2', 'title', 'Import', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1870', '1541', 'pjField', '2', 'title', 'Export', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1871', '1542', 'pjField', '2', 'title', 'Sfoglia il tuo computer', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1872', '1543', 'pjField', '2', 'title', 'Import / Export', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1873', '1544', 'pjField', '2', 'title', 'Utilizza il modulo sottostante per importare o esportare CSV con tutti i titoli. Per favore, non modificare la prima riga e la prima e la seconda colonna nel file CSV.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1874', '1545', 'pjField', '2', 'title', 'ID:', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1875', '1546', 'pjField', '2', 'title', 'Mostra ID', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1876', '1547', 'pjField', '2', 'title', 'delimitatore', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1877', '1548', 'pjField', '2', 'title', 'Virgola', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1878', '1549', 'pjField', '2', 'title', 'Punto e virgola', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1879', '1550', 'pjField', '2', 'title', 'Tab', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1880', '1551', 'pjField', '2', 'title', 'Sono state trovate le seguenti lingue. Seleziona quelli che vuoi importare.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1881', '1552', 'pjField', '2', 'title', 'Conferma importazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1882', '1553', 'pjField', '2', 'title', 'Importazione fallita', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1883', '1554', 'pjField', '2', 'title', 'Parametri mancanti, vuoti o non validi.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1884', '1555', 'pjField', '2', 'title', 'Importazione fallita', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1885', '1556', 'pjField', '2', 'title', 'Il file non è stato caricato.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1886', '1557', 'pjField', '2', 'title', 'Importazione fallita', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1887', '1558', 'pjField', '2', 'title', 'Il file caricato non può essere aperto per la lettura.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1888', '1559', 'pjField', '2', 'title', 'Importazione fallita', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1889', '1560', 'pjField', '2', 'title', 'Sono state trovate nuove linee(a).', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1890', '1561', 'pjField', '2', 'title', 'Importazione fallita', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1891', '1562', 'pjField', '2', 'title', 'Il file caricato non contiene le colonne necessarie.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1892', '1563', 'pjField', '2', 'title', 'Importazione fallita', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1893', '1564', 'pjField', '2', 'title', 'Il numero di colonne non è uguale su ogni riga.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1894', '1565', 'pjField', '2', 'title', 'Importazione fallita', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1895', '1566', 'pjField', '2', 'title', 'Trovati dati non validi.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1896', '1567', 'pjField', '2', 'title', 'Importazione fallita', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1897', '1568', 'pjField', '2', 'title', 'Colonne mancanti', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1898', '1569', 'pjField', '2', 'title', 'Importazione fallita', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1899', '1570', 'pjField', '2', 'title', 'Dati non validi trovati.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1900', '1571', 'pjField', '2', 'title', 'Mostra ID', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1901', '1572', 'pjField', '2', 'title', 'L''ID verrà visualizzato accanto a ogni testo trovato nel software. E'' quindi possibile cercare un ID per modificare o tradurre facilmente il testo.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1902', '1573', 'pjField', '2', 'title', 'Conferma', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1903', '1574', 'pjField', '2', 'title', 'Annulla', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1904', '1575', 'pjField', '2', 'title', 'default', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1905', '1576', 'pjField', '2', 'title', 'Direzione del testo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1906', '1577', 'pjField', '2', 'title', 'Titolo di front-end', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1907', '1578', 'pjField', '2', 'title', 'Da sinistra a destra', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1908', '1579', 'pjField', '2', 'title', 'Da destra a sinistra', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1909', '1580', 'pjField', '2', 'title', 'Reset flag', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1910', '1581', 'pjField', '2', 'title', 'Sei sicuro di voler ripristinare il flag selezionato?', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1911', '1582', 'pjField', '2', 'title', 'Reset', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1912', '1583', 'pjField', '2', 'title', 'Click su upload', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1913', '1584', 'pjField', '2', 'title', 'Click su reset', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1914', '1585', 'pjField', '2', 'title', 'Linguaggio', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1915', '1586', 'pjField', '2', 'title', 'Chiudi', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1916', '1587', 'pjField', '2', 'title', 'Messaggio informativo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1917', '1588', 'pjField', '2', 'title', 'L''errore è stato trovato alla riga:% s', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1918', '1589', 'pjField', '2', 'title', 'Resetta ricerca', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1919', '1590', 'pjField', '2', 'title', 'Backup', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1920', '1591', 'pjField', '2', 'title', 'Backup completato|', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1921', '1592', 'pjField', '2', 'title', 'Backup fallito!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1922', '1593', 'pjField', '2', 'title', 'Backup fallito!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1923', '1594', 'pjField', '2', 'title', 'Si consiglia di eseguire regolarmente il backup del database e dei file per evitare la perdita di informazioni.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1924', '1595', 'pjField', '2', 'title', 'Tutti i file di backup sono stati salvati.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1925', '1596', 'pjField', '2', 'title', 'Non è stata selezionata nessuna opzione.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1926', '1597', 'pjField', '2', 'title', 'Backup non eseguito.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1927', '1598', 'pjField', '2', 'title', 'Backup', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1928', '1599', 'pjField', '2', 'title', 'Backup database', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1929', '1600', 'pjField', '2', 'title', 'Backup files', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1930', '1601', 'pjField', '2', 'title', 'Backup', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1931', '1602', 'pjField', '2', 'title', 'Backup fallito!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1932', '1603', 'pjField', '2', 'title', 'Cartella di backup non trovata. Assicurati che la cartella "app / web / backup" esista.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1933', '1604', 'pjField', '2', 'title', 'Backup fallito!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1934', '1605', 'pjField', '2', 'title', 'E'' necessario impostare le autorizzazioni di scrittura (chmod 777) nella cartella "app / web / backup".', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1935', '1606', 'pjField', '2', 'title', 'Data/Ora', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1936', '1607', 'pjField', '2', 'title', 'Tipo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1937', '1608', 'pjField', '2', 'title', 'File', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1938', '1609', 'pjField', '2', 'title', 'Sei sicuro di voler eliminare il file selezionato?', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1939', '1610', 'pjField', '2', 'title', 'Elimina selezionato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1940', '1611', 'pjField', '2', 'title', 'Dimensione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1941', '1612', 'pjField', '2', 'title', 'DimensioneXXXX', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1942', '1613', 'pjField', '2', 'title', 'Log', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1943', '1614', 'pjField', '2', 'title', 'Registro di configurazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1944', '1615', 'pjField', '2', 'title', 'Registro vuoto', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1945', '1616', 'pjField', '2', 'title', 'Registro di configurazione aggiornato.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1946', '1617', 'pjField', '2', 'title', 'Il registro di configurazione è stato aggiornato.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1947', '1618', 'pjField', '2', 'title', 'Lista', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1948', '1619', 'pjField', '2', 'title', '+ Aggiungi', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1949', '1620', 'pjField', '2', 'title', 'Informazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1950', '1621', 'pjField', '2', 'title', 'Si noti che dopo aver modificato gli script nell''elenco sotto è necessario aggiornare la pagina per applicare i nuovi aggiornamenti nel menu "One admiN".', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1951', '1622', 'pjField', '2', 'title', 'Data / Ora', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1952', '1623', 'pjField', '2', 'title', 'MC Gross', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1953', '1624', 'pjField', '2', 'title', 'Valuta MC', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1954', '1625', 'pjField', '2', 'title', 'Email del beneficiario', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1955', '1626', 'pjField', '2', 'title', 'Tipo Txn', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1956', '1627', 'pjField', '2', 'title', 'ID Txn', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1957', '1628', 'pjField', '2', 'title', 'ID dell''iscrizione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1958', '1629', 'pjField', '2', 'title', 'ID estero', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1959', '1630', 'pjField', '2', 'title', 'Chiuso', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1960', '1631', 'pjField', '2', 'title', 'Dettagli transazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1961', '1632', 'pjField', '2', 'title', 'Vista', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1962', '1633', 'pjField', '2', 'title', 'IPN', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1963', '1634', 'pjField', '2', 'title', 'Nome nazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1964', '1635', 'pjField', '2', 'title', 'Alpha 2', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1965', '1636', 'pjField', '2', 'title', 'Alpha 3', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1966', '1637', 'pjField', '2', 'title', 'Status', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1967', '1638', 'pjField', '2', 'title', 'Aggiungi +', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1968', '1639', 'pjField', '2', 'title', 'Attivo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1969', '1640', 'pjField', '2', 'title', 'Inattivo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1970', '1641', 'pjField', '2', 'title', 'Salva', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1971', '1642', 'pjField', '2', 'title', 'Annulla', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1972', '1643', 'pjField', '2', 'title', 'Nazioni', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1973', '1644', 'pjField', '2', 'title', 'Aggiorna nazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1974', '1645', 'pjField', '2', 'title', 'Inserisci nazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1975', '1646', 'pjField', '2', 'title', 'Non sono riuscito ad aggiungere la nazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1976', '1647', 'pjField', '2', 'title', 'Nazione non trovata', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1977', '1648', 'pjField', '2', 'title', 'Inserisci nazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1978', '1649', 'pjField', '2', 'title', 'Aggiorna nazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1979', '1650', 'pjField', '2', 'title', 'Gestisci nazioni', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1980', '1651', 'pjField', '2', 'title', 'La nazione è stata aggiornata con successo.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1981', '1652', 'pjField', '2', 'title', 'La nazione è stata aggiunta con successo.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1982', '1653', 'pjField', '2', 'title', 'La nazione non è stato aggiunta.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1983', '1654', 'pjField', '2', 'title', 'La nazione che stai cercando non è stata trovata.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1984', '1655', 'pjField', '2', 'title', 'Usa il modulo qui sotto per aggiornare una nazione.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1985', '1656', 'pjField', '2', 'title', 'Usa il modulo qui sotto per aggiornare una nazione.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1986', '1657', 'pjField', '2', 'title', 'Usa la griglia qui sotto per organizzare la tua lista nazioni.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1987', '1658', 'pjField', '2', 'title', 'Sei sicuro di voler eliminare la Nazione selezionataà', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1988', '1659', 'pjField', '2', 'title', 'Elimina selezionato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1989', '1660', 'pjField', '2', 'title', 'Tutti', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1990', '1661', 'pjField', '2', 'title', 'Ricerca', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1991', '1', 'pjCountry', '2', 'name', 'Afghanistan', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1992', '2', 'pjCountry', '2', 'name', 'Åland Islands', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1993', '3', 'pjCountry', '2', 'name', 'Albania', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1994', '4', 'pjCountry', '2', 'name', 'Algeria', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1995', '5', 'pjCountry', '2', 'name', 'American Samoa', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1996', '6', 'pjCountry', '2', 'name', 'Andorra', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1997', '7', 'pjCountry', '2', 'name', 'Angola', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1998', '8', 'pjCountry', '2', 'name', 'Anguilla', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('1999', '9', 'pjCountry', '2', 'name', 'Antarctica', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2000', '10', 'pjCountry', '2', 'name', 'Antigua and Barbuda', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2001', '11', 'pjCountry', '2', 'name', 'Argentina', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2002', '12', 'pjCountry', '2', 'name', 'Armenia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2003', '13', 'pjCountry', '2', 'name', 'Aruba', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2004', '14', 'pjCountry', '2', 'name', 'Australia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2005', '15', 'pjCountry', '2', 'name', 'Austria', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2006', '16', 'pjCountry', '2', 'name', 'Azerbaijan', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2007', '17', 'pjCountry', '2', 'name', 'Bahamas', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2008', '18', 'pjCountry', '2', 'name', 'Bahrain', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2009', '19', 'pjCountry', '2', 'name', 'Bangladesh', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2010', '20', 'pjCountry', '2', 'name', 'Barbados', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2011', '21', 'pjCountry', '2', 'name', 'Belarus', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2012', '22', 'pjCountry', '2', 'name', 'Belgium', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2013', '23', 'pjCountry', '2', 'name', 'Belize', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2014', '24', 'pjCountry', '2', 'name', 'Benin', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2015', '25', 'pjCountry', '2', 'name', 'Bermuda', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2016', '26', 'pjCountry', '2', 'name', 'Bhutan', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2017', '27', 'pjCountry', '2', 'name', 'Bolivia, Plurinational State of', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2018', '28', 'pjCountry', '2', 'name', 'Bonaire, Sint Eustatius and Saba', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2019', '29', 'pjCountry', '2', 'name', 'Bosnia and Herzegovina', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2020', '30', 'pjCountry', '2', 'name', 'Botswana', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2021', '31', 'pjCountry', '2', 'name', 'Bouvet Island', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2022', '32', 'pjCountry', '2', 'name', 'Brazil', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2023', '33', 'pjCountry', '2', 'name', 'British Indian Ocean Territory', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2024', '34', 'pjCountry', '2', 'name', 'Brunei Darussalam', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2025', '35', 'pjCountry', '2', 'name', 'Bulgaria', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2026', '36', 'pjCountry', '2', 'name', 'Burkina Faso', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2027', '37', 'pjCountry', '2', 'name', 'Burundi', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2028', '38', 'pjCountry', '2', 'name', 'Cambodia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2029', '39', 'pjCountry', '2', 'name', 'Cameroon', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2030', '40', 'pjCountry', '2', 'name', 'Canada', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2031', '41', 'pjCountry', '2', 'name', 'Cape Verde', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2032', '42', 'pjCountry', '2', 'name', 'Cayman Islands', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2033', '43', 'pjCountry', '2', 'name', 'Central African Republic', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2034', '44', 'pjCountry', '2', 'name', 'Chad', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2035', '45', 'pjCountry', '2', 'name', 'Chile', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2036', '46', 'pjCountry', '2', 'name', 'China', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2037', '47', 'pjCountry', '2', 'name', 'Christmas Island', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2038', '48', 'pjCountry', '2', 'name', 'Cocos array(Keeling) Islands', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2039', '49', 'pjCountry', '2', 'name', 'Colombia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2040', '50', 'pjCountry', '2', 'name', 'Comoros', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2041', '51', 'pjCountry', '2', 'name', 'Congo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2042', '52', 'pjCountry', '2', 'name', 'Congo, the Democratic Republic of the', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2043', '53', 'pjCountry', '2', 'name', 'Cook Islands', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2044', '54', 'pjCountry', '2', 'name', 'Costa Rica', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2045', '55', 'pjCountry', '2', 'name', 'Côte d''Ivoire', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2046', '56', 'pjCountry', '2', 'name', 'Croatia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2047', '57', 'pjCountry', '2', 'name', 'Cuba', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2048', '58', 'pjCountry', '2', 'name', 'Curaçao', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2049', '59', 'pjCountry', '2', 'name', 'Cyprus', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2050', '60', 'pjCountry', '2', 'name', 'Czech Republic', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2051', '61', 'pjCountry', '2', 'name', 'Denmark', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2052', '62', 'pjCountry', '2', 'name', 'Djibouti', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2053', '63', 'pjCountry', '2', 'name', 'Dominica', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2054', '64', 'pjCountry', '2', 'name', 'Dominican Republic', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2055', '65', 'pjCountry', '2', 'name', 'Ecuador', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2056', '66', 'pjCountry', '2', 'name', 'Egypt', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2057', '67', 'pjCountry', '2', 'name', 'El Salvador', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2058', '68', 'pjCountry', '2', 'name', 'Equatorial Guinea', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2059', '69', 'pjCountry', '2', 'name', 'Eritrea', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2060', '70', 'pjCountry', '2', 'name', 'Estonia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2061', '71', 'pjCountry', '2', 'name', 'Ethiopia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2062', '72', 'pjCountry', '2', 'name', 'Falkland Islands array(Malvinas)', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2063', '73', 'pjCountry', '2', 'name', 'Faroe Islands', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2064', '74', 'pjCountry', '2', 'name', 'Fiji', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2065', '75', 'pjCountry', '2', 'name', 'Finland', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2066', '76', 'pjCountry', '2', 'name', 'France', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2067', '77', 'pjCountry', '2', 'name', 'French Guiana', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2068', '78', 'pjCountry', '2', 'name', 'French Polynesia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2069', '79', 'pjCountry', '2', 'name', 'French Southern Territories', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2070', '80', 'pjCountry', '2', 'name', 'Gabon', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2071', '81', 'pjCountry', '2', 'name', 'Gambia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2072', '82', 'pjCountry', '2', 'name', 'Georgia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2073', '83', 'pjCountry', '2', 'name', 'Germany', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2074', '84', 'pjCountry', '2', 'name', 'Ghana', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2075', '85', 'pjCountry', '2', 'name', 'Gibraltar', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2076', '86', 'pjCountry', '2', 'name', 'Greece', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2077', '87', 'pjCountry', '2', 'name', 'Greenland', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2078', '88', 'pjCountry', '2', 'name', 'Grenada', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2079', '89', 'pjCountry', '2', 'name', 'Guadeloupe', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2080', '90', 'pjCountry', '2', 'name', 'Guam', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2081', '91', 'pjCountry', '2', 'name', 'Guatemala', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2082', '92', 'pjCountry', '2', 'name', 'Guernsey', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2083', '93', 'pjCountry', '2', 'name', 'Guinea', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2084', '94', 'pjCountry', '2', 'name', 'Guinea-Bissau', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2085', '95', 'pjCountry', '2', 'name', 'Guyana', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2086', '96', 'pjCountry', '2', 'name', 'Haiti', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2087', '97', 'pjCountry', '2', 'name', 'Heard Island and McDonald Islands', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2088', '98', 'pjCountry', '2', 'name', 'Holy See array(Vatican City State)', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2089', '99', 'pjCountry', '2', 'name', 'Honduras', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2090', '100', 'pjCountry', '2', 'name', 'Hong Kong', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2091', '101', 'pjCountry', '2', 'name', 'Hungary', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2092', '102', 'pjCountry', '2', 'name', 'Iceland', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2093', '103', 'pjCountry', '2', 'name', 'India', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2094', '104', 'pjCountry', '2', 'name', 'Indonesia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2095', '105', 'pjCountry', '2', 'name', 'Iran, Islamic Republic of', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2096', '106', 'pjCountry', '2', 'name', 'Iraq', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2097', '107', 'pjCountry', '2', 'name', 'Ireland', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2098', '108', 'pjCountry', '2', 'name', 'Isle of Man', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2099', '109', 'pjCountry', '2', 'name', 'Israel', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2100', '110', 'pjCountry', '2', 'name', 'Italy', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2101', '111', 'pjCountry', '2', 'name', 'Jamaica', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2102', '112', 'pjCountry', '2', 'name', 'Japan', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2103', '113', 'pjCountry', '2', 'name', 'Jersey', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2104', '114', 'pjCountry', '2', 'name', 'Jordan', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2105', '115', 'pjCountry', '2', 'name', 'Kazakhstan', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2106', '116', 'pjCountry', '2', 'name', 'Kenya', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2107', '117', 'pjCountry', '2', 'name', 'Kiribati', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2108', '118', 'pjCountry', '2', 'name', 'Korea, Democratic People''s Republic of', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2109', '119', 'pjCountry', '2', 'name', 'Korea, Republic of', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2110', '120', 'pjCountry', '2', 'name', 'Kuwait', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2111', '121', 'pjCountry', '2', 'name', 'Kyrgyzstan', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2112', '122', 'pjCountry', '2', 'name', 'Lao People''s Democratic Republic', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2113', '123', 'pjCountry', '2', 'name', 'Latvia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2114', '124', 'pjCountry', '2', 'name', 'Lebanon', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2115', '125', 'pjCountry', '2', 'name', 'Lesotho', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2116', '126', 'pjCountry', '2', 'name', 'Liberia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2117', '127', 'pjCountry', '2', 'name', 'Libya', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2118', '128', 'pjCountry', '2', 'name', 'Liechtenstein', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2119', '129', 'pjCountry', '2', 'name', 'Lithuania', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2120', '130', 'pjCountry', '2', 'name', 'Luxembourg', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2121', '131', 'pjCountry', '2', 'name', 'Macao', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2122', '132', 'pjCountry', '2', 'name', 'Macedonia, The Former Yugoslav Republic of', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2123', '133', 'pjCountry', '2', 'name', 'Madagascar', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2124', '134', 'pjCountry', '2', 'name', 'Malawi', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2125', '135', 'pjCountry', '2', 'name', 'Malaysia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2126', '136', 'pjCountry', '2', 'name', 'Maldives', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2127', '137', 'pjCountry', '2', 'name', 'Mali', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2128', '138', 'pjCountry', '2', 'name', 'Malta', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2129', '139', 'pjCountry', '2', 'name', 'Marshall Islands', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2130', '140', 'pjCountry', '2', 'name', 'Martinique', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2131', '141', 'pjCountry', '2', 'name', 'Mauritania', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2132', '142', 'pjCountry', '2', 'name', 'Mauritius', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2133', '143', 'pjCountry', '2', 'name', 'Mayotte', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2134', '144', 'pjCountry', '2', 'name', 'Mexico', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2135', '145', 'pjCountry', '2', 'name', 'Micronesia, Federated States of', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2136', '146', 'pjCountry', '2', 'name', 'Moldova, Republic of', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2137', '147', 'pjCountry', '2', 'name', 'Monaco', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2138', '148', 'pjCountry', '2', 'name', 'Mongolia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2139', '149', 'pjCountry', '2', 'name', 'Montenegro', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2140', '150', 'pjCountry', '2', 'name', 'Montserrat', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2141', '151', 'pjCountry', '2', 'name', 'Morocco', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2142', '152', 'pjCountry', '2', 'name', 'Mozambique', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2143', '153', 'pjCountry', '2', 'name', 'Myanmar', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2144', '154', 'pjCountry', '2', 'name', 'Namibia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2145', '155', 'pjCountry', '2', 'name', 'Nauru', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2146', '156', 'pjCountry', '2', 'name', 'Nepal', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2147', '157', 'pjCountry', '2', 'name', 'Netherlands', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2148', '158', 'pjCountry', '2', 'name', 'New Caledonia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2149', '159', 'pjCountry', '2', 'name', 'New Zealand', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2150', '160', 'pjCountry', '2', 'name', 'Nicaragua', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2151', '161', 'pjCountry', '2', 'name', 'Niger', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2152', '162', 'pjCountry', '2', 'name', 'Nigeria', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2153', '163', 'pjCountry', '2', 'name', 'Niue', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2154', '164', 'pjCountry', '2', 'name', 'Norfolk Island', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2155', '165', 'pjCountry', '2', 'name', 'Northern Mariana Islands', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2156', '166', 'pjCountry', '2', 'name', 'Norway', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2157', '167', 'pjCountry', '2', 'name', 'Oman', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2158', '168', 'pjCountry', '2', 'name', 'Pakistan', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2159', '169', 'pjCountry', '2', 'name', 'Palau', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2160', '170', 'pjCountry', '2', 'name', 'Palestine, State of', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2161', '171', 'pjCountry', '2', 'name', 'Panama', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2162', '172', 'pjCountry', '2', 'name', 'Papua New Guinea', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2163', '173', 'pjCountry', '2', 'name', 'Paraguay', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2164', '174', 'pjCountry', '2', 'name', 'Peru', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2165', '175', 'pjCountry', '2', 'name', 'Philippines', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2166', '176', 'pjCountry', '2', 'name', 'Pitcairn', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2167', '177', 'pjCountry', '2', 'name', 'Poland', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2168', '178', 'pjCountry', '2', 'name', 'Portugal', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2169', '179', 'pjCountry', '2', 'name', 'Puerto Rico', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2170', '180', 'pjCountry', '2', 'name', 'Qatar', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2171', '181', 'pjCountry', '2', 'name', 'Réunion', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2172', '182', 'pjCountry', '2', 'name', 'Romania', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2173', '183', 'pjCountry', '2', 'name', 'Russian Federation', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2174', '184', 'pjCountry', '2', 'name', 'Rwanda', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2175', '185', 'pjCountry', '2', 'name', 'Saint Barthélemy', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2176', '186', 'pjCountry', '2', 'name', 'Saint Helena, Ascension and Tristan da Cunha', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2177', '187', 'pjCountry', '2', 'name', 'Saint Kitts and Nevis', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2178', '188', 'pjCountry', '2', 'name', 'Saint Lucia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2179', '189', 'pjCountry', '2', 'name', 'Saint Martin array(French part)', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2180', '190', 'pjCountry', '2', 'name', 'Saint Pierre and Miquelon', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2181', '191', 'pjCountry', '2', 'name', 'Saint Vincent and the Grenadines', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2182', '192', 'pjCountry', '2', 'name', 'Samoa', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2183', '193', 'pjCountry', '2', 'name', 'San Marino', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2184', '194', 'pjCountry', '2', 'name', 'Sao Tome and Principe', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2185', '195', 'pjCountry', '2', 'name', 'Saudi Arabia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2186', '196', 'pjCountry', '2', 'name', 'Senegal', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2187', '197', 'pjCountry', '2', 'name', 'Serbia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2188', '198', 'pjCountry', '2', 'name', 'Seychelles', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2189', '199', 'pjCountry', '2', 'name', 'Sierra Leone', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2190', '200', 'pjCountry', '2', 'name', 'Singapore', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2191', '201', 'pjCountry', '2', 'name', 'Sint Maarten array(Dutch part)', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2192', '202', 'pjCountry', '2', 'name', 'Slovakia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2193', '203', 'pjCountry', '2', 'name', 'Slovenia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2194', '204', 'pjCountry', '2', 'name', 'Solomon Islands', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2195', '205', 'pjCountry', '2', 'name', 'Somalia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2196', '206', 'pjCountry', '2', 'name', 'South Africa', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2197', '207', 'pjCountry', '2', 'name', 'South Georgia and the South Sandwich Islands', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2198', '208', 'pjCountry', '2', 'name', 'South Sudan', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2199', '209', 'pjCountry', '2', 'name', 'Spain', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2200', '210', 'pjCountry', '2', 'name', 'Sri Lanka', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2201', '211', 'pjCountry', '2', 'name', 'Sudan', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2202', '212', 'pjCountry', '2', 'name', 'Suriname', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2203', '213', 'pjCountry', '2', 'name', 'Svalbard and Jan Mayen', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2204', '214', 'pjCountry', '2', 'name', 'Swaziland', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2205', '215', 'pjCountry', '2', 'name', 'Sweden', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2206', '216', 'pjCountry', '2', 'name', 'Switzerland', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2207', '217', 'pjCountry', '2', 'name', 'Syrian Arab Republic', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2208', '218', 'pjCountry', '2', 'name', 'Taiwan, Province of China', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2209', '219', 'pjCountry', '2', 'name', 'Tajikistan', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2210', '220', 'pjCountry', '2', 'name', 'Tanzania, United Republic of', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2211', '221', 'pjCountry', '2', 'name', 'Thailand', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2212', '222', 'pjCountry', '2', 'name', 'Timor-Leste', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2213', '223', 'pjCountry', '2', 'name', 'Togo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2214', '224', 'pjCountry', '2', 'name', 'Tokelau', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2215', '225', 'pjCountry', '2', 'name', 'Tonga', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2216', '226', 'pjCountry', '2', 'name', 'Trinidad and Tobago', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2217', '227', 'pjCountry', '2', 'name', 'Tunisia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2218', '228', 'pjCountry', '2', 'name', 'Turkey', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2219', '229', 'pjCountry', '2', 'name', 'Turkmenistan', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2220', '230', 'pjCountry', '2', 'name', 'Turks and Caicos Islands', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2221', '231', 'pjCountry', '2', 'name', 'Tuvalu', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2222', '232', 'pjCountry', '2', 'name', 'Uganda', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2223', '233', 'pjCountry', '2', 'name', 'Ukraine', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2224', '234', 'pjCountry', '2', 'name', 'United Arab Emirates', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2225', '235', 'pjCountry', '2', 'name', 'United Kingdom', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2226', '236', 'pjCountry', '2', 'name', 'United States', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2227', '237', 'pjCountry', '2', 'name', 'United States Minor Outlying Islands', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2228', '238', 'pjCountry', '2', 'name', 'Uruguay', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2229', '239', 'pjCountry', '2', 'name', 'Uzbekistan', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2230', '240', 'pjCountry', '2', 'name', 'Vanuatu', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2231', '241', 'pjCountry', '2', 'name', 'Venezuela, Bolivarian Republic of', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2232', '242', 'pjCountry', '2', 'name', 'Viet Nam', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2233', '243', 'pjCountry', '2', 'name', 'Virgin Islands, British', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2234', '244', 'pjCountry', '2', 'name', 'Virgin Islands, U.S.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2235', '245', 'pjCountry', '2', 'name', 'Wallis and Futuna', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2236', '246', 'pjCountry', '2', 'name', 'Western Sahara', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2237', '247', 'pjCountry', '2', 'name', 'Yemen', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2238', '248', 'pjCountry', '2', 'name', 'Zambia', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2239', '249', 'pjCountry', '2', 'name', 'Zimbabwe', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2240', '1662', 'pjField', '2', 'title', 'Ripristina lo stato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2241', '1663', 'pjField', '2', 'title', 'SMS', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2242', '1664', 'pjField', '2', 'title', 'SMS Configurazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2243', '1665', 'pjField', '2', 'title', 'Numero di telefono', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2244', '1666', 'pjField', '2', 'title', 'Messaggio', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2245', '1667', 'pjField', '2', 'title', 'Stato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2246', '1668', 'pjField', '2', 'title', 'Data / ora inviata', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2247', '1669', 'pjField', '2', 'title', 'API Key', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2248', '1670', 'pjField', '2', 'title', 'SMS', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2249', '1671', 'pjField', '2', 'title', 'Per inviare SMS è necessaria una chiave API valida. Si prega di contattare AMD Software per acquistare una chiave API.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2250', '1672', 'pjField', '2', 'title', 'Chiave API SMS aggiornata!', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2251', '1673', 'pjField', '2', 'title', 'Tutte le modifiche sono state salvate.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2252', '1674', 'pjField', '2', 'title', 'Resetta la ricerca', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2253', '1675', 'pjField', '2', 'title', 'Siamo spiacenti, ma la tua prenotazione non è andata a buon fine. Il tavolo selezionato è stato appena prenotato da altri mentre effettuavi l''ordine. Puoi [STAG] ricominciare [ETAG] alla ricerca di un''altra tabella.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2254', '1676', 'pjField', '2', 'title', 'Il tavolo selezionato era riservato.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2255', '1677', 'pjField', '2', 'title', 'Dom', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2256', '1678', 'pjField', '2', 'title', 'Lun', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2257', '1679', 'pjField', '2', 'title', 'Mar', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2258', '1680', 'pjField', '2', 'title', 'Mer', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2259', '1681', 'pjField', '2', 'title', 'Gio', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2260', '1682', 'pjField', '2', 'title', 'Ven', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2261', '1683', 'pjField', '2', 'title', 'Sab', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2262', '1684', 'pjField', '2', 'title', 'Parametri mancanti', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2263', '1685', 'pjField', '2', 'title', 'Ore', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2264', '1686', 'pjField', '2', 'title', 'Minuti', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2265', '1687', 'pjField', '2', 'title', 'Si prega di selezionare un tavolo.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2266', '1688', 'pjField', '2', 'title', 'Step 1', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2267', '1689', 'pjField', '2', 'title', 'Step 2', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2268', '1690', 'pjField', '2', 'title', 'Step 3', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2269', '1691', 'pjField', '2', 'title', 'Step 4', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2270', '1692', 'pjField', '2', 'title', 'Modulo di prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2271', '1693', 'pjField', '2', 'title', 'Compila il modulo per prenotare un tavolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2272', '1694', 'pjField', '2', 'title', 'Questo campo è obbligatorio.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2273', '1695', 'pjField', '2', 'title', 'L''indirizzo email non è valido.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2274', '1696', 'pjField', '2', 'title', 'Conto bancario', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2275', '1697', 'pjField', '2', 'title', 'Grazie per la tua prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2276', '1698', 'pjField', '2', 'title', 'Anteprima front end', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2277', '1699', 'pjField', '2', 'title', 'Sono disponibili più combinazioni di colori per il front-end. Fai clic su ciascuna delle miniature sottostanti per visualizzarla in anteprima. Fare clic sul pulsante "Usa questo tema" per il tema che si desidera utilizzare.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2278', '1700', 'pjField', '2', 'title', 'Scegli il tema', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2279', '1701', 'pjField', '2', 'title', 'Tema 1', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2280', '1702', 'pjField', '2', 'title', 'Tema 2', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2281', '1703', 'pjField', '2', 'title', 'Tema 3', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2282', '1704', 'pjField', '2', 'title', 'Tema 4', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2283', '1705', 'pjField', '2', 'title', 'Tema 5', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2284', '1706', 'pjField', '2', 'title', 'Tema 6', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2285', '1707', 'pjField', '2', 'title', 'Tema 7', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2286', '1708', 'pjField', '2', 'title', 'Tema 8', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2287', '1709', 'pjField', '2', 'title', 'Tema 9', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2288', '1710', 'pjField', '2', 'title', 'Tema 10', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2289', '1711', 'pjField', '2', 'title', 'Attualmente in uso', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2290', '1712', 'pjField', '2', 'title', 'Usa questo tema', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2291', '1713', 'pjField', '2', 'title', 'Tavoli disponibili per %1s persona/e su %2s a %3s.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2292', '1714', 'pjField', '2', 'title', 'Clicca su un tavolo disponibile per prenotarlo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2293', '1715', 'pjField', '2', 'title', 'Nessuna tabella disponibile su %1s in %2s.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2294', '1716', 'pjField', '2', 'title', 'Per favore, cambia la data e/o l''ora e controlla la disponibilità', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2295', '1717', 'pjField', '2', 'title', 'Step empty message 2', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2296', '1718', 'pjField', '2', 'title', 'Dettagli richiesta', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2297', '1719', 'pjField', '2', 'title', 'Modulo di richiesta', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2298', '1720', 'pjField', '2', 'title', 'Compila il modulo per fare una richiesta', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2299', '1721', 'pjField', '2', 'title', 'Tavolo', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2300', '1722', 'pjField', '2', 'title', 'per %s persona(e)', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2301', '1723', 'pjField', '2', 'title', 'Nuova Prenotazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2302', '1724', 'pjField', '2', 'title', 'Nuovo Voucher', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2303', '1725', 'pjField', '2', 'title', 'Nuovo Utente', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2304', '1726', 'pjField', '2', 'title', 'Utenti', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2305', '1727', 'pjField', '2', 'title', 'Di seguito è riportato un elenco di tutti gli utenti. E'' possibile aggiungere nuovi utenti, modificare i dettagli dell''utente e modificare lo stato dell''utente.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2306', '1728', 'pjField', '2', 'title', 'Aggiungi utente', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2307', '1729', 'pjField', '2', 'title', 'Compila il modulo sottostante e fare clic sul pulsante "Salva" per aggiungere un nuovo utente.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2308', '1730', 'pjField', '2', 'title', 'Aggiorna utente', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2309', '1731', 'pjField', '2', 'title', 'Puoi apportare eventuali modifiche al modulo sottostante e fare clic sul pulsante "Salva" per aggiornare le informazioni dell''utente.', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2310', '1732', 'pjField', '2', 'title', 'Anteprima', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2311', '1733', 'pjField', '2', 'title', 'Invia email di cancellazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2312', '1734', 'pjField', '2', 'title', 'Invia email di cancellazione', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2313', '1735', 'pjField', '2', 'title', 'Oggetto email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2314', '1736', 'pjField', '2', 'title', 'Messaggio email', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2315', '1737', 'pjField', '2', 'title', 'Inviare', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2316', '1738', 'pjField', '2', 'title', 'Annulla', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2317', '1739', 'pjField', '2', 'title', 'Invia email di conferma', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2318', '1740', 'pjField', '2', 'title', 'Prezzo applicato dopo lo sconto', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2319', '1741', 'pjField', '2', 'title', 'PHP mail()', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2320', '1742', 'pjField', '2', 'title', 'SMTP', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2321', '1743', 'pjField', '2', 'title', 'Confermato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2322', '1744', 'pjField', '2', 'title', 'In Attesa', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2323', '1745', 'pjField', '2', 'title', 'Eliminato', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2324', '1746', 'pjField', '2', 'title', 'Sì', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2325', '1747', 'pjField', '2', 'title', 'No', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2326', '1748', 'pjField', '2', 'title', 'No', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2327', '1749', 'pjField', '2', 'title', 'Sì', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2328', '1750', 'pjField', '2', 'title', 'Sì (richiesto)', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2329', '1751', 'pjField', '2', 'title', 'Elimina', 'script');
INSERT INTO `restaurantbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES('2330', '1752', 'pjField', '2', 'title', 'Registra', 'script');

DROP TABLE IF EXISTS `restaurantbooking_working_times`;

CREATE TABLE `restaurantbooking_working_times` (
  `id` int(10) unsigned NOT NULL DEFAULT '0',
  `monday_from` time DEFAULT NULL,
  `monday_to` time DEFAULT NULL,
  `monday_dayoff` enum('T','F') DEFAULT 'F',
  `tuesday_from` time DEFAULT NULL,
  `tuesday_to` time DEFAULT NULL,
  `tuesday_dayoff` enum('T','F') DEFAULT 'F',
  `wednesday_from` time DEFAULT NULL,
  `wednesday_to` time DEFAULT NULL,
  `wednesday_dayoff` enum('T','F') DEFAULT 'F',
  `thursday_from` time DEFAULT NULL,
  `thursday_to` time DEFAULT NULL,
  `thursday_dayoff` enum('T','F') DEFAULT 'F',
  `friday_from` time DEFAULT NULL,
  `friday_to` time DEFAULT NULL,
  `friday_dayoff` enum('T','F') DEFAULT 'F',
  `saturday_from` time DEFAULT NULL,
  `saturday_to` time DEFAULT NULL,
  `saturday_dayoff` enum('T','F') DEFAULT 'F',
  `sunday_from` time DEFAULT NULL,
  `sunday_to` time DEFAULT NULL,
  `sunday_dayoff` enum('T','F') DEFAULT 'F',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `restaurantbooking_working_times` (`id`, `monday_from`, `monday_to`, `monday_dayoff`, `tuesday_from`, `tuesday_to`, `tuesday_dayoff`, `wednesday_from`, `wednesday_to`, `wednesday_dayoff`, `thursday_from`, `thursday_to`, `thursday_dayoff`, `friday_from`, `friday_to`, `friday_dayoff`, `saturday_from`, `saturday_to`, `saturday_dayoff`, `sunday_from`, `sunday_to`, `sunday_dayoff`) VALUES('1', NULL, NULL, 'F', NULL, NULL, 'F', '12:00:00', '22:00:00', 'F', '12:00:00', '22:00:00', 'F', '12:00:00', '22:00:00', 'F', '12:00:00', '22:00:00', 'F', '12:00:00', '22:00:00', 'F');

DROP TABLE IF EXISTS `restaurantbooking_vouchers`;

CREATE TABLE `restaurantbooking_vouchers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) DEFAULT NULL,
  `type` enum('amount','percent') DEFAULT NULL,
  `discount` decimal(9,2) unsigned DEFAULT NULL,
  `valid` enum('fixed','period','recurring') DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `time_from` time DEFAULT NULL,
  `time_to` time DEFAULT NULL,
  `every` enum('monday','tuesday','wednesday','thursday','friday','saturday','sunday') DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `restaurantbooking_options`;

CREATE TABLE `restaurantbooking_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_admin_email_cancel_message', '3', NULL, NULL, 'text', '13', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_admin_email_cancel_subject', '3', NULL, NULL, 'string', '12', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_admin_email_confirmation_message', '3', NULL, NULL, 'text', '4', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_admin_email_confirmation_subject', '3', NULL, NULL, 'string', '3', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_admin_email_enquiry_message', '3', NULL, NULL, 'text', '10', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_admin_email_enquiry_subject', '3', NULL, NULL, 'string', '9', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_admin_email_payment_message', '3', NULL, NULL, 'text', '7', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_admin_email_payment_subject', '3', NULL, NULL, 'string', '6', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_allow_authorize', '2', 'Yes|No::No', 'Yes|No', 'enum', '11', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_allow_bank', '2', 'Yes|No::No', NULL, 'enum', '18', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_allow_cash', '2', 'Yes|No::Yes', 'Yes|No', 'enum', '16', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_allow_creditcard', '2', 'Yes|No::Yes', 'Yes|No', 'enum', '17', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_allow_paypal', '2', 'Yes|No::Yes', 'Yes|No', 'enum', '9', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_authorize_md5_hash', '2', NULL, NULL, 'string', '15', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_authorize_merchant_id', '2', NULL, NULL, 'string', '13', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_authorize_timezone', '2', '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', '14', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_authorize_transkey', '2', NULL, NULL, 'string', '12', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_bank_account', '2', NULL, NULL, 'text', '19', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_bf_include_address', '4', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', '7', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_bf_include_captcha', '4', '1|2|3::3', 'No|Yes|Yes (required)', 'enum', '14', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_bf_include_city', '4', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', '10', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_bf_include_company', '4', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', '6', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_bf_include_country', '4', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', '13', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_bf_include_email', '4', '1|2|3::3', 'No|Yes|Yes (required)', 'enum', '5', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_bf_include_fname', '4', '1|2|3::3', 'No|Yes|Yes (required)', 'enum', '2', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_bf_include_lname', '4', '1|2|3::3', 'No|Yes|Yes (required)', 'enum', '3', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_bf_include_notes', '4', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', '8', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_bf_include_phone', '4', '1|2|3::3', 'No|Yes|Yes (required)', 'enum', '4', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_bf_include_promo', '4', '1|2|3::2', 'No|Yes|Yes (required)', 'enum', '9', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_bf_include_state', '4', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', '11', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_bf_include_title', '4', '1|2|3::3', 'No|Yes|Yes (required)', 'enum', '1', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_bf_include_zip', '4', '1|2|3::1', 'No|Yes|Yes (required)', 'enum', '12', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_booking_earlier', '2', '2', NULL, 'int', '4', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_booking_length', '2', '180', NULL, 'int', '3', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_booking_price', '2', '50', NULL, 'float', '2', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_booking_status', '2', 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', '5', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_currency', '2', 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', '1', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_date_format', '1', 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', '2', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_email_cancel_message', '3', NULL, NULL, 'text', '13', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_email_cancel_subject', '3', NULL, NULL, 'string', '12', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_email_confirmation_message', '3', NULL, NULL, 'text', '4', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_email_confirmation_subject', '3', NULL, NULL, 'string', '3', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_email_enquiry_message', '3', NULL, NULL, 'text', '10', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_email_enquiry_subject', '3', NULL, NULL, 'string', '9', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_email_payment_message', '3', NULL, NULL, 'text', '7', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_email_payment_subject', '3', NULL, NULL, 'string', '6', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_enquiry', '5', NULL, NULL, 'text', '2', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_fields_index', '99', '174fe2e636ea7d7a6933b3604452e061', NULL, 'string', NULL, '0', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_multi_lang', '99', '1|0::1', NULL, 'enum', NULL, '0', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_payment_disable', '2', 'Yes|No::No', 'Yes|No', 'enum', '8', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_payment_status', '2', 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', '6', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_paypal_address', '2', 'paypal@domain.com', NULL, 'string', '10', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_plugin_pjAuthorize', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_plugin_pjBackup', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_plugin_pjCountry', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_plugin_pjInstaller', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_plugin_pjLocale', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_plugin_pjLog', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_plugin_pjOneAdmin', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_plugin_pjPaypal', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_plugin_pjSms', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_reminder_body', '6', NULL, NULL, 'text', '5', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_reminder_cron', '6', NULL, NULL, 'text', '2', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_reminder_email_before', '6', '2', NULL, 'int', '3', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_reminder_enable', '6', 'Yes|No::Yes', 'Yes|No', 'enum', '1', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_reminder_sms_hours', '6', '2', NULL, 'int', '6', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_reminder_sms_message', '6', NULL, NULL, 'text', '7', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_reminder_subject', '6', NULL, NULL, 'string', '4', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_send_email', '1', 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', '7', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_smtp_host', '1', NULL, NULL, 'string', '8', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_smtp_pass', '1', NULL, NULL, 'string', '9', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_smtp_port', '1', '25', NULL, 'int', '10', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_smtp_user', '1', NULL, NULL, 'string', '11', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_terms', '5', NULL, NULL, 'text', '1', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_thank_you_page', '2', 'http://www.phpjabbers.com', NULL, 'string', '7', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_theme', '1', 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme10', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', '13', '0', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_timezone', '1', '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', '5', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_time_format', '1', 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', '3', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2014_11_12_12_41_38.sql_0a7ddc6a8e5300a72379cc2997dc52f7', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2014_11_12_16_30_30.sql_5e4bf29533710f13e48a24a6883b5e9f', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2014_11_17_14_20_39.sql_b4f8183e5ea98068591fd024a1a500da', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2015_03_24_07_33_22.sql_971a6d3f178c37189856a74f146f3a30', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2015_03_24_08_48_40.sql_c1e3635fdf463c2c356056472cc0887f', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2015_03_24_09_45_59.sql_66b5ca5d4ec8652b43342f5788507c2e', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2015_04_06_14_45_32.sql_b34fde0260cb23a95c7dac3da3487cd7', '99', '2018-06-14 11:16:32', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2015_04_09_03_33_52.sql_f21b2912a3ed19fdabab97b4c881fd78', '99', '2018-06-14 11:16:32', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2015_08_21_10_04_22.sql_aad130926769b3a2ad7b71a87c82fbe3', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2015_09_16_03_21_43.sql_baa3e9c12dbc8b2c7f567c8d10ff1959', '99', '2018-06-14 11:16:32', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2015_09_16_03_42_45.sql_4d3aa0dcc692840141dba89bf9524d75', '99', '2018-06-14 11:16:32', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2015_11_17_09_42_31.sql_c74cbb6d624215bc364f9b56fecaf7f0', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2015_12_30_08_46_57.sql_b959095d1d9e99c9367a16fbdbaf2f03', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_01_04_09_08_31.sql_91dc5c18866fba9e242ec859d5ddf1df', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_01_11_00_00_00.sql_4924c01aa646fa51a7d3e59b00ba9972', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_02_05_15_10_22.sql_76ffea695760dd8b38d07b03fe7c653a', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_03_07_13_35_49.sql_2aaaf0459f60217a4c251e98350d02cf', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_03_08_15_21_41.sql_6fbd7f8059fb57aaeb5a6515c3f332bb', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_06_01_13_03_12.sql_6b1b7c5c4a04c472b7db1e72bca6fc26', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_07_08_14_41_22.sql_2396d1c53a302ff3f2f1464b87fa244f', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_08_23_07_54_31.sql_7a17f35960df3223475b575e104f1667', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_08_23_09_53_59.sql_5ea0b4b9c21bff736aaaefee74a102ac', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_10_06_06_31_40.sql_b427818e5bf01703e3abc5615132778d', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_10_07_02_23_14.sql_6ce8bd909d87005ea4a170490d12d8ed', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_10_07_04_56_18.sql_83162476feede4435148cf29eac937ac', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_10_07_05_01_58.sql_88fbaf42645bb7a8b6a7bd42d9fb347d', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_10_11_07_41_12.sql_b68eda6aee6b918a3df4dae8e93200b2', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_10_26_02_59_07.sql_80fd19375b6ae4ede3879420ea021c4b', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_11_03_10_00_17.sql_2f277a097969faa56edd29d4a4b148a8', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_11_04_03_24_05.sql_fe6469ff075e13b7a7da8ade1533643f', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2016_11_08_13_18_01.sql_58e92b324c90855cfdb0949afa6b33fd', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2017_03_13_13_13_13.sql_63dd62a2c89ea3357ffcfe90f4bee8a7', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2017_04_25_10_10_47.sql_da07f16f8731525b1be256fd875e8642', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_update_2017_06_05_11_09_51.sql_78a41d743d7316b9b87e5570184206eb', '99', '2018-06-14 11:16:33', NULL, 'string', NULL, '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_use_map', '99', '1|0::0', NULL, 'enum', NULL, '0', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'o_week_start', '1', '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', '6', '1', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'plugin_sms_api_key', '99', 'e5617b5922ebcef4f639f3926ca07b10', NULL, 'string', NULL, '0', 'string');
INSERT INTO `restaurantbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES('1', 'private_key', '99', 'QlxYfHog9GaPeMfMX5rsa8Kp8Np4qEu9/2fgBiirNmumI0f9/25QBQ6HmGifhTACzpYNqhAnCZoFz4/u1bWTuE1ebMFM2xfcz8PyDPCv3OrCHAE+b0jbGVDo2G3uCqJN031IN/mSi4a3LWrgUYk9qpDj+uHW5qNNeXVIeRgmnODuu4Riudg+q3u+ZIvir28EOA+jm34yMxa/t/oK/ef1wIjPEeClr3gQYdb40luXFwP823f2A/rnEswaX7SYS0Y2J3tiR6Hvq5NxLsyNcuZm4yAxUlB4dx4E16tt+fvbkZa8vkSfI9ySuZpnxn+Kg6PMimXaDr6Z0DrvWcrO6mTa/A==', NULL, 'string', NULL, '1', 'string');

DROP TABLE IF EXISTS `restaurantbooking_bookings_tables`;

CREATE TABLE `restaurantbooking_bookings_tables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `booking_table_id` (`booking_id`,`table_id`),
  KEY `booking_id` (`booking_id`),
  KEY `table_id` (`table_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `restaurantbooking_fields`;

CREATE TABLE `restaurantbooking_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=1753 DEFAULT CHARSET=utf8;

INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1', 'addLocale', 'backend', 'Add language', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('2', 'adminForgot', 'backend', 'Forgot password', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('3', 'adminLogin', 'backend', 'Admin Login', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('4', 'backend', 'backend', 'Backend titles', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('5', 'btnAdd', 'backend', 'Button Add', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('6', 'btnBack', 'backend', 'Button Back', 'script', '2018-06-24 10:29:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('7', 'btnBackup', 'backend', 'Button Backup', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('8', 'btnCancel', 'backend', 'Button Cancel', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('9', 'btnContinue', 'backend', 'Button Continue', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('10', 'btnDelete', 'backend', 'Button Delete', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('11', 'btnLogin', 'backend', 'Login', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('12', 'btnReset', 'backend', 'Reset', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('13', 'btnSave', 'backend', 'Save', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('14', 'btnSearch', 'backend', 'Search', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('15', 'btnSend', 'backend', 'Button Send', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('16', 'btnUpdate', 'backend', 'Update', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('17', 'created', 'backend', 'Created', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('18', 'email', 'backend', 'E-Mail', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('19', 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('20', 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('21', 'frontend', 'backend', 'Front-end titles', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('22', 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('23', 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('24', 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('25', 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('26', 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('27', 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('28', 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('29', 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('30', 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('31', 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('32', 'gridNext', 'backend', 'Grid / Next', 'script', '2018-06-24 10:29:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('33', 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('34', 'gridPrev', 'backend', 'Grid / Prev', 'script', '2018-06-24 10:29:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('35', 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('36', 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('37', 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('38', 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('39', 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('40', 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('41', 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('42', 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('43', 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('44', 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('45', 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('46', 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('47', 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('48', 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('49', 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('50', 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('51', 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('52', 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('53', 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('54', 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('55', 'lblAddUser', 'backend', 'Add user', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('56', 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('57', 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('58', 'lblChoose', 'backend', 'Choose', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('59', 'lblDays', 'backend', 'Days', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('60', 'lblDelete', 'backend', 'Delete', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('61', 'lblError', 'backend', 'Error', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('62', 'lblExport', 'backend', 'Export', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('63', 'lblForgot', 'backend', 'Forgot password', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('64', 'lblIp', 'backend', 'IP address', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('65', 'lblIsActive', 'backend', 'Is Active', 'script', '2018-06-24 10:29:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('66', 'lblName', 'backend', 'Name', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('67', 'lblNo', 'backend', 'No', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('68', 'lblOption', 'backend', 'Option', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('69', 'lblOptionList', 'backend', 'Option list', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('70', 'lblRole', 'backend', 'Role', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('71', 'lblStatus', 'backend', 'Status', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('72', 'lblType', 'backend', 'Type', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('73', 'lblUpdateUser', 'backend', 'Update user', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('74', 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('75', 'lblValue', 'backend', 'Value', 'script', '2018-06-24 10:55:23');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('76', 'lblYes', 'backend', 'Yes', 'script', '2018-06-24 10:25:41');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('77', 'lnkBack', 'backend', 'Link Back', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('78', 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('79', 'locales', 'backend', 'Languages', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('80', 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('81', 'locale_is_default', 'backend', 'Locale / Is default', 'script', '2018-06-24 10:29:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('82', 'locale_order', 'backend', 'Locale / Order', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('83', 'locale_title', 'backend', 'Locale / Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('84', 'menuBackup', 'backend', 'Menu Backup', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('85', 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('86', 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('87', 'menuLocales', 'backend', 'Menu Languages', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('88', 'menuLogout', 'backend', 'Menu Logout', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('89', 'menuOptions', 'backend', 'Menu Options', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('90', 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('91', 'menuProfile', 'backend', 'Menu Profile', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('92', 'menuUsers', 'backend', 'Menu Users', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('93', 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('94', 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('95', 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('96', 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', '2018-06-24 10:20:26');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('97', 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('98', 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('99', 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('100', 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('101', 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('102', 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('103', 'pass', 'backend', 'Password', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('125', 'revert_status', 'backend', 'Revert status', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('126', 'url', 'backend', 'URL', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('127', 'user', 'backend', 'Username', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('128', 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', '2018-06-24 10:29:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('129', 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('130', 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', '2018-06-24 10:18:48');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('131', 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', '2018-06-24 10:19:03');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('132', 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', '2018-06-24 10:19:14');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('133', 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', '2018-06-24 10:19:24');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('134', 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', '2018-06-24 10:19:36');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('135', 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('136', 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('137', 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('138', 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('139', 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('140', 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('141', 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('142', 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('143', 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', '2018-06-24 10:29:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('144', 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('145', 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', '2018-06-24 10:29:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('146', 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('147', 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('148', 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('149', 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', '2018-06-24 10:29:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('150', 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('151', 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('152', 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('153', 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('154', 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('155', 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', '2018-06-24 10:29:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('156', 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('159', 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('160', 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('161', 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('162', 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('163', 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('164', 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('165', 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('166', 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('167', 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('168', 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('169', 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('170', 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', '2018-06-24 10:29:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('171', 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('174', 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('175', 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('176', 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('177', 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('178', 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('179', 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('180', 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('181', 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('182', 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('183', 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('184', 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('185', 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('186', 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('187', 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('188', 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('189', 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('190', 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('191', 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('192', 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('193', 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('194', 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('195', 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('196', 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('197', 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('198', 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('199', 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('200', 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('201', 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('202', 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('203', 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('204', 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('205', 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('206', 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('207', 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('208', 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('209', 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('210', 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('211', 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('212', 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', '2018-06-24 10:25:41');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('213', 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('214', 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('215', 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', '2018-06-24 10:29:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('216', 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', '2018-06-24 10:29:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('217', 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('218', 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('219', 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('220', 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', '2018-06-24 10:29:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('221', 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', '2018-06-24 10:32:17');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('222', 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', '2018-06-24 10:32:17');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('223', 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('224', 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('225', 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('226', 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('227', 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('228', 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('229', 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('230', 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('231', 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('232', 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('233', 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('234', 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('235', 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('236', 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('237', 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('238', 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('239', 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('240', 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('241', 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('242', 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('243', 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('244', 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('245', 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('246', 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('247', 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('248', 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('249', 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('250', 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('251', '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('252', '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', '2018-06-24 10:25:41');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('253', 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('254', 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('255', 'lblAll', 'backend', 'Label / All', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('256', 'email_taken', 'backend', 'Label / email taken', 'script', '2018-06-24 10:32:17');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('308', 'menuRestaurant', 'backend', 'Menu / Restaurant', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('309', 'menuBooking', 'backend', 'Menu / Booking', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('310', 'menuVouchers', 'backend', 'Menu / Vouchers', 'script', '2018-06-25 07:57:02');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('311', 'menuInstall', 'backend', 'Menu / Install', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('312', 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('313', 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('314', 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('315', 'infoBookingsTitle', 'backend', 'Infobox / Bookings title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('316', 'infoBookingsBody', 'backend', 'Infobox / Bookings body', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('318', 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('319', 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('320', 'opt_o_booking_price', 'backend', 'Options / Deposit fee', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('321', 'opt_o_booking_price_text', 'backend', 'Options / Booking price text', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('322', 'opt_o_booking_length', 'backend', 'Options / Booking length', 'script', '2018-06-24 10:32:17');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('323', 'opt_o_booking_length_text', 'backend', 'Options / Booking length text', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('324', 'opt_o_booking_earlier', 'backend', 'Options / Book X hours earlier', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('325', 'opt_o_booking_earlier_text', 'backend', 'Options / Book X hours earlier text', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('326', 'opt_o_booking_status', 'backend', 'Options / Default booking status', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('327', 'opt_o_booking_status_text', 'backend', 'Options / Default booking status text', 'script', '2018-06-24 10:46:12');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('328', 'opt_o_payment_status', 'backend', 'Options / booking status after payment', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('329', 'opt_o_payment_status_text', 'backend', 'Options / booking status after payment', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('330', 'opt_o_thank_you_page', 'backend', 'Options / "Thank you" page location', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('331', 'opt_o_thank_you_page_text', 'backend', 'Options / "Thank you" page location', 'script', '2018-06-24 10:32:17');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('332', 'opt_o_payment_disable', 'backend', 'Options / Disable payments', 'script', '2018-06-24 10:25:41');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('333', 'opt_o_payment_disable_text', 'backend', 'Options / Disable payments text', 'script', '2018-06-24 10:25:41');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('334', 'opt_o_allow_paypal', 'backend', 'Options / Allow PayPal payments', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('335', 'opt_o_paypal_address', 'backend', 'Options / PayPal business email address', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('336', 'opt_o_allow_authorize', 'backend', 'Options / Allow payments with Authorize.net', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('337', 'opt_o_authorize_transkey', 'backend', 'Options / Authorize.net transaction key', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('338', 'opt_o_authorize_merchant_id', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('339', 'opt_o_allow_cash', 'backend', 'Options / Allow payments with cash', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('340', 'opt_o_allow_creditcard', 'backend', 'Options / Allow payments with Credit cards', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('341', 'opt_o_allow_bank', 'backend', 'Option / Allow bank account', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('342', 'opt_o_bank_account', 'backend', 'Options / bank account', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('343', 'menuBookingForm', 'backend', 'Menu / Booking form', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('344', 'menuConfirmation', 'backend', 'Menu / Confirmation', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('345', 'menuTerms', 'backend', 'Menu / Terms', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('346', 'menuReminder', 'backend', 'Menu / Reminder', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('347', 'infoConfirmationTitle', 'backend', 'Infobox / Confirmation title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('348', 'infoConfirmationDesc', 'backend', 'Infobox / Confirmation description', 'script', '2018-06-24 10:32:17');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('349', 'opt_o_email_address', 'backend', 'Options / Notification email address', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('350', 'opt_o_email_confirmation', 'backend', 'Options / Send confirmation email', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('351', 'opt_o_email_confirmation_text', 'backend', 'Options / Send confirmation email', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('352', 'opt_o_email_confirmation_subject', 'backend', 'Options / Confirmation subject', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('353', 'opt_o_email_confirmation_message_text', 'backend', 'Options / confirmation message', 'script', '2018-06-24 11:10:22');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('354', 'opt_o_email_confirmation_message', 'backend', 'Options / Confirmation message', 'script', '2018-06-24 11:05:19');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('355', 'opt_o_email_payment', 'backend', 'Optoins / Send payment confirmation email', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('356', 'opt_o_email_payment_text', 'backend', 'Optoins / Send payment confirmation email', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('357', 'opt_o_email_payment_message', 'backend', 'Options / Payment email message', 'script', '2018-06-24 11:05:45');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('358', 'opt_o_email_payment_message_text', 'backend', 'Options / payment message', 'script', '2018-06-24 11:10:22');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('359', 'opt_o_email_enquiry', 'backend', 'Options / Send enquiry email', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('360', 'opt_o_email_enquiry_text', 'backend', 'Options / Send enquiry email text', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('361', 'opt_o_email_enquiry_subject', 'backend', 'Options / Enquiry email subject', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('362', 'opt_o_email_enquiry_message', 'backend', 'Options / Enquiry email message', 'script', '2018-06-24 11:05:19');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('363', 'opt_o_email_enquiry_message_text', 'backend', 'Options / Enquiry email message', 'script', '2018-06-24 11:10:22');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('364', 'opt_o_email_payment_subject', 'backend', 'Options / Payment email subject', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('365', 'opt_o_email_cancel', 'backend', 'Optons / Send cancel email', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('366', 'opt_o_email_cancel_text', 'backend', 'Optons / Send cancel email text', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('367', 'opt_o_email_cancel_subject', 'backend', 'Options / Cancel email subject', 'script', '2018-06-24 11:07:02');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('368', 'opt_o_email_cancel_message', 'backend', 'Options / Cancel email message', 'script', '2018-06-24 11:04:31');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('369', 'opt_o_email_cancel_message_text', 'backend', 'Options / Cancel email message text', 'script', '2018-06-24 11:10:22');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('421', 'infoBookingFormTitle', 'backend', 'Infobox / Booking form title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('422', 'infoBookingFormDesc', 'backend', 'Infobox / Booking form descriptoin', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('423', 'opt_o_bf_include_title', 'backend', 'Options / Title included', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('424', 'opt_o_bf_include_text', 'backend', 'Options / include text', 'script', '2018-06-24 10:25:41');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('425', 'opt_o_bf_include_fname', 'backend', 'Options / First name', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('426', 'opt_o_bf_include_lname', 'backend', 'Options / Last name', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('427', 'opt_o_bf_include_phone', 'backend', 'Options / Phone', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('428', 'opt_o_bf_include_email', 'backend', 'Options / Email', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('429', 'opt_o_bf_include_company', 'backend', 'Options / Company', 'script', '2018-06-24 10:32:17');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('430', 'opt_o_bf_include_address', 'backend', 'Options / Address', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('431', 'opt_o_bf_include_notes', 'backend', 'Options / Notes', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('432', 'opt_o_bf_include_promo', 'backend', 'Options / Voucher', 'script', '2018-06-25 07:57:02');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('433', 'opt_o_bf_include_city', 'backend', 'Options / City', 'script', '2018-06-24 10:26:25');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('434', 'opt_o_bf_include_state', 'backend', 'Options / State', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('435', 'opt_o_bf_include_zip', 'backend', 'Options / Zip', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('436', 'opt_o_bf_include_country', 'backend', 'Options / Country', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('437', 'opt_o_bf_include_captcha', 'backend', 'Options / Captcha', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('438', 'infoTermsTitle', 'backend', 'Infobox / Terms title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('439', 'infoTermsDesc', 'backend', 'Infobox / Terms description', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('440', 'opt_o_terms', 'backend', 'Options / Terms and Conditions', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('441', 'opt_o_enquiry', 'backend', 'Options / Enquiry', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('442', 'infoReminderTitle', 'backend', 'Infobox / Reminder Options', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('443', 'infoReminderDesc', 'backend', 'Infobox / Reminder Options desc', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('444', 'opt_o_reminder_enable', 'backend', 'Options / Enable notifications', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('445', 'opt_o_reminder_email_before', 'backend', 'Optoins / Send email reminder', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('446', 'opt_o_reminder_subject', 'backend', 'Options / Email Reminder subject', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('447', 'opt_o_reminder_body', 'backend', 'Options / Email Reminder body', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('448', 'opt_o_reminder_body_text', 'backend', 'Options / Email Reminder body text', 'script', '2018-06-24 11:10:22');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('449', 'opt_o_reminder_sms_hours', 'backend', 'Optoins / Send SMS reminder', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('450', 'opt_o_reminder_sms_api', 'backend', 'Optoins / SMS api key', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('451', 'opt_o_reminder_sms_message', 'backend', 'Optoins / SMS message', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('452', 'opt_o_reminder_sms_message_text', 'backend', 'Options / SMS message text', 'script', '2018-06-24 11:10:22');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('453', 'opt_o_reminder_cron', 'backend', 'Options / Cron script', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('454', 'opt_o_reminder_cron_text', 'backend', 'Option / Cron text', 'script', '2018-06-24 10:32:17');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('455', 'lblHoursBefore', 'backend', 'Label / hours before', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('456', 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('457', 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('458', 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('459', 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('460', 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('461', 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('462', 'error_titles_ARRAY_AO06', 'arrays', 'error_titles_ARRAY_AO06', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('463', 'error_bodies_ARRAY_AO06', 'arrays', 'error_bodies_ARRAY_AO06', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('464', 'lblGetKey', 'backend', 'Lable / get key', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('555', 'lblVoucherCode', 'backend', 'Label / Voucher code', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('556', 'lblDiscount', 'backend', 'Label / Discount', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('558', 'lblValid', 'backend', 'Label / Valid', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('559', 'lblAddVoucher', 'backend', 'Label / Add voucher', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('560', 'infoVoucherListTitle', 'backend', 'Infobox / Voucher list title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('561', 'infoVoucherListDesc', 'backend', 'Infobox / Voucher list description', 'script', '2018-06-24 10:46:12');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('562', 'lblVoucherCodeExist', 'backend', 'Label / Existing voucher code', 'script', '2018-06-24 10:32:17');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('563', 'infoAddVoucherTitle', 'backend', 'Infobox / Add Voucher', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('564', 'infoAddVoucherDesc', 'backend', 'Infobox / Add Voucher description', 'script', '2018-06-24 10:32:17');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('565', 'voucher_types_ARRAY_amount', 'arrays', 'voucher_types_ARRAY_amount', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('566', 'voucher_types_ARRAY_percent', 'arrays', 'voucher_types_ARRAY_percent', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('567', 'voucher_valids_ARRAY_fixed', 'arrays', 'voucher_valids_ARRAY_fixed', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('568', 'voucher_valids_ARRAY_period', 'arrays', 'voucher_valids_ARRAY_period', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('569', 'voucher_valids_ARRAY_recurring', 'arrays', 'voucher_valids_ARRAY_recurring', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('570', 'lblDate', 'backend', 'Label / Date', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('571', 'lblTimeFrom', 'backend', 'Label / Time from', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('572', 'lblTimeTo', 'backend', 'Label / Time to', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('573', 'lblDateTimeFrom', 'backend', 'Label / From date time', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('574', 'lblDateTimeTo', 'backend', 'Label / To date/time', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('575', 'voucher_days_ARRAY_monday', 'arrays', 'voucher_days_ARRAY_monday', 'script', '2018-06-24 10:18:48');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('576', 'voucher_days_ARRAY_tuesday', 'arrays', 'voucher_days_ARRAY_tuesday', 'script', '2018-06-24 10:19:03');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('577', 'voucher_days_ARRAY_wednesday', 'arrays', 'voucher_days_ARRAY_wednesday', 'script', '2018-06-24 10:19:14');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('578', 'voucher_days_ARRAY_thursday', 'arrays', 'voucher_days_ARRAY_thursday', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('579', 'voucher_days_ARRAY_friday', 'arrays', 'voucher_days_ARRAY_friday', 'script', '2018-06-24 10:19:36');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('580', 'voucher_days_ARRAY_saturday', 'arrays', 'voucher_days_ARRAY_saturday', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('581', 'voucher_days_ARRAY_sunday', 'arrays', 'voucher_days_ARRAY_sunday', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('582', 'lblEvery', 'backend', 'Label / Every', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('583', 'error_titles_ARRAY_AV01', 'arrays', 'error_titles_ARRAY_AV01', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('584', 'error_bodies_ARRAY_AV01', 'arrays', 'error_bodies_ARRAY_AV01', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('585', 'error_titles_ARRAY_AV03', 'arrays', 'error_titles_ARRAY_AV03', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('586', 'error_bodies_ARRAY_AV03', 'arrays', 'error_bodies_ARRAY_AV03', 'script', '2018-06-24 10:32:17');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('587', 'error_titles_ARRAY_AV04', 'arrays', 'error_titles_ARRAY_AV04', 'script', '2018-06-24 10:36:05');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('588', 'error_bodies_ARRAY_AV04', 'arrays', 'error_bodies_ARRAY_AV04', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('589', 'error_titles_ARRAY_AV08', 'arrays', 'error_titles_ARRAY_AV08', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('590', 'error_bodies_ARRAY_AV08', 'arrays', 'error_bodies_ARRAY_AV08', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('591', 'lblUpdateVoucher', 'backend', 'Label / Update voucher', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('592', 'infoUpdateVoucherTitle', 'backend', 'Infobox / Update voucher', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('593', 'infoUpdateVoucherDesc', 'backend', 'Infobox / Update voucher desc', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('594', 'menuWorkingTime', 'backend', 'Menu / Working Time', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('595', 'menuSeatMap', 'backend', 'Menu / Seat Map', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('596', 'menuTables', 'backend', 'Menu / Tables', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('597', 'lblDefault', 'backend', 'Label / Default', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('598', 'lblCustom', 'backend', 'Label / Custom', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('599', 'lblDayOfWeek', 'backend', 'Label / Day of Week', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('600', 'lblStartTime', 'backend', 'Label / Start Time', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('601', 'lblEndTime', 'backend', 'Label / End Time', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('602', 'lblIsDayOff', 'backend', 'Label / Is Day off', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('603', 'error_titles_ARRAY_AT01', 'arrays', 'error_titles_ARRAY_AT01', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('604', 'error_bodies_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('605', 'error_titles_ARRAY_AT02', 'arrays', 'error_titles_ARRAY_AT02', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('606', 'error_bodies_ARRAY_AT02', 'arrays', 'error_bodies_ARRAY_AT02', 'script', '2018-06-24 10:36:05');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('697', 'lblMap', 'backend', 'Label / Map', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('698', 'lblOptions', 'backend', 'Label / Options', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('699', 'infoMapTitle', 'backend', 'Infobox / Seat Map', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('700', 'infoMapDesc', 'backend', 'Infobox / Seat Map desc', 'script', '2018-06-24 10:36:05');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('701', 'infoMapOptionsTitle', 'backend', 'Infobox / Hot spot size', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('702', 'infoMapOptionsDesc', 'backend', 'Infobox / Hot spot size desc', 'script', '2018-06-24 10:46:12');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('703', 'lblUseSeatMap', 'backend', 'Label / Use seat map', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('704', 'lblFile', 'backend', 'Label / File', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('705', 'lblDeleteMap', 'backend', 'Label / Delete map', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('706', 'lblDeleteMapConfirm', 'backend', 'Label / Delete map confirm', 'script', '2018-06-24 10:46:12');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('707', 'lblUpdateMapTitle', 'backend', 'Label / Update Map', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('708', 'lblUpdateMapDesc', 'backend', 'Label / Update map desc', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('709', 'lblCapacity', 'backend', 'Label / Capacity', 'script', '2018-06-24 10:36:05');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('710', 'lblMinimum', 'backend', 'Label / Minimum', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('711', 'error_titles_ARRAY_AM01', 'arrays', 'error_titles_ARRAY_AM01', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('712', 'error_bodies_ARRAY_AM01', 'arrays', 'error_bodies_ARRAY_AM01', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('713', 'infoUseMapDesc', 'backend', 'Infobox / User map desc', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('714', 'lblWidth', 'backend', 'Label / Width', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('715', 'lblHeight', 'backend', 'Label / Height', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('716', 'lblTableList', 'backend', 'Label / Table list', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('717', 'lblAddTable', 'backend', 'Label / Add table', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('718', 'infoAddTableTitle', 'backend', 'Infobox / Add new table', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('719', 'infoAddTableDesc', 'backend', 'Infobox / Add new table desc', 'script', '2018-06-24 10:46:12');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('720', 'lblTableNameExist', 'backend', 'Label / Table name used', 'script', '2018-06-24 10:36:05');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('721', 'error_titles_ARRAY_AT03', 'arrays', 'error_titles_ARRAY_AT03', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('722', 'error_bodies_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', '2018-06-24 10:36:05');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('723', 'error_titles_ARRAY_AT04', 'arrays', 'error_titles_ARRAY_AT04', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('724', 'error_bodies_ARRAY_AT04', 'arrays', 'error_bodies_ARRAY_AT04', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('725', 'error_titles_ARRAY_AT05', 'arrays', 'error_titles_ARRAY_AT05', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('726', 'error_bodies_ARRAY_AT05', 'arrays', 'error_bodies_ARRAY_AT05', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('727', 'error_titles_ARRAY_AT08', 'arrays', 'error_titles_ARRAY_AT08', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('728', 'error_bodies_ARRAY_AT08', 'arrays', 'error_bodies_ARRAY_AT08', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('729', 'lblUpdateTable', 'backend', 'Label / Update table', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('730', 'infoUpdateTableTitle', 'backend', 'Infobox / Update table title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('731', 'infoUpdateTableDesc', 'backend', 'Infobox / Update table desc', 'script', '2018-06-24 10:36:05');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('732', 'lblUpdate', 'backend', 'Label / Update', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('733', 'menuSchedule', 'backend', 'Menu / Schedule', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('734', 'menuBookingList', 'backend', 'Menu / Booking List', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('735', 'menuPrint', 'backend', 'Menu / Print', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('736', 'lblFilter', 'backend', 'Label / Filter', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('737', 'lblNoTable', 'backend', 'Label / No tables found', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('738', 'lblDateIsDayOff', 'backend', 'Label / Date is day off', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('739', 'booking_statuses_ARRAY_confirmed', 'arrays', 'booking_statuses_ARRAY_confirmed', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('740', 'booking_statuses_ARRAY_cancelled', 'arrays', 'booking_statuses_ARRAY_cancelled', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('741', 'booking_statuses_ARRAY_pending', 'arrays', 'booking_statuses_ARRAY_pending', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('742', 'booking_statuses_ARRAY_enquiry', 'arrays', 'booking_statuses_ARRAY_enquiry', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('743', 'lblFromDateTime', 'backend', 'Label / From date time', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('744', 'opt_o_datetime_format', 'backend', 'Options / Date/time format', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('745', 'lblDateFrom', 'backend', 'Label / Date from', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('746', 'lblDateTo', 'backend', 'Label / Date to', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('747', 'lblTable', 'backend', 'Label / Table', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('748', 'lblPhone', 'backend', 'Label / Phone', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('749', 'error_titles_ARRAY_AB08', 'arrays', 'error_titles_ARRAY_AB08', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('750', 'error_bodies_ARRAY_AB08', 'arrays', 'error_bodies_ARRAY_AB08', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('751', 'lblBookingDetails', 'backend', 'Label / Booking Details', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('752', 'lblClientDetails', 'backend', 'Label / Client Details', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('753', 'lblUpdateBooking', 'backend', 'Label / Update Booking', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('754', 'lblUniqueID', 'backend', 'Label / Unique ID', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('755', 'lblDepositPaid', 'backend', 'Label / Deposit paid', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('756', 'booking_is_paids_ARRAY_T', 'arrays', 'booking_is_paids_ARRAY_T', 'script', '2018-06-24 10:25:41');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('757', 'booking_is_paids_ARRAY_F', 'arrays', 'booking_is_paids_ARRAY_F', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('758', 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('759', 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('760', 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('761', 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('762', 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('763', 'lblPaymentMethod', 'backend', 'Label / Payment Method', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('764', 'lblCCType', 'backend', 'Label / CC type', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('765', 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('766', 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('767', 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('768', 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('769', 'lblCCNum', 'backend', 'Label / CC number', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('770', 'lblCCExp', 'backend', 'Label / CC expiration date', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('771', 'lblCCCode', 'backend', 'Label / CC security code', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('772', 'lblBookingTotal', 'backend', 'Label / Total', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('773', 'lblPeople', 'backend', 'Label / People', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('774', 'lblTableName', 'backend', 'Label / Table name', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('775', 'lblViewAvailability', 'backend', 'Label / View availability', 'script', '2018-06-24 10:36:05');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('776', 'lblBookingAvailability', 'backend', 'Label / Availability', 'script', '2018-06-24 10:36:24');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('777', 'name_titles_ARRAY_mr', 'arrays', 'name_titles_ARRAY_mr', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('778', 'name_titles_ARRAY_mrs', 'arrays', 'name_titles_ARRAY_mrs', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('779', 'name_titles_ARRAY_ms', 'arrays', 'name_titles_ARRAY_ms', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('780', 'name_titles_ARRAY_dr', 'arrays', 'name_titles_ARRAY_dr', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('781', 'name_titles_ARRAY_prof', 'arrays', 'name_titles_ARRAY_prof', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('782', 'name_titles_ARRAY_rev', 'arrays', 'name_titles_ARRAY_rev', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('783', 'name_titles_ARRAY_other', 'arrays', 'name_titles_ARRAY_other', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('784', 'lblBookingTitle', 'backend', 'Label / Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('785', 'lblBookingFname', 'backend', 'Label / First name', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('786', 'lblBookingLname', 'backend', 'Label / Last name', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('787', 'lblBookingPhone', 'backend', 'Label / Phone', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('788', 'lblBookingEmail', 'backend', 'Label / Email', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('789', 'lblBookingNotes', 'backend', 'Label / Notes', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('790', 'lblBookingCompany', 'backend', 'Label / Company name', 'script', '2018-06-24 10:36:24');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('791', 'lblBookingAddress', 'backend', 'Label / Address', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('792', 'lblBookingCity', 'backend', 'Label / City', 'script', '2018-06-24 10:26:25');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('793', 'lblBookingState', 'backend', 'Label / State', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('794', 'lblBookingZip', 'backend', 'Label / Zip', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('795', 'lblBookingCountry', 'backend', 'Label / Country', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('796', 'error_titles_ARRAY_AB05', 'arrays', 'error_titles_ARRAY_AB05', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('797', 'error_bodies_ARRAY_AB05', 'arrays', 'error_bodies_ARRAY_AB05', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('798', 'lblBookingPrint', 'backend', 'Label / Print Booking Details', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('799', 'lblBookingRemind', 'backend', 'Label / Re-send confirmation', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('800', 'lblBookingID', 'backend', 'Label / ID', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('801', 'lblBookingCreated', 'backend', 'Label / Created', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('802', 'lblBookingTxnID', 'backend', 'Label / Txn ID', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('803', 'lblBookingProcessedOn', 'backend', 'Label / Processed on', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('805', 'infoReminderEmailTitle', 'backend', 'Infobox / Reminder email title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('806', 'infoReminderEmailDesc', 'backend', 'Infobox / Reminder email desc', 'script', '2018-06-24 10:23:09');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('807', 'lblReminderTo', 'backend', 'Label / To', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('808', 'lblReminderSubject', 'backend', 'Label / Subject', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('809', 'lblReminderMessage', 'backend', 'Label / Message', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('810', 'error_titles_ARRAY_AB09', 'arrays', 'error_titles_ARRAY_AB09', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('811', 'error_bodies_ARRAY_AB09', 'arrays', 'error_bodies_ARRAY_AB09', 'script', '2018-06-24 10:36:52');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('812', 'error_titles_ARRAY_AB10', 'arrays', 'error_titles_ARRAY_AB10', 'script', '2018-06-24 10:36:52');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('813', 'error_bodies_ARRAY_AB10', 'arrays', 'error_bodies_ARRAY_AB10', 'script', '2018-06-24 10:36:52');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('814', 'lblClientName', 'backend', 'Label / Client name', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('815', 'lblPerson', 'backend', 'label / Person', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('816', 'lblNoBookings', 'backend', 'Label / No bookings', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('817', 'lblPrint', 'backend', 'Label / Print', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('818', 'lblInstallJs1_title', 'backend', 'Install / Install code', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('819', 'lblInstallJs1_body', 'backend', 'Install / Install code body', 'script', '2018-06-24 10:46:12');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('820', 'lblInstallConfig', 'backend', 'Label / Language options', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('821', 'lblInstallConfigLocale', 'backend', 'Label / Language', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('822', 'lblInstallConfigHide', 'backend', 'Label / Hide language selector ', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('823', 'lblInstallJs1_1', 'backend', 'Label / Step 1', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('824', 'front_label_select_date_time', 'frontend', 'Label / Select date time', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('825', 'front_label_date', 'frontend', 'Label / Date', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('826', 'front_label_time', 'frontend', 'Label / Time', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('827', 'front_label_people', 'frontend', 'Label / People', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('828', 'front_label_check_availability', 'frontend', 'Label / Check Availability', 'script', '2018-06-24 10:36:24');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('829', 'front_label_avail_title', 'frontend', 'Label / Available for', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('830', 'front_label_book', 'frontend', 'Book', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('831', 'front_label_send_enquiry', 'frontend', 'Label / Send Enquiry', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('832', 'front_no_available_table', 'frontend', 'Label / No table', 'script', '2018-06-24 10:23:09');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('833', 'front_label_selected_tables', 'frontend', 'Label / Selected table(s)', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('834', 'front_label_your_booking', 'frontend', 'Label / Your booking', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('835', 'front_label_booking_form', 'frontend', 'Label / Booking form', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('926', 'front_label_date_time', 'frontend', 'Label / Date and time', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('927', 'front_label_table_for', 'frontend', 'Label / Table for person', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('928', 'front_label_change', 'frontend', 'Label / change', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('929', 'front_label_title', 'frontend', 'Label / Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('930', 'front_label_fname', 'frontend', 'Label / First name', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('931', 'front_label_lname', 'frontend', 'Label / Last name', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('932', 'front_label_phone', 'frontend', 'Label / Phone', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('933', 'front_label_email', 'backend', 'Label / Email', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('934', 'front_label_company', 'frontend', 'Label / Company name', 'script', '2018-06-24 10:36:24');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('935', 'front_label_notes', 'frontend', 'Label / Notes', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('936', 'front_label_address', 'frontend', 'Label / Address', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('937', 'front_label_city', 'frontend', 'Label / City', 'script', '2018-06-24 10:26:25');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('938', 'front_label_state', 'frontend', 'Label / State', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('939', 'front_label_zip', 'frontend', 'Label / Zip', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('940', 'front_label_country', 'frontend', 'Label / Country', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('941', 'front_label_checkout', 'frontend', 'Label / Checkout', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('942', 'front_label_discount', 'frontend', 'Label / discount', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('943', 'front_label_deposit_note', 'frontend', 'Label / Deposit note', 'script', '2018-06-24 10:36:52');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('944', 'front_label_price', 'frontend', 'Label / Price', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('945', 'front_label_voucher', 'frontend', 'Label / Voucher', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('946', 'front_label_add_voucher', 'frontend', 'Label / Add Voucher', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('947', 'front_label_added_voucher', 'frontend', 'Label / Added voucher', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('948', 'front_label_remove_voucher', 'frontend', 'Label / Remove voucher', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('949', 'front_label_invalid_voucher', 'frontend', 'Label / Invalid voucher', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('950', 'front_label_payment_medthod', 'frontend', 'Label / Payment method', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('951', 'front_label_cc_type', 'frontend', 'Label / CC type', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('952', 'front_label_cc_num', 'frontend', 'Label / CC number', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('953', 'front_label_cc_exp', 'frontend', 'Label / CC expiration date', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('954', 'front_label_cc_code', 'frontend', 'Label / CC security code', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('955', 'front_label_captcha', 'frontend', 'Captcha', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1046', 'front_label_required_field', 'frontend', 'Label / This field is required.', 'script', '2018-06-24 10:36:52');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1047', 'front_label_invalid_email', 'frontend', 'Label / Email is not valid.', 'script', '2018-06-24 10:36:52');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1048', 'front_label_incorrect_captcha', 'frontend', 'Label / Captcha is not correct.', 'script', '2018-06-24 10:36:52');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1049', 'front_label_exp_month', 'frontend', 'Label / Expiration month is required.', 'script', '2018-06-24 10:37:31');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1050', 'front_label_exp_year', 'frontend', 'Label / Expiration year is required.', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1051', 'front_label_agree', 'frontend', 'Label / Agreements', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1052', 'front_label_terms_conditions', 'frontend', 'Label / Terms and Conditions', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1053', 'front_label_booking_summary', 'frontend', 'Label / Booking summary', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1054', 'front_label_confirm', 'frontend', 'Label / Confirm Booking', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1055', 'front_label_back', 'frontend', 'Label / Back', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1056', 'front_messages_ARRAY_4', 'arrays', 'front_messages_ARRAY_4', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1057', 'front_messages_ARRAY_1', 'arrays', 'front_messages_ARRAY_1', 'script', '2018-06-24 10:37:31');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1058', 'front_messages_ARRAY_2', 'arrays', 'front_messages_ARRAY_2', 'script', '2018-06-24 10:37:31');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1059', 'front_messages_ARRAY_3', 'arrays', 'front_messages_ARRAY_3', 'script', '2018-06-24 10:37:31');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1060', 'front_messages_ARRAY_5', 'arrays', 'front_messages_ARRAY_5', 'script', '2018-06-24 10:37:31');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1061', 'front_messages_ARRAY_0', 'arrays', 'front_messages_ARRAY_0', 'script', '2018-06-24 10:37:31');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1062', 'front_label_missing_params', 'frontend', 'Label / Missing params', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1063', 'front_label_restaurant_reservations', 'frontend', 'Label / Restaurant Reservations', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1064', 'front_label_cancel_note', 'frontend', 'Label / Cancel note', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1065', 'cancel_err_ARRAY_1', 'arrays', 'cancel_err_ARRAY_1', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1066', 'cancel_err_ARRAY_2', 'arrays', 'cancel_err_ARRAY_2', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1067', 'cancel_err_ARRAY_3', 'arrays', 'cancel_err_ARRAY_3', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1068', 'cancel_err_ARRAY_4', 'arrays', 'cancel_err_ARRAY_4', 'script', '2018-06-24 10:37:31');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1069', 'cancel_err_ARRAY_200', 'arrays', 'cancel_err_ARRAY_200', 'script', '2018-06-24 10:46:12');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1070', 'front_label_cancel_heading', 'frontend', 'Label / Cancel Heading', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1071', 'front_label_cancel_from', 'frontend', 'Label / Cancel from', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1072', 'front_label_cancel_people', 'frontend', 'Label / People', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1073', 'front_label_cancel_code', 'frontend', 'Label / Promo code', 'script', '2018-06-25 07:57:02');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1074', 'front_label_cancel_title', 'frontend', 'Label / Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1075', 'front_label_cancel_description', 'frontend', 'Label / Description', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1076', 'front_label_cancel_datetime', 'frontend', 'Label / Date/time', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1077', 'front_label_cancel_fname', 'frontend', 'Label / First name', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1078', 'front_label_cancel_lname', 'frontend', 'Label / Last name', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1079', 'front_label_cancel_email', 'frontend', 'Label / Email', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1080', 'front_label_cancel_phone', 'frontend', 'Label / Phone', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1081', 'front_label_cancel_company', 'frontend', 'Label / Company', 'script', '2018-06-24 10:38:08');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1082', 'front_label_cancel_country', 'frontend', 'Label / Country', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1083', 'front_label_cancel_city', 'frontend', 'Label / City', 'script', '2018-06-24 10:26:25');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1084', 'front_label_cancel_state', 'frontend', 'Label / State', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1085', 'front_label_cancel_zip', 'frontend', 'Label / Zip', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1086', 'front_label_cancel_address', 'frontend', 'Label / Address', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1087', 'front_label_cancel_payment', 'frontend', 'Label / Payment', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1088', 'front_label_cancel_total', 'frontend', 'Label / Total', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1089', 'front_label_cancel_table', 'frontend', 'Label / Table', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1090', 'front_label_cancel_confirm', 'frontend', 'Label / Table', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1091', 'front_label_cancel_personal', 'frontend', 'Label / Personal Details', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1182', 'front_label_cancel', 'frontend', 'Label / Cancel', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1183', 'front_label_intro_text', 'frontend', 'Label / Intro text', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1184', 'front_label_loading_tables', 'frontend', 'Label / loading tables', 'script', '2018-06-24 10:38:08');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1185', 'infoWTimeTitle', 'backend', 'Infobox / Working Time Settings', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1186', 'infoWTimeDesc', 'backend', 'Infobox / Working Time Desc', 'script', '2018-06-24 10:46:12');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1187', 'front_label_dayoff', 'frontend', 'Label / Day off', 'script', '2018-06-24 10:38:08');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1188', 'lblToday', 'backend', 'Label / Today', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1189', 'lblTomorrow', 'backend', 'Label / Tomorrow', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1190', 'front_messages_ARRAY_300', 'arrays', 'front_messages_ARRAY_300', 'script', '2018-06-24 10:38:08');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1191', 'front_messages_ARRAY_301', 'arrays', 'front_messages_ARRAY_301', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1192', 'front_messages_ARRAY_302', 'arrays', 'front_messages_ARRAY_302', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1193', 'front_messages_ARRAY_303', 'arrays', 'front_messages_ARRAY_303', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1194', 'opt_o_authorize_timezone', 'backend', 'Options / Authorize.net time zone', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1195', 'opt_o_authorize_md5_hash', 'backend', 'Options / Authorize.net MD5 hash', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1196', 'lblTableHour', 'backend', 'Label / Table / Hour', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1198', 'menuAddBooking', 'backend', 'Menu / Add Booking', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1199', 'lblBookingPrice', 'backend', 'Label / Price', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1202', 'error_titles_ARRAY_AB11', 'arrays', 'error_titles_ARRAY_AB11', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1203', 'error_bodies_ARRAY_AB11', 'arrays', 'error_bodies_ARRAY_AB11', 'script', '2018-06-24 10:38:08');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1204', 'error_titles_ARRAY_AB12', 'arrays', 'error_titles_ARRAY_AB12', 'script', '2018-06-24 10:46:12');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1206', 'front_button_cancel', 'frontend', 'Button / Cancel', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1297', 'menuGeneral', 'backend', 'Menu / General', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1388', 'menuBookings', 'backend', 'Menu / Reservations', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1389', 'lblOptionClient', 'backend', 'Label / Client', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1390', 'lblOptionAdministrator', 'backend', 'Label / Option Administrator', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1391', 'front_label_intro_text2', 'frontend', 'Label / Intro text 2', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1392', 'lblBack', 'backend', 'Lable / Back', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1393', 'front_label_start_over', 'frontend', 'Label / Error start over', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1394', 'lblDepositFee', 'backend', 'Label / Deposit fee', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1395', 'infoScheduleTitle', 'backend', 'Infobox / Schedule Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1396', 'infoScheduleDesc', 'backend', 'Infobox / Schedule Desc', 'script', '2018-06-24 10:46:12');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1397', 'infoAddBookingTitle', 'backend', 'Infobox / Add Booking Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1398', 'infoAddBookingDesc', 'backend', 'Infobox / Add booking Desc', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1399', 'infoUpdateBookingTitle', 'backend', 'Infobox / Update booking title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1400', 'infoUpdateBookingDesc', 'backend', 'Infobox / Update booking desc', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1401', 'infoBookingListTitle', 'backend', 'Infobox / Bookings list', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1402', 'infoBookingListDesc', 'backend', 'Infobox / Reservations list desc', 'script', '2018-06-24 10:46:12');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1494', 'infoConfirmation2Title', 'backend', 'Infobox / Confirmation Admin Title', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1495', 'infoConfirmation2Desc', 'backend', 'Infobox / Confirmation Admin Desc', 'script', '2018-06-24 10:46:12');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1498', 'lblMadeOn', 'backend', 'Label / Made on', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1499', 'lblIpAddress', 'backend', 'Label / IP address', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1500', 'front_cancel_reservation', 'frontend', 'Label / Cancel reservation', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1501', 'front_cron_completed', 'frontend', 'Label / CRON job completed.', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1502', 'lblPositiveNumber', 'backend', 'Label / Please enter positive number', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1503', 'lblValidateMinimum', 'backend', 'Label / Validate minimum', 'script', '2018-06-24 10:46:12');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1504', 'uuid_used', 'backend', 'Label / Unique ID was used.', 'script', '2018-06-24 10:49:54');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1505', 'lblValidateTime', 'backend', 'Label / Validate time', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1506', 'lblValidateDateTime', 'backend', 'Label / Validate date time', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1507', 'front_label_price_after', 'frontend', 'Label / Price after discount applied', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1508', 'lblFieldRequired', 'backend', 'Label / This field is required.', 'script', '2018-06-24 10:49:54');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1509', 'lblValidateVoucherDateTime', 'backend', 'Label / Validate date time', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1510', 'front_label_out_range_voucher', 'frontend', 'Label / Out of range voucher', 'script', '2018-06-24 10:49:54');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1511', 'lblReservationID', 'backend', 'Label / Reservation ID', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1512', 'plugin_locale_languages', 'backend', 'Locale plugin / Languages', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1513', 'plugin_locale_titles', 'backend', 'Locale plugin / Title', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1514', 'plugin_locale_index_title', 'backend', 'Locale plugin / Languages info title', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1515', 'plugin_locale_index_body', 'backend', 'Locale plugin / Languages info body', 'plugin', '2018-06-24 10:49:54');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1516', 'plugin_locale_titles_title', 'backend', 'Locale plugin / Titles info title', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1517', 'plugin_locale_titles_body', 'backend', 'Locale plugin / Titles info body', 'plugin', '2018-06-24 10:49:54');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1518', 'plugin_locale_lbl_title', 'backend', 'Locale plugin / Title', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1519', 'plugin_locale_lbl_flag', 'backend', 'Locale plugin / Flag', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1520', 'plugin_locale_lbl_is_default', 'backend', 'Locale plugin / Is default', 'plugin', '2018-06-24 10:49:54');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1521', 'plugin_locale_lbl_order', 'backend', 'Locale plugin / Order', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1522', 'plugin_locale_add_lang', 'backend', 'Locale plugin / Add Language', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1523', 'plugin_locale_lbl_field', 'backend', 'Locale plugin / Field', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1524', 'plugin_locale_lbl_value', 'backend', 'Locale plugin / Value', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1525', 'plugin_locale_type_backend', 'backend', 'Locale plugin / Back-end title', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1526', 'plugin_locale_type_frontend', 'backend', 'Locale plugin / Front-end title', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1527', 'plugin_locale_type_arrays', 'backend', 'Locale plugin / Special title', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1528', 'error_titles_ARRAY_PAL01', 'arrays', 'Locale plugin / Status title', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1529', 'error_bodies_ARRAY_PAL01', 'arrays', 'Locale plugin / Status body', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1530', 'plugin_locale_lbl_rows', 'backend', 'Locale plugin / Per page', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1531', 'error_titles_ARRAY_PAL02', 'arrays', 'Locale plugin / Status title', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1532', 'error_bodies_ARRAY_PAL02', 'arrays', 'Locale plugin / Status body', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1533', 'error_titles_ARRAY_PAL03', 'arrays', 'Locale plugin / Status title', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1534', 'error_bodies_ARRAY_PAL03', 'arrays', 'Locale plugin / Status body', 'plugin', '2018-06-24 10:49:54');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1535', 'error_titles_ARRAY_PAL04', 'arrays', 'Locale plugin / Status title', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1536', 'error_bodies_ARRAY_PAL04', 'arrays', 'Locale plugin / Status body', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1537', 'error_titles_ARRAY_PAL05', 'arrays', 'Locale plugin / Status title', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1538', 'error_bodies_ARRAY_PAL05', 'arrays', 'Locale plugin / Status body', 'plugin', '2018-06-24 10:49:54');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1539', 'plugin_locale_import_export', 'backend', 'Locale plugin / Import Export menu', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1540', 'plugin_locale_import', 'backend', 'Locale plugin / Import', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1541', 'plugin_locale_export', 'backend', 'Locale plugin / Export', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1542', 'plugin_locale_browse', 'backend', 'Locale plugin / Browse your computer', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1543', 'plugin_locale_ie_title', 'backend', 'Locale plugin / Import Export (title)', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1544', 'plugin_locale_ie_body', 'backend', 'Locale plugin / Import Export (body)', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1545', 'plugin_locale_lbl_id', 'backend', 'Label / ID:', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1546', 'plugin_locale_lbl_show_id', 'backend', 'Label / Show ID in all titles to easily locate them', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1547', 'plugin_locale_separator', 'backend', 'Locale plugin / Delimiter', 'plugin', '2014-07-16 14:02:18');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1548', 'plugin_locale_separators_ARRAY_comma', 'arrays', 'Locale plugin / Delimiter: comma', 'plugin', '2014-07-16 14:02:36');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1549', 'plugin_locale_separators_ARRAY_semicolon', 'arrays', 'Locale plugin / Delimiter: semicolon', 'plugin', '2014-07-16 14:02:52');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1550', 'plugin_locale_separators_ARRAY_tab', 'arrays', 'Locale plugin / Delimiter: tab', 'plugin', '2014-07-16 14:03:09');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1551', 'error_bodies_ARRAY_PAL20', 'arrays', 'error_bodies_ARRAY_PAL20', 'plugin', '2014-07-21 07:54:40');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1552', 'error_titles_ARRAY_PAL20', 'arrays', 'error_titles_ARRAY_PAL20', 'plugin', '2014-07-21 07:55:25');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1553', 'error_titles_ARRAY_PAL11', 'arrays', 'error_titles_ARRAY_PAL11', 'plugin', '2014-07-21 07:58:06');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1554', 'error_bodies_ARRAY_PAL11', 'arrays', 'error_bodies_ARRAY_PAL11', 'plugin', '2014-07-21 07:58:37');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1555', 'error_titles_ARRAY_PAL12', 'arrays', 'error_titles_ARRAY_PAL12', 'plugin', '2014-07-21 07:59:00');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1556', 'error_bodies_ARRAY_PAL12', 'arrays', 'error_bodies_ARRAY_PAL12', 'plugin', '2018-06-24 10:49:54');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1557', 'error_titles_ARRAY_PAL13', 'arrays', 'error_titles_ARRAY_PAL13', 'plugin', '2014-07-21 08:00:05');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1558', 'error_bodies_ARRAY_PAL13', 'arrays', 'error_bodies_ARRAY_PAL13', 'plugin', '2018-06-24 10:49:54');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1559', 'error_titles_ARRAY_PAL14', 'arrays', 'error_titles_ARRAY_PAL14', 'plugin', '2014-07-21 08:01:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1560', 'error_bodies_ARRAY_PAL14', 'arrays', 'error_bodies_ARRAY_PAL14', 'plugin', '2014-07-21 08:01:37');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1561', 'error_titles_ARRAY_PAL15', 'arrays', 'error_titles_ARRAY_PAL15', 'plugin', '2014-07-21 08:01:51');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1562', 'error_bodies_ARRAY_PAL15', 'arrays', 'error_bodies_ARRAY_PAL15', 'plugin', '2014-07-21 08:04:05');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1563', 'error_titles_ARRAY_PAL16', 'arrays', 'error_titles_ARRAY_PAL16', 'plugin', '2014-07-21 08:04:13');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1564', 'error_bodies_ARRAY_PAL16', 'arrays', 'error_bodies_ARRAY_PAL16', 'plugin', '2018-06-24 10:49:54');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1565', 'error_titles_ARRAY_PAL17', 'arrays', 'error_titles_ARRAY_PAL17', 'plugin', '2014-07-21 08:06:10');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1566', 'error_bodies_ARRAY_PAL17', 'arrays', 'error_bodies_ARRAY_PAL17', 'plugin', '2014-07-21 08:06:27');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1567', 'error_titles_ARRAY_PAL18', 'arrays', 'error_titles_ARRAY_PAL18', 'plugin', '2014-07-21 08:26:34');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1568', 'error_bodies_ARRAY_PAL18', 'arrays', 'error_bodies_ARRAY_PAL18', 'plugin', '2014-07-21 08:27:01');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1569', 'error_titles_ARRAY_PAL19', 'arrays', 'error_titles_ARRAY_PAL19', 'plugin', '2014-07-21 08:27:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1570', 'error_bodies_ARRAY_PAL19', 'arrays', 'error_bodies_ARRAY_PAL19', 'plugin', '2014-07-21 08:27:27');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1571', 'plugin_locale_showid_dialog_title', 'backend', 'Label / Show IDs', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1572', 'plugin_locale_showid_dialog_desc', 'backend', 'Label / Show IDs', 'plugin', '2018-06-24 10:54:00');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1573', 'plugin_locale_button_confirm', 'backend', 'Button / Confirm', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1574', 'plugin_locale_button_cancel', 'backend', 'Button / Cancel', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1575', 'plugin_locale_default', 'backend', 'Label / default', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1576', 'plugin_locale_lbl_dir', 'backend', 'Locale plugin / Text direction', 'plugin', '2016-02-05 10:14:28');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1577', 'plugin_locale_lbl_fend', 'backend', 'Locale plugin / Front-end title', 'plugin', '2016-02-05 10:17:06');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1578', 'plugin_locale_dir_ARRAY_ltr', 'arrays', 'Locale plugin / Left to Right', 'plugin', '2016-02-05 10:54:19');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1579', 'plugin_locale_dir_ARRAY_rtl', 'arrays', 'Locale plugin / Right to Left', 'plugin', '2016-02-05 10:54:34');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1580', 'plugin_locale_flag_reset_title', 'backend', 'Locale plugin / Reset flag', 'plugin', '2016-02-05 14:24:57');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1581', 'plugin_locale_flag_reset_content', 'backend', 'Locale plugin / Reset flag: confirmation', 'plugin', '2016-02-05 14:25:26');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1582', 'plugin_locale_btn_reset', 'backend', 'Locale plugin / Button: Reset', 'plugin', '2016-02-05 14:27:33');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1583', 'plugin_locale_tooltip_upload', 'backend', 'Locale plugin / Upload tooltip', 'plugin', '2016-02-05 14:32:44');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1584', 'plugin_locale_tooltip_reset', 'backend', 'Locale plugin / Reset tooltip', 'plugin', '2016-02-05 14:32:59');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1585', 'plugin_locale_lbl_language', 'backend', 'Locale plugin / Language', 'plugin', '2016-02-05 14:55:07');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1586', 'plugin_locale_btn_close', 'backend', 'Locale plugin / Button: Close', 'plugin', '2016-03-07 13:10:40');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1587', 'plugin_locale_flag_info_title', 'backend', 'Locale plugin / Info message', 'plugin', '2016-03-07 13:13:33');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1588', 'plugin_locale_error_line', 'backend', 'Label / Error found at line', 'plugin', '2018-06-24 10:51:43');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1589', 'plugin_locale_reset_search', 'backend', 'Locale plugin / Reset search', 'plugin', '2016-08-23 09:48:29');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1590', 'error_titles_ARRAY_PBU01', 'arrays', 'error_titles_ARRAY_PBU01', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1591', 'error_titles_ARRAY_PBU02', 'arrays', 'error_titles_ARRAY_PBU02', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1592', 'error_titles_ARRAY_PBU03', 'arrays', 'error_titles_ARRAY_PBU03', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1593', 'error_titles_ARRAY_PBU04', 'arrays', 'error_titles_ARRAY_PBU04', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1594', 'error_bodies_ARRAY_PBU01', 'arrays', 'error_bodies_ARRAY_PBU01', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1595', 'error_bodies_ARRAY_PBU02', 'arrays', 'error_bodies_ARRAY_PBU02', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1596', 'error_bodies_ARRAY_PBU03', 'arrays', 'error_bodies_ARRAY_PBU03', 'plugin', '2018-06-24 10:51:43');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1597', 'error_bodies_ARRAY_PBU04', 'arrays', 'error_bodies_ARRAY_PBU04', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1598', 'plugin_backup_menu_backup', 'backend', 'Backup plugin / Menu Backup', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1599', 'plugin_backup_database', 'backend', 'Backup plugin / Backup database', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1600', 'plugin_backup_files', 'backend', 'Backup plugin / Backup files', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1601', 'plugin_backup_btn_backup', 'backend', 'Backup plugin / Backup button', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1602', 'error_titles_ARRAY_PBU05', 'arrays', 'error_titles_ARRAY_PBU05', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1603', 'error_bodies_ARRAY_PBU05', 'arrays', 'error_bodies_ARRAY_PBU05', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1604', 'error_titles_ARRAY_PBU06', 'arrays', 'error_titles_ARRAY_PBU06', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1605', 'error_bodies_ARRAY_PBU06', 'arrays', 'error_bodies_ARRAY_PBU06', 'plugin', '2018-06-24 10:51:43');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1606', 'plugin_backup_datetime', 'backend', 'Label / Date/time', 'plugin', '2015-11-17 09:38:32');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1607', 'plugin_backup_type', 'backend', 'Label / Type', 'plugin', '2015-11-17 09:38:57');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1608', 'plugin_backup_file', 'backend', 'Label / File', 'plugin', '2015-11-17 09:39:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1609', 'plugin_backup_delete_confirmation', 'backend', 'Backup plugin / Delete confirmation', 'plugin', '2015-11-17 09:40:22');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1610', 'plugin_backup_delete_selected', 'backend', 'Backup plugin / Delete selected', 'plugin', '2015-11-17 09:41:00');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1611', 'plugin_backup_size', 'backend', 'Plugin / Size', 'script', '2016-01-04 08:58:41');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1612', 'plugin_backup_sizeXXXXXX', 'backend', 'Plugin / Size', 'script', '2016-01-04 08:58:41');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1613', 'plugin_log_menu_log', 'backend', 'Log plugin / Menu Log', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1614', 'plugin_log_menu_config', 'backend', 'Log plugin / Menu Config', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1615', 'plugin_log_btn_empty', 'backend', 'Log plugin / Empty button', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1616', 'error_titles_ARRAY_PLG01', 'arrays', 'error_titles_ARRAY_PLG01', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1617', 'error_bodies_ARRAY_PLG01', 'arrays', 'error_bodies_ARRAY_PLG01', 'plugin', '2018-06-24 10:51:43');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1618', 'plugin_one_admin_menu_index', 'backend', 'One Admin plugin / List', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1619', 'plugin_one_admin_btn_add', 'backend', 'One Admin plugin / Add button', 'plugin', '2018-06-24 10:51:43');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1620', 'error_titles_ARRAY_POA01', 'arrays', 'error_titles_ARRAY_POA01', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1621', 'error_bodies_ARRAY_POA01', 'arrays', 'error_bodies_ARRAY_POA01', 'plugin', '2018-06-24 10:51:43');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1622', 'plugin_paypal_dt', 'backend', 'Paypal plugin / Date & Time', 'plugin', '2014-07-18 14:21:44');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1623', 'plugin_paypal_mc_gross', 'backend', 'Paypal plugin / MC Gross', 'plugin', '2014-07-18 14:21:59');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1624', 'plugin_paypal_mc_currency', 'backend', 'Paypal plugin / MC Currency', 'plugin', '2014-07-18 14:22:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1625', 'plugin_paypal_payer_email', 'backend', 'Paypal plugin / Payer email', 'plugin', '2014-07-18 14:22:31');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1626', 'plugin_paypal_txn_type', 'backend', 'Paypal plugin / Txn type', 'plugin', '2014-07-18 14:22:49');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1627', 'plugin_paypal_txn_id', 'backend', 'Paypal plugin / Txn ID', 'plugin', '2014-07-18 14:22:58');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1628', 'plugin_paypal_subscr_id', 'backend', 'Paypal plugin / Subscription ID', 'plugin', '2014-07-18 14:23:13');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1629', 'plugin_paypal_foreign_id', 'backend', 'Paypal plugin / Foreign ID', 'plugin', '2014-07-18 14:23:25');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1630', 'plugin_paypal_btn_close', 'backend', 'Paypal plugin / Close', 'plugin', '2014-07-18 14:27:07');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1631', 'plugin_paypal_info_title', 'backend', 'Paypal plugin / Transaction details', 'plugin', '2014-07-18 14:30:48');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1632', 'plugin_paypal_btn_view', 'backend', 'Paypal plugin / View', 'plugin', '2014-07-18 14:37:18');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1633', 'plugin_paypal_menu_ipn', 'backend', 'Paypal plugin / IPN', 'plugin', '2014-07-18 14:53:47');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1634', 'plugin_country_name', 'backend', 'Country plugin / Country name', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1635', 'plugin_country_alpha_2', 'backend', 'Country plugin / Alpha 2', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1636', 'plugin_country_alpha_3', 'backend', 'Country plugin / Alpha 3', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1637', 'plugin_country_status', 'backend', 'Country plugin / Status', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1638', 'plugin_country_btn_add', 'backend', 'Country plugin / Button Add', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1639', 'plugin_country_statuses_ARRAY_T', 'arrays', 'Country plugin / Status (active)', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1640', 'plugin_country_statuses_ARRAY_F', 'arrays', 'Country plugin / Status (inactive)', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1641', 'plugin_country_btn_save', 'backend', 'Country plugin / Button Save', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1642', 'plugin_country_btn_cancel', 'backend', 'Country plugin / Button Cancel', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1643', 'plugin_country_menu_countries', 'backend', 'Country plugin / Menu Countries', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1644', 'error_titles_ARRAY_PCY01', 'arrays', 'error_titles_ARRAY_PCY01', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1645', 'error_titles_ARRAY_PCY03', 'arrays', 'error_titles_ARRAY_PCY03', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1646', 'error_titles_ARRAY_PCY04', 'arrays', 'error_titles_ARRAY_PCY04', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1647', 'error_titles_ARRAY_PCY08', 'arrays', 'error_titles_ARRAY_PCY08', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1648', 'error_titles_ARRAY_PCY10', 'arrays', 'error_titles_ARRAY_PCY10', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1649', 'error_titles_ARRAY_PCY11', 'arrays', 'error_titles_ARRAY_PCY11', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1650', 'error_titles_ARRAY_PCY12', 'arrays', 'error_titles_ARRAY_PCY12', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1651', 'error_bodies_ARRAY_PCY01', 'arrays', 'error_bodies_ARRAY_PCY01', 'plugin', '2018-06-24 10:51:43');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1652', 'error_bodies_ARRAY_PCY03', 'arrays', 'error_bodies_ARRAY_PCY03', 'plugin', '2018-06-24 10:51:43');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1653', 'error_bodies_ARRAY_PCY04', 'arrays', 'error_bodies_ARRAY_PCY04', 'plugin', '2018-06-24 10:53:04');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1654', 'error_bodies_ARRAY_PCY08', 'arrays', 'error_bodies_ARRAY_PCY08', 'plugin', '2018-06-24 10:53:04');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1655', 'error_bodies_ARRAY_PCY10', 'arrays', 'error_bodies_ARRAY_PCY10', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1656', 'error_bodies_ARRAY_PCY11', 'arrays', 'error_bodies_ARRAY_PCY11', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1657', 'error_bodies_ARRAY_PCY12', 'arrays', 'error_bodies_ARRAY_PCY12', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1658', 'plugin_country_delete_confirmation', 'backend', 'Country plugin / Delete confirmation', 'plugin', '2018-06-24 10:53:04');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1659', 'plugin_country_delete_selected', 'backend', 'Country plugin / Delete selected', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1660', 'plugin_country_btn_all', 'backend', 'Country plugin / Button All', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1661', 'plugin_country_btn_search', 'backend', 'Country plugin / Button Search', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1662', 'plugin_country_revert_status', 'backend', 'Plugin / Revert status', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1663', 'plugin_sms_menu_sms', 'backend', 'SMS plugin / Menu SMS', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1664', 'plugin_sms_config', 'backend', 'SMS plugin / SMS config', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1665', 'plugin_sms_number', 'backend', 'SMS plugin / Number', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1666', 'plugin_sms_text', 'backend', 'SMS plugin / Text', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1667', 'plugin_sms_status', 'backend', 'SMS plugin / Status', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1668', 'plugin_sms_created', 'backend', 'SMS plugin / Date & Time', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1669', 'plugin_sms_api', 'backend', 'SMS plugin / API Key', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1670', 'error_titles_ARRAY_PSS01', 'arrays', 'SMS plugin / Info title', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1671', 'error_bodies_ARRAY_PSS01', 'arrays', 'SMS plugin / Info body', 'plugin', '2018-06-24 10:53:04');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1672', 'error_titles_ARRAY_PSS02', 'arrays', 'SMS plugin / API key updates info title', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1673', 'error_bodies_ARRAY_PSS02', 'arrays', 'SMS plugin / API key updates info body', 'plugin', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1674', 'plugin_sms_reset_search', 'backend', 'SMS plugin / Reset search', 'plugin', '2016-08-23 07:22:36');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1675', 'front_messages_ARRAY_6', 'arrays', 'front_messages_ARRAY_6', 'script', '2018-06-24 10:53:04');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1676', 'lblValidateTable', 'backend', 'Label / The selected table was reserved.', 'script', '2014-11-12 16:30:07');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1677', 'short_days_ARRAY_0', 'arrays', 'short_days_ARRAY_0', 'script', '2015-03-24 07:22:20');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1678', 'short_days_ARRAY_1', 'arrays', 'short_days_ARRAY_1', 'script', '2015-03-24 07:22:49');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1679', 'short_days_ARRAY_2', 'arrays', 'short_days_ARRAY_2', 'script', '2015-03-24 07:23:29');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1680', 'short_days_ARRAY_3', 'arrays', 'short_days_ARRAY_3', 'script', '2015-03-24 07:23:56');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1681', 'short_days_ARRAY_4', 'arrays', 'short_days_ARRAY_4', 'script', '2015-03-24 07:24:20');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1682', 'short_days_ARRAY_5', 'arrays', 'short_days_ARRAY_5', 'script', '2015-03-24 07:24:47');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1683', 'short_days_ARRAY_6', 'arrays', 'short_days_ARRAY_6', 'script', '2015-03-24 07:25:11');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1684', 'lblMissingParameters', 'backend', 'Label / Missing parameters', 'script', '2015-03-24 09:45:48');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1685', 'front_hour', 'frontend', 'Label / Hour', 'script', '2015-08-21 08:25:35');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1686', 'front_minute', 'frontend', 'Label / Minute', 'script', '2015-08-21 08:35:37');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1687', 'lblSelectTable', 'backend', 'Label / Please select a table.', 'script', '2016-06-01 12:44:46');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1688', 'front_step_1', 'frontend', 'Step 1', 'script', '2016-10-06 07:16:41');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1689', 'front_step_2', 'frontend', 'Step 2', 'script', '2016-10-06 07:16:59');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1690', 'front_step_3', 'frontend', 'Step 3', 'script', '2016-10-07 02:22:40');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1691', 'front_step_4', 'frontend', 'Step 4', 'script', '2016-10-07 02:22:56');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1692', 'front_reservation_form', 'frontend', 'Label / Reservation form', 'script', '2016-10-07 02:30:24');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1693', 'front_fill_to_reserve', 'frontend', 'Label / fill the form to reserve a table', 'script', '2016-10-07 02:30:56');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1694', 'front_field_required', 'frontend', 'Label / This field is required.', 'script', '2018-06-24 10:53:04');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1695', 'front_email_validation', 'frontend', 'Label / Email address is invalid.', 'script', '2018-06-24 10:53:04');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1696', 'front_bank_account', 'frontend', 'Label / Bank account', 'script', '2016-10-07 04:27:44');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1697', 'front_thank_you', 'frontend', 'Label / Thank you for your reservation', 'script', '2016-10-07 04:32:20');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1698', 'infoPreviewTitle', 'backend', 'Infobox / Preview front end', 'script', '2016-06-23 09:49:54');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1699', 'infoPreviewDesc', 'backend', 'Infobox / Preview front end', 'script', '2018-06-24 10:16:52');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1700', 'lblChooseTheme', 'backend', 'Label / Choose theme', 'script', '2016-06-23 09:50:58');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1701', 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1702', 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1703', 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1704', 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1705', 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1706', 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1707', 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1708', 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1709', 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1710', 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL);
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1711', 'lblCurrentlyInUse', 'backend', 'Label / Currently in use', 'script', '2016-06-23 09:55:08');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1712', 'btnUseThisTheme', 'backend', 'Label / Use this theme', 'script', '2016-06-23 09:55:38');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1713', 'front_available_tables_for', 'frontend', 'Label / Available for', 'script', '2016-10-11 06:15:38');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1714', 'front_click_to_book', 'frontend', 'Label / click on an available table to book it', 'script', '2016-10-11 03:34:12');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1715', 'front_unavailable_tables_for', 'frontend', 'Label / Unavailable for', 'script', '2016-10-11 06:24:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1716', 'front_change_date_time', 'frontend', 'Label / Please, change date time', 'script', '2018-06-24 10:53:04');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1717', 'front_empty_step_2', 'frontend', 'Label / Step empty message 2', 'script', '2016-10-11 06:35:58');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1718', 'front_enquiry_details', 'frontend', 'Label / Enquiry details', 'script', '2016-10-11 06:37:15');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1719', 'front_enquiry_form', 'frontend', 'Label / Enquiry form', 'script', '2016-10-11 06:38:07');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1720', 'front_fill_to_make', 'frontend', 'Label / fill the form to make an enquiry', 'script', '2016-10-11 06:38:39');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1721', 'front_table', 'frontend', 'Label / Table', 'script', '2016-10-11 06:43:09');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1722', 'front_for_persons', 'frontend', 'Label / for person', 'script', '2016-10-11 06:43:30');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1723', 'btnAddReservation', 'backend', 'Button / + Add reservation', 'script', '2016-10-11 07:29:04');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1724', 'btnAddVoucher', 'backend', 'Button / + Add voucher', 'script', '2018-06-25 07:57:02');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1725', 'btnAddUser', 'backend', 'Button / + Add user', 'script', '2016-10-11 07:35:07');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1726', 'infoUsersListTitle', 'backend', 'Infobox / Users', 'script', '2016-10-11 07:37:27');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1727', 'infoUsersListDesc', 'backend', 'Infobox / Users', 'script', '2018-06-24 10:53:29');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1728', 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', '2016-10-11 07:39:40');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1729', 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', '2016-10-11 07:39:56');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1730', 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', '2016-10-11 07:40:17');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1731', 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', '2016-10-11 07:40:35');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1732', 'menuPreviewInstall', 'backend', 'Menu / Preview & Install', 'script', '2018-06-24 10:17:59');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1733', 'lblSendCancellationEmail', 'backend', 'Label / Send Cancellation Email', 'script', '2016-11-08 11:37:54');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1734', 'booking_cancellation_title', 'backend', 'Label / Send Cancellation Email', 'script', '2016-11-08 12:48:30');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1735', 'booking_subject', 'backend', 'Label / Email subject', 'script', '2016-11-08 12:57:11');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1736', 'booking_message', 'backend', 'Label / Email message', 'script', '2016-11-08 12:57:28');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1737', 'buttons_ARRAY_send', 'arrays', 'buttons_ARRAY_send', 'script', '2016-11-08 12:58:02');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1738', 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', '2016-11-08 12:58:31');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1739', 'booking_confirmation_title', 'backend', 'Label / Send Confirmation Email', 'script', '2016-11-08 13:13:28');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1740', 'front_price_after_discount', 'frontend', 'Label / Price after discount is applied', 'script', '2017-04-25 09:53:12');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1741', 'enum_arr_ARRAY_mail', 'arrays', 'enum_arr_ARRAY_mail', 'script', '2015-06-11 08:35:51');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1742', 'enum_arr_ARRAY_smtp', 'arrays', 'enum_arr_ARRAY_smtp', 'script', '2015-06-11 08:36:12');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1743', 'enum_arr_ARRAY_confirmed', 'arrays', 'enum_arr_ARRAY_confirmed', 'script', '2015-06-11 08:38:00');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1744', 'enum_arr_ARRAY_pending', 'arrays', 'enum_arr_ARRAY_pending', 'script', '2015-06-11 08:38:16');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1745', 'enum_arr_ARRAY_cancelled', 'arrays', 'enum_arr_ARRAY_cancelled', 'script', '2015-06-11 08:38:35');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1746', 'enum_arr_ARRAY_Yes', 'arrays', 'enum_arr_ARRAY_Yes', 'script', '2018-06-24 10:11:16');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1747', 'enum_arr_ARRAY_No', 'arrays', 'enum_arr_ARRAY_No', 'script', '2015-06-11 08:39:09');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1748', 'enum_arr_ARRAY_0', 'arrays', 'enum_arr_ARRAY_0', 'script', '2015-06-11 08:39:25');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1749', 'enum_arr_ARRAY_1', 'arrays', 'enum_arr_ARRAY_1', 'script', '2018-06-24 10:11:16');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1750', 'enum_arr_ARRAY_2', 'arrays', 'enum_arr_ARRAY_2', 'script', '2018-06-24 10:11:16');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1751', 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', '2017-06-05 11:02:10');
INSERT INTO `restaurantbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES('1752', 'buttons_ARRAY_save', 'arrays', 'buttons_ARRAY_save', 'script', '2017-06-05 11:02:36');

DROP TABLE IF EXISTS `restaurantbooking_tables`;

CREATE TABLE `restaurantbooking_tables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `width` smallint(5) unsigned DEFAULT NULL,
  `height` smallint(5) unsigned DEFAULT NULL,
  `top` smallint(5) unsigned DEFAULT NULL,
  `left` smallint(5) unsigned DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `seats` smallint(5) unsigned DEFAULT NULL,
  `minimum` smallint(5) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `restaurantbooking_dates`;

CREATE TABLE `restaurantbooking_dates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL DEFAULT '0000-00-00',
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `is_dayoff` enum('T','F') DEFAULT 'F',
  PRIMARY KEY (`id`),
  UNIQUE KEY `date` (`date`),
  KEY `is_dayoff` (`is_dayoff`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `restaurantbooking_roles`;

CREATE TABLE `restaurantbooking_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `restaurantbooking_roles` (`id`, `role`, `status`) VALUES('1', 'admin', 'T');
INSERT INTO `restaurantbooking_roles` (`id`, `role`, `status`) VALUES('2', 'editor', 'T');

DROP TABLE IF EXISTS `restaurantbooking_bookings`;

CREATE TABLE `restaurantbooking_bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` int(10) unsigned DEFAULT NULL,
  `dt` datetime DEFAULT NULL,
  `dt_to` datetime DEFAULT NULL,
  `people` smallint(5) unsigned DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `total` decimal(9,2) unsigned DEFAULT NULL,
  `payment_method` enum('paypal','authorize','creditcard','cash','bank') DEFAULT NULL,
  `is_paid` enum('T','F') DEFAULT 'F',
  `status` enum('confirmed','cancelled','pending','enquiry') DEFAULT 'pending',
  `txn_id` varchar(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `c_title` varchar(255) DEFAULT NULL,
  `c_fname` varchar(255) DEFAULT NULL,
  `c_lname` varchar(255) DEFAULT NULL,
  `c_phone` varchar(255) DEFAULT NULL,
  `c_email` varchar(255) DEFAULT NULL,
  `c_company` varchar(255) DEFAULT NULL,
  `c_notes` text,
  `c_address` varchar(255) DEFAULT NULL,
  `c_city` varchar(255) DEFAULT NULL,
  `c_state` varchar(255) DEFAULT NULL,
  `c_zip` varchar(255) DEFAULT NULL,
  `c_country` int(10) unsigned DEFAULT NULL,
  `cc_type` varchar(255) DEFAULT NULL,
  `cc_num` varchar(255) DEFAULT NULL,
  `cc_exp` varchar(255) DEFAULT NULL,
  `cc_code` varchar(255) DEFAULT NULL,
  `reminder_email` tinyint(1) unsigned DEFAULT '0',
  `reminder_sms` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `dt` (`dt`),
  KEY `dt_to` (`dt_to`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `restaurantbooking_plugin_country`;

CREATE TABLE `restaurantbooking_plugin_country` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `alpha_2` varchar(2) DEFAULT NULL,
  `alpha_3` varchar(3) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  UNIQUE KEY `alpha_2` (`alpha_2`),
  UNIQUE KEY `alpha_3` (`alpha_3`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=250 DEFAULT CHARSET=utf8;

INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('1', 'AF', 'AFG', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('2', 'AX', 'ALA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('3', 'AL', 'ALB', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('4', 'DZ', 'DZA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('5', 'AS', 'ASM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('6', 'AD', 'AND', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('7', 'AO', 'AGO', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('8', 'AI', 'AIA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('9', 'AQ', 'ATA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('10', 'AG', 'ATG', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('11', 'AR', 'ARG', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('12', 'AM', 'ARM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('13', 'AW', 'ABW', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('14', 'AU', 'AUS', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('15', 'AT', 'AUT', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('16', 'AZ', 'AZE', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('17', 'BS', 'BHS', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('18', 'BH', 'BHR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('19', 'BD', 'BGD', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('20', 'BB', 'BRB', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('21', 'BY', 'BLR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('22', 'BE', 'BEL', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('23', 'BZ', 'BLZ', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('24', 'BJ', 'BEN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('25', 'BM', 'BMU', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('26', 'BT', 'BTN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('27', 'BO', 'BOL', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('28', 'BQ', 'BES', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('29', 'BA', 'BIH', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('30', 'BW', 'BWA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('31', 'BV', 'BVT', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('32', 'BR', 'BRA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('33', 'IO', 'IOT', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('34', 'BN', 'BRN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('35', 'BG', 'BGR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('36', 'BF', 'BFA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('37', 'BI', 'BDI', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('38', 'KH', 'KHM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('39', 'CM', 'CMR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('40', 'CA', 'CAN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('41', 'CV', 'CPV', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('42', 'KY', 'CYM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('43', 'CF', 'CAF', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('44', 'TD', 'TCD', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('45', 'CL', 'CHL', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('46', 'CN', 'CHN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('47', 'CX', 'CXR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('48', 'CC', 'CCK', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('49', 'CO', 'COL', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('50', 'KM', 'COM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('51', 'CG', 'COG', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('52', 'CD', 'COD', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('53', 'CK', 'COK', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('54', 'CR', 'CRI', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('55', 'CI', 'CIV', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('56', 'HR', 'HRV', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('57', 'CU', 'CUB', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('58', 'CW', 'CUW', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('59', 'CY', 'CYP', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('60', 'CZ', 'CZE', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('61', 'DK', 'DNK', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('62', 'DJ', 'DJI', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('63', 'DM', 'DMA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('64', 'DO', 'DOM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('65', 'EC', 'ECU', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('66', 'EG', 'EGY', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('67', 'SV', 'SLV', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('68', 'GQ', 'GNQ', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('69', 'ER', 'ERI', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('70', 'EE', 'EST', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('71', 'ET', 'ETH', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('72', 'FK', 'FLK', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('73', 'FO', 'FRO', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('74', 'FJ', 'FJI', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('75', 'FI', 'FIN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('76', 'FR', 'FRA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('77', 'GF', 'GUF', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('78', 'PF', 'PYF', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('79', 'TF', 'ATF', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('80', 'GA', 'GAB', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('81', 'GM', 'GMB', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('82', 'GE', 'GEO', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('83', 'DE', 'DEU', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('84', 'GH', 'GHA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('85', 'GI', 'GIB', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('86', 'GR', 'GRC', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('87', 'GL', 'GRL', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('88', 'GD', 'GRD', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('89', 'GP', 'GLP', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('90', 'GU', 'GUM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('91', 'GT', 'GTM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('92', 'GG', 'GGY', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('93', 'GN', 'GIN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('94', 'GW', 'GNB', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('95', 'GY', 'GUY', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('96', 'HT', 'HTI', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('97', 'HM', 'HMD', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('98', 'VA', 'VAT', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('99', 'HN', 'HND', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('100', 'HK', 'HKG', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('101', 'HU', 'HUN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('102', 'IS', 'ISL', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('103', 'IN', 'IND', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('104', 'ID', 'IDN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('105', 'IR', 'IRN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('106', 'IQ', 'IRQ', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('107', 'IE', 'IRL', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('108', 'IM', 'IMN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('109', 'IL', 'ISR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('110', 'IT', 'ITA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('111', 'JM', 'JAM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('112', 'JP', 'JPN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('113', 'JE', 'JEY', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('114', 'JO', 'JOR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('115', 'KZ', 'KAZ', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('116', 'KE', 'KEN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('117', 'KI', 'KIR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('118', 'KP', 'PRK', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('119', 'KR', 'KOR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('120', 'KW', 'KWT', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('121', 'KG', 'KGZ', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('122', 'LA', 'LAO', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('123', 'LV', 'LVA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('124', 'LB', 'LBN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('125', 'LS', 'LSO', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('126', 'LR', 'LBR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('127', 'LY', 'LBY', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('128', 'LI', 'LIE', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('129', 'LT', 'LTU', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('130', 'LU', 'LUX', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('131', 'MO', 'MAC', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('132', 'MK', 'MKD', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('133', 'MG', 'MDG', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('134', 'MW', 'MWI', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('135', 'MY', 'MYS', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('136', 'MV', 'MDV', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('137', 'ML', 'MLI', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('138', 'MT', 'MLT', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('139', 'MH', 'MHL', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('140', 'MQ', 'MTQ', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('141', 'MR', 'MRT', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('142', 'MU', 'MUS', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('143', 'YT', 'MYT', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('144', 'MX', 'MEX', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('145', 'FM', 'FSM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('146', 'MD', 'MDA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('147', 'MC', 'MCO', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('148', 'MN', 'MNG', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('149', 'ME', 'MNE', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('150', 'MS', 'MSR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('151', 'MA', 'MAR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('152', 'MZ', 'MOZ', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('153', 'MM', 'MMR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('154', 'NA', 'NAM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('155', 'NR', 'NRU', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('156', 'NP', 'NPL', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('157', 'NL', 'NLD', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('158', 'NC', 'NCL', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('159', 'NZ', 'NZL', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('160', 'NI', 'NIC', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('161', 'NE', 'NER', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('162', 'NG', 'NGA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('163', 'NU', 'NIU', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('164', 'NF', 'NFK', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('165', 'MP', 'MNP', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('166', 'NO', 'NOR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('167', 'OM', 'OMN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('168', 'PK', 'PAK', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('169', 'PW', 'PLW', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('170', 'PS', 'PSE', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('171', 'PA', 'PAN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('172', 'PG', 'PNG', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('173', 'PY', 'PRY', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('174', 'PE', 'PER', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('175', 'PH', 'PHL', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('176', 'PN', 'PCN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('177', 'PL', 'POL', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('178', 'PT', 'PRT', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('179', 'PR', 'PRI', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('180', 'QA', 'QAT', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('181', 'RE', 'REU', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('182', 'RO', 'ROU', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('183', 'RU', 'RUS', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('184', 'RW', 'RWA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('185', 'BL', 'BLM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('186', 'SH', 'SHN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('187', 'KN', 'KNA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('188', 'LC', 'LCA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('189', 'MF', 'MAF', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('190', 'PM', 'SPM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('191', 'VC', 'VCT', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('192', 'WS', 'WSM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('193', 'SM', 'SMR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('194', 'ST', 'STP', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('195', 'SA', 'SAU', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('196', 'SN', 'SEN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('197', 'RS', 'SRB', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('198', 'SC', 'SYC', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('199', 'SL', 'SLE', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('200', 'SG', 'SGP', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('201', 'SX', 'SXM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('202', 'SK', 'SVK', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('203', 'SI', 'SVN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('204', 'SB', 'SLB', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('205', 'SO', 'SOM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('206', 'ZA', 'ZAF', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('207', 'GS', 'SGS', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('208', 'SS', 'SSD', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('209', 'ES', 'ESP', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('210', 'LK', 'LKA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('211', 'SD', 'SDN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('212', 'SR', 'SUR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('213', 'SJ', 'SJM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('214', 'SZ', 'SWZ', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('215', 'SE', 'SWE', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('216', 'CH', 'CHE', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('217', 'SY', 'SYR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('218', 'TW', 'TWN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('219', 'TJ', 'TJK', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('220', 'TZ', 'TZA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('221', 'TH', 'THA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('222', 'TL', 'TLS', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('223', 'TG', 'TGO', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('224', 'TK', 'TKL', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('225', 'TO', 'TON', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('226', 'TT', 'TTO', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('227', 'TN', 'TUN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('228', 'TR', 'TUR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('229', 'TM', 'TKM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('230', 'TC', 'TCA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('231', 'TV', 'TUV', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('232', 'UG', 'UGA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('233', 'UA', 'UKR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('234', 'AE', 'ARE', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('235', 'GB', 'GBR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('236', 'US', 'USA', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('237', 'UM', 'UMI', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('238', 'UY', 'URY', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('239', 'UZ', 'UZB', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('240', 'VU', 'VUT', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('241', 'VE', 'VEN', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('242', 'VN', 'VNM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('243', 'VG', 'VGB', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('244', 'VI', 'VIR', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('245', 'WF', 'WLF', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('246', 'EH', 'ESH', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('247', 'YE', 'YEM', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('248', 'ZM', 'ZMB', 'T');
INSERT INTO `restaurantbooking_plugin_country` (`id`, `alpha_2`, `alpha_3`, `status`) VALUES('249', 'ZW', 'ZWE', 'T');

DROP TABLE IF EXISTS `restaurantbooking_plugin_sms`;

CREATE TABLE `restaurantbooking_plugin_sms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `number` varchar(255) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `restaurantbooking_plugin_locale_languages`;

CREATE TABLE `restaurantbooking_plugin_locale_languages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `iso` varchar(20) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `region` varchar(255) DEFAULT NULL,
  `native` varchar(255) DEFAULT NULL,
  `dir` enum('ltr','rtl') DEFAULT 'ltr',
  `country_abbr` varchar(3) DEFAULT NULL,
  `language_abbr` varchar(3) DEFAULT NULL,
  `file` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `iso` (`iso`)
) ENGINE=InnoDB AUTO_INCREMENT=260 DEFAULT CHARSET=utf8;

INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('1', 'af-ZA', 'Afrikaans', 'South Africa', 'Afrikaans (Suid Afrika)', 'ltr', 'ZAF', 'AFK', 'za.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('2', 'sq-AL', 'Albanian', 'Albania', 'shqipe (Shqipëria)', 'ltr', 'ALB', 'SQI', 'al.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('3', 'gsw-FR', 'Alsatian', 'France', 'Elsässisch (Frànkrisch)', 'ltr', 'FRA', 'GSW', 'fr.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('4', 'am-ET', 'Amharic', 'Ethiopia', 'አማርኛ (ኢትዮጵያ)', 'ltr', 'ETH', 'AMH', 'et.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('5', 'ar', 'Arabic‎', NULL, 'العربية‏', 'rtl', 'SAU', 'ARA', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('6', 'ar-DZ', 'Arabic', 'Algeria', 'العربية (الجزائر)‏', 'rtl', 'DZA', 'ARG', 'dz.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('7', 'ar-BH', 'Arabic', 'Bahrain', 'العربية (البحرين)‏', 'rtl', 'BHR', 'ARH', 'bh.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('8', 'ar-EG', 'Arabic', 'Egypt', 'العربية (مصر)‏', 'rtl', 'EGY', 'ARE', 'eg.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('9', 'ar-IQ', 'Arabic', 'Iraq', 'العربية (العراق)‏', 'rtl', 'IRQ', 'ARI', 'iq.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('10', 'ar-JO', 'Arabic', 'Jordan', 'العربية (الأردن)‏', 'rtl', 'JOR', 'ARJ', 'jo.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('11', 'ar-KW', 'Arabic', 'Kuwait', 'العربية (الكويت)‏', 'rtl', 'KWT', 'ARK', 'kw.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('12', 'ar-LB', 'Arabic', 'Lebanon', 'العربية (لبنان)‏', 'rtl', 'LBN', 'ARB', 'lb.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('13', 'ar-LY', 'Arabic', 'Libya', 'العربية (ليبيا)‏', 'rtl', 'LBY', 'ARL', 'ly.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('14', 'ar-MA', 'Arabic', 'Morocco', 'العربية (المملكة المغربية)‏', 'rtl', 'MAR', 'ARM', 'ma.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('15', 'ar-OM', 'Arabic', 'Oman', 'العربية (عمان)‏', 'rtl', 'OMN', 'ARO', 'om.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('16', 'ar-QA', 'Arabic', 'Qatar', 'العربية (قطر)‏', 'rtl', 'QAT', 'ARQ', 'qa.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('17', 'ar-SA', 'Arabic', 'Saudi Arabia', 'العربية (المملكة العربية السعودية)‏', 'rtl', 'SAU', 'ARA', 'sa.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('18', 'ar-SY', 'Arabic', 'Syria', 'العربية (سوريا)‏', 'rtl', 'SYR', 'ARS', 'sy.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('19', 'ar-TN', 'Arabic', 'Tunisia', 'العربية (تونس)‏', 'rtl', 'TUN', 'ART', 'tn.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('20', 'ar-AE', 'Arabic', 'U.A.E.', 'العربية (الإمارات العربية المتحدة)‏', 'rtl', 'ARE', 'ARU', 'ae.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('21', 'ar-YE', 'Arabic', 'Yemen', 'العربية (اليمن)‏', 'rtl', 'YEM', 'ARY', 'ye.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('22', 'hy-AM', 'Armenian', 'Armenia', 'Հայերեն (Հայաստան)', 'ltr', 'ARM', 'HYE', 'am.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('23', 'as-IN', 'Assamese', 'India', 'অসমীয়া (ভাৰত)', 'ltr', 'IND', 'ASM', 'in.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('24', 'az', 'Azeri', NULL, 'Azərbaycan­ılı', 'rtl', 'AZE', 'AZE', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('25', 'az-Cyrl', 'Azeri', 'Cyrillic', 'Азәрбајҹан дили', 'rtl', 'AZE', 'AZC', 'az.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('26', 'az-Cyrl-AZ', 'Azeri', 'Cyrillic, Azerbaijan', 'Азәрбајҹан (Азәрбајҹан)', 'rtl', 'AZE', 'AZC', 'az.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('27', 'az-Latn', 'Azeri', 'Latin', 'Azərbaycan­ılı', 'rtl', 'AZE', 'AZE', 'az.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('28', 'az-Latn-AZ', 'Azeri', 'Latin, Azerbaijan', 'Azərbaycan­ılı (Azərbaycan)', 'rtl', 'AZE', 'AZE', 'az.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('29', 'ba-RU', 'Bashkir', 'Russia', 'Башҡорт (Россия)', 'ltr', 'RUS', 'BAS', 'ru.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('30', 'eu-ES', 'Basque', 'Basque', 'euskara (euskara)', 'ltr', 'ESP', 'EUQ', 'es.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('31', 'be-BY', 'Belarusian', 'Belarus', 'Беларускі (Беларусь)', 'ltr', 'BLR', 'BEL', 'by.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('32', 'bn', 'Bengali', NULL, 'বাংলা', 'ltr', 'IND', 'BNG', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('33', 'bn-BD', 'Bengali', 'Bangladesh', 'বাংলা (বাংলাদেশ)', 'ltr', 'BGD', 'BNB', 'bd.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('34', 'bn-IN', 'Bengali', 'India', 'বাংলা (ভারত)', 'ltr', 'IND', 'BNG', 'in.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('35', 'bs', 'Bosnian', NULL, 'bosanski', 'ltr', 'BIH', 'BSB', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('36', 'bs-Cyrl', 'Bosnian', 'Cyrillic', 'босански (Ћирилица)', 'ltr', 'BIH', 'BSC', 'ba.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('37', 'bs-Cyrl-BA', 'Bosnian', 'Cyrillic, Bosnia and Herzegovina', 'босански (Босна и Херцеговина)', 'ltr', 'BIH', 'BSC', 'ba.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('38', 'bs-Latn', 'Bosnian', 'Latin', 'bosanski (Latinica)', 'ltr', 'BIH', 'BSB', 'ba.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('39', 'bs-Latn-BA', 'Bosnian', 'Latin, Bosnia and Herzegovina', 'bosanski (Bosna i Hercegovina)', 'ltr', 'BIH', 'BSB', 'ba.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('40', 'br-FR', 'Breton', 'France', 'brezhoneg (Frañs)', 'ltr', 'FRA', 'BRE', 'fr.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('41', 'bg-BG', 'Bulgarian', 'Bulgaria', 'български (България)', 'ltr', 'BGR', 'BGR', 'bg.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('42', 'ca-ES', 'Catalan', 'Catalan', 'català (català)', 'ltr', 'ESP', 'CAT', 'es.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('43', 'zh', 'Chinese', NULL, '中文', 'ltr', 'CHN', 'CHS', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('44', 'zh-Hans', 'Chinese', 'Simplified', '中文(简体)', 'ltr', 'CHN', 'CHS', 'cn.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('45', 'zh-CN', 'Chinese', 'Simplified, PRC', '中文(中华人民共和国)', 'ltr', 'CHN', 'CHS', 'cn.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('46', 'zh-SG', 'Chinese', 'Simplified, Singapore', '中文(新加坡)', 'ltr', 'SGP', 'ZHI', 'sg.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('47', 'zh-Hant', 'Chinese', 'Traditional', '中文(繁體)', 'ltr', 'HKG', 'ZHH', 'hk.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('48', 'zh-HK', 'Chinese', 'Traditional, Hong Kong S.A.R.', '中文(香港特別行政區)', 'ltr', 'HKG', 'ZHH', 'hk.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('49', 'zh-MO', 'Chinese', 'Traditional, Macao S.A.R.', '中文(澳門特別行政區)', 'ltr', 'MCO', 'ZHM', 'mc.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('50', 'zh-TW', 'Chinese', 'Traditional, Taiwan', '中文(台灣)', 'ltr', 'TWN', 'CHT', 'tw.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('51', 'co-FR', 'Corsican', 'France', 'Corsu (France)', 'ltr', 'FRA', 'COS', 'fr.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('52', 'hr', 'Croatian', NULL, 'hrvatski', 'ltr', 'HRV', 'HRV', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('53', 'hr-HR', 'Croatian', 'Croatia', 'hrvatski (Hrvatska)', 'ltr', 'HRV', 'HRV', 'hr.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('54', 'hr-BA', 'Croatian', 'Latin, Bosnia and Herzegovina', 'hrvatski (Bosna i Hercegovina)', 'ltr', 'BIH', 'HRB', 'ba.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('55', 'cs-CZ', 'Czech', 'Czech Republic', 'čeština (Česká republika)', 'ltr', 'CZE', 'CSY', 'cz.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('56', 'da-DK', 'Danish', 'Denmark', 'dansk (Danmark)', 'ltr', 'DNK', 'DAN', 'dk.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('57', 'prs-AF', 'Dari', 'Afghanistan', 'درى (افغانستان)‏', 'ltr', 'AFG', 'PRS', 'af.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('58', 'dv-MV', 'Divehi', 'Maldives', 'ދިވެހިބަސް (ދިވެހި ރާއްޖެ)‏', 'rtl', 'MDV', 'DIV', 'mv.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('59', 'nl', 'Dutch', NULL, 'Nederlands', 'ltr', 'NLD', 'NLD', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('60', 'nl-BE', 'Dutch', 'Belgium', 'Nederlands (België)', 'ltr', 'BEL', 'NLB', 'be.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('61', 'nl-NL', 'Dutch', 'Netherlands', 'Nederlands (Nederland)', 'ltr', 'NLD', 'NLD', 'nl.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('62', 'en', 'English', NULL, 'English', 'ltr', 'USA', 'ENU', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('63', 'en-AU', 'English', 'Australia', 'English (Australia)', 'ltr', 'AUS', 'ENA', 'au.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('64', 'en-BZ', 'English', 'Belize', 'English (Belize)', 'ltr', 'BLZ', 'ENL', 'bz.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('65', 'en-CA', 'English', 'Canada', 'English (Canada)', 'ltr', 'CAN', 'ENC', 'ca.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('66', 'en-029', 'English', 'Caribbean', 'English (Caribbean)', 'ltr', 'CAR', 'ENB', 'en.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('67', 'en-IN', 'English', 'India', 'English (India)', 'ltr', 'IND', 'ENN', 'in.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('68', 'en-IE', 'English', 'Ireland', 'English (Ireland)', 'ltr', 'IRL', 'ENI', 'ie.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('69', 'en-JM', 'English', 'Jamaica', 'English (Jamaica)', 'ltr', 'JAM', 'ENJ', 'jm.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('70', 'en-MY', 'English', 'Malaysia', 'English (Malaysia)', 'ltr', 'MYS', 'ENM', 'my.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('71', 'en-NZ', 'English', 'New Zealand', 'English (New Zealand)', 'ltr', 'NZL', 'ENZ', 'nz.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('72', 'en-PH', 'English', 'Republic of the Philippines', 'English (Philippines)', 'ltr', 'PHL', 'ENP', 'ph.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('73', 'en-SG', 'English', 'Singapore', 'English (Singapore)', 'ltr', 'SGP', 'ENE', 'sg.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('74', 'en-ZA', 'English', 'South Africa', 'English (South Africa)', 'ltr', 'ZAF', 'ENS', 'za.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('75', 'en-TT', 'English', 'Trinidad and Tobago', 'English (Trinidad y Tobago)', 'ltr', 'TTO', 'ENT', 'tt.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('76', 'en-GB', 'English', 'United Kingdom', 'English (United Kingdom)', 'ltr', 'GBR', 'ENG', 'gb.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('77', 'en-US', 'English', 'United States', 'English (United States)', 'ltr', 'USA', 'ENU', 'us.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('78', 'en-ZW', 'English', 'Zimbabwe', 'English (Zimbabwe)', 'ltr', 'ZWE', 'ENW', 'zw.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('79', 'et-EE', 'Estonian', 'Estonia', 'eesti (Eesti)', 'ltr', 'EST', 'ETI', 'ee.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('80', 'fo-FO', 'Faroese', 'Faroe Islands', 'føroyskt (Føroyar)', 'ltr', 'FRO', 'FOS', 'fo.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('81', 'fil-PH', 'Filipino', 'Philippines', 'Filipino (Pilipinas)', 'ltr', 'PHL', 'FPO', 'ph.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('82', 'fi-FI', 'Finnish', 'Finland', 'suomi (Suomi)', 'ltr', 'FIN', 'FIN', 'fi.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('83', 'fr', 'French', NULL, 'français', 'ltr', 'FRA', 'FRA', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('84', 'fr-BE', 'French', 'Belgium', 'français (Belgique)', 'ltr', 'BEL', 'FRB', 'be.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('85', 'fr-CA', 'French', 'Canada', 'français (Canada)', 'ltr', 'CAN', 'FRC', 'ca.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('86', 'fr-FR', 'French', 'France', 'français (France)', 'ltr', 'FRA', 'FRA', 'fr.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('87', 'fr-LU', 'French', 'Luxembourg', 'français (Luxembourg)', 'ltr', 'LUX', 'FRL', 'lu.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('88', 'fr-MC', 'French', 'Monaco', 'français (Principauté de Monaco)', 'ltr', 'MCO', 'FRM', 'mc.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('89', 'fr-CH', 'French', 'Switzerland', 'français (Suisse)', 'ltr', 'CHE', 'FRS', 'ch.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('90', 'fy-NL', 'Frisian', 'Netherlands', 'Frysk (Nederlân)', 'ltr', 'NLD', 'FYN', 'nl.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('91', 'gl-ES', 'Galician', 'Galician', 'galego (galego)', 'ltr', 'ESP', 'GLC', 'es.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('92', 'ka-GE', 'Georgian', 'Georgia', 'ქართული (საქართველო)', 'ltr', 'GEO', 'KAT', 'ge.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('93', 'de', 'German', NULL, 'Deutsch', 'ltr', 'DEU', 'DEU', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('94', 'de-AT', 'German', 'Austria', 'Deutsch (Österreich)', 'ltr', 'AUT', 'DEA', 'at.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('95', 'de-DE', 'German', 'Germany', 'Deutsch (Deutschland)', 'ltr', 'DEU', 'DEU', 'de.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('96', 'de-LI', 'German', 'Liechtenstein', 'Deutsch (Liechtenstein)', 'ltr', 'LIE', 'DEC', 'li.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('97', 'de-LU', 'German', 'Luxembourg', 'Deutsch (Luxemburg)', 'ltr', 'LUX', 'DEL', 'lu.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('98', 'de-CH', 'German', 'Switzerland', 'Deutsch (Schweiz)', 'ltr', 'CHE', 'DES', 'ch.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('99', 'el-GR', 'Greek', 'Greece', 'Ελληνικά (Ελλάδα)', 'ltr', 'GRC', 'ELL', 'gr.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('100', 'kl-GL', 'Greenlandic', 'Greenland', 'kalaallisut (Kalaallit Nunaat)', 'ltr', 'GRL', 'KAL', 'gl.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('101', 'gu-IN', 'Gujarati', 'India', 'ગુજરાતી (ભારત)', 'ltr', 'IND', 'GUJ', 'in.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('102', 'ha', 'Hausa', NULL, 'Hausa', 'ltr', 'NGA', 'HAU', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('103', 'ha-Latn', 'Hausa', 'Latin', 'Hausa (Latin)', 'ltr', 'NGA', 'HAU', 'ng.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('104', 'ha-Latn-NG', 'Hausa', 'Latin, Nigeria', 'Hausa (Nigeria)', 'ltr', 'NGA', 'HAU', 'ng.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('105', 'he-IL', 'Hebrew', 'Israel', 'עברית (ישראל)‏', 'rtl', 'ISR', 'HEB', 'il.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('106', 'hi-IN', 'Hindi', 'India', 'हिंदी (भारत)', 'ltr', 'IND', 'HIN', 'in.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('107', 'hu-HU', 'Hungarian', 'Hungary', 'magyar (Magyarország)', 'ltr', 'HUN', 'HUN', 'hu.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('108', 'is-IS', 'Icelandic', 'Iceland', 'íslenska (Ísland)', 'ltr', 'ISL', 'ISL', 'is.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('109', 'ig-NG', 'Igbo', 'Nigeria', 'Igbo (Nigeria)', 'ltr', 'NGA', 'IBO', 'ng.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('110', 'id-ID', 'Indonesian', 'Indonesia', 'Bahasa Indonesia (Indonesia)', 'ltr', 'IDN', 'IND', 'id.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('111', 'iu', 'Inuktitut', NULL, 'Inuktitut', 'ltr', 'CAN', 'IUK', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('112', 'iu-Latn', 'Inuktitut', 'Latin', 'Inuktitut (Qaliujaaqpait)', 'ltr', 'CAN', 'IUK', 'ca.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('113', 'iu-Latn-CA', 'Inuktitut', 'Latin, Canada', 'Inuktitut', 'ltr', 'CAN', 'IUK', 'ca.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('114', 'iu-Cans', 'Inuktitut', 'Syllabics', 'ᐃᓄᒃᑎᑐᑦ (ᖃᓂᐅᔮᖅᐸᐃᑦ)', 'ltr', 'CAN', 'IUS', 'ca.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('115', 'iu-Cans-CA', 'Inuktitut', 'Syllabics, Canada', 'ᐃᓄᒃᑎᑐᑦ (ᑲᓇᑕᒥ)', 'ltr', 'CAN', 'IUS', 'ca.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('116', 'ga-IE', 'Irish', 'Ireland', 'Gaeilge (Éire)', 'ltr', 'IRL', 'IRE', 'ie.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('117', 'xh-ZA', 'isiXhosa', 'South Africa', 'isiXhosa (uMzantsi Afrika)', 'ltr', 'ZAF', 'XHO', 'za.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('118', 'zu-ZA', 'isiZulu', 'South Africa', 'isiZulu (iNingizimu Afrika)', 'ltr', 'ZAF', 'ZUL', 'za.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('119', 'it', 'Italian', NULL, 'italiano', 'ltr', 'ITA', 'ITA', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('120', 'it-IT', 'Italian', 'Italy', 'italiano (Italia)', 'ltr', 'ITA', 'ITA', 'it.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('121', 'it-CH', 'Italian', 'Switzerland', 'italiano (Svizzera)', 'ltr', 'CHE', 'ITS', 'ch.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('122', 'ja-JP', 'Japanese', 'Japan', '日本語 (日本)', 'ltr', 'JPN', 'JPN', 'jp.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('123', 'kn-IN', 'Kannada', 'India', 'ಕನ್ನಡ (ಭಾರತ)', 'ltr', 'IND', 'KDI', 'in.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('124', 'kk-KZ', 'Kazakh', 'Kazakhstan', 'Қазақ (Қазақстан)', 'rtl', 'KAZ', 'KKZ', 'kz.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('125', 'km-KH', 'Khmer', 'Cambodia', 'ខ្មែរ (កម្ពុជា)', 'ltr', 'KHM', 'KHM', 'kh.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('126', 'qut-GT', 'K''iche', 'Guatemala', 'K''iche (Guatemala)', 'ltr', 'GTM', 'QUT', 'gt.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('127', 'rw-RW', 'Kinyarwanda', 'Rwanda', 'Kinyarwanda (Rwanda)', 'ltr', 'RWA', 'KIN', 'rw.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('128', 'sw-KE', 'Kiswahili', 'Kenya', 'Kiswahili (Kenya)', 'ltr', 'KEN', 'SWK', 'ke.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('129', 'kok-IN', 'Konkani', 'India', 'कोंकणी (भारत)', 'ltr', 'IND', 'KNK', 'in.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('130', 'ko-KR', 'Korean', 'Korea', '한국어 (대한민국)', 'ltr', 'KOR', 'KOR', 'kr.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('131', 'ky-KG', 'Kyrgyz', 'Kyrgyzstan', 'Кыргыз (Кыргызстан)', 'ltr', 'KGZ', 'KYR', 'kg.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('132', 'lo-LA', 'Lao', 'Lao P.D.R.', 'ລາວ (ສ.ປ.ປ. ລາວ)', 'ltr', 'LAO', 'LAO', 'la.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('133', 'lv-LV', 'Latvian', 'Latvia', 'latviešu (Latvija)', 'ltr', 'LVA', 'LVI', 'lv.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('134', 'lt-LT', 'Lithuanian', 'Lithuania', 'lietuvių (Lietuva)', 'ltr', 'LTU', 'LTH', 'lt.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('135', 'dsb-DE', 'Lower Sorbian', 'Germany', 'dolnoserbšćina (Nimska)', 'ltr', 'GER', 'DSB', 'de.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('136', 'lb-LU', 'Luxembourgish', 'Luxembourg', 'Lëtzebuergesch (Luxembourg)', 'ltr', 'LUX', 'LBX', 'lu.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('137', 'mk-MK', 'Macedonian', 'Former Yugoslav Republic of Macedonia', 'македонски јазик (Македонија)', 'ltr', 'MKD', 'MKI', 'mk.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('138', 'mk', 'Macedonian', 'FYROM', 'македонски јазик', 'ltr', 'MKD', 'MKI', 'mk.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('139', 'ms', 'Malay', NULL, 'Bahasa Melayu', 'ltr', 'MYS', 'MSL', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('140', 'ms-BN', 'Malay', 'Brunei Darussalam', 'Bahasa Melayu (Brunei Darussalam)', 'ltr', 'BRN', 'MSB', 'bn.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('141', 'ms-MY', 'Malay', 'Malaysia', 'Bahasa Melayu (Malaysia)', 'ltr', 'MYS', 'MSL', 'my.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('142', 'ml-IN', 'Malayalam', 'India', 'മലയാളം (ഭാരതം)', 'rtl', 'IND', 'MYM', 'in.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('143', 'mt-MT', 'Maltese', 'Malta', 'Malti (Malta)', 'ltr', 'MLT', 'MLT', 'mt.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('144', 'mi-NZ', 'Maori', 'New Zealand', 'Reo Māori (Aotearoa)', 'ltr', 'NZL', 'MRI', 'nz.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('145', 'arn-CL', 'Mapudungun', 'Chile', 'Mapudungun (Chile)', 'ltr', 'CHL', 'MPD', 'cl.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('146', 'mr-IN', 'Marathi', 'India', 'मराठी (भारत)', 'ltr', 'IND', 'MAR', 'in.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('147', 'moh-CA', 'Mohawk', 'Mohawk', 'Kanien''kéha', 'ltr', 'CAN', 'MWK', 'ca.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('148', 'mn', 'Mongolian', 'Cyrillic', 'Монгол хэл', 'ltr', 'MNG', 'MNN', 'mn.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('149', 'mn-Cyrl', 'Mongolian', 'Cyrillic', 'Монгол хэл', 'ltr', 'MNG', 'MNN', 'mn.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('150', 'mn-MN', 'Mongolian', 'Cyrillic, Mongolia', 'Монгол хэл (Монгол улс)', 'ltr', 'MNG', 'MNN', 'mn.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('151', 'mn-Mong', 'Mongolian', 'Traditional Mongolian', 'ᠮᠤᠨᠭᠭᠤᠯ ᠬᠡᠯᠡ', 'ltr', 'CHN', 'MNG', 'cn.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('152', 'mn-Mong-CN', 'Mongolian', 'Traditional Mongolian, PRC', 'ᠮᠤᠨᠭᠭᠤᠯ ᠬᠡᠯᠡ (ᠪᠦᠭᠦᠳᠡ ᠨᠠᠢᠷᠠᠮᠳᠠᠬᠤ ᠳᠤᠮᠳᠠᠳᠤ ᠠᠷᠠᠳ ᠣᠯᠣᠰ)', 'ltr', 'CHN', 'MNG', 'cn.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('153', 'ne-NP', 'Nepali', 'Nepal', 'नेपाली (नेपाल)', 'ltr', 'NEP', 'NEP', 'np.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('154', 'no', 'Norwegian', NULL, 'norsk', 'ltr', 'NOR', 'NOR', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('155', 'nb', 'Norwegian', 'Bokmål', 'norsk (bokmål)', 'ltr', 'NOR', 'NOR', 'no.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('156', 'nn', 'Norwegian', 'Nynorsk', 'norsk (nynorsk)', 'ltr', 'NOR', 'NON', 'no.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('157', 'nb-NO', 'Norwegian, Bokmål', 'Norway', 'norsk, bokmål (Norge)', 'ltr', 'NOR', 'NOR', 'no.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('158', 'nn-NO', 'Norwegian, Nynorsk', 'Norway', 'norsk, nynorsk (Noreg)', 'ltr', 'NOR', 'NON', 'no.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('159', 'oc-FR', 'Occitan', 'France', 'Occitan (França)', 'ltr', 'FRA', 'OCI', 'fr.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('160', 'or-IN', 'Oriya', 'India', 'ଓଡ଼ିଆ (ଭାରତ)', 'ltr', 'IND', 'ORI', 'in.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('161', 'ps-AF', 'Pashto', 'Afghanistan', 'پښتو (افغانستان)‏', 'rtl', 'AFG', 'PAS', 'af.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('162', 'fa-IR', 'Persian‎', NULL, 'فارسى (ایران)‏', 'rtl', 'IRN', 'FAR', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('163', 'pl-PL', 'Polish', 'Poland', 'polski (Polska)', 'ltr', 'POL', 'PLK', 'pl.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('164', 'pt', 'Portuguese', NULL, 'Português', 'ltr', 'BRA', 'PTB', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('165', 'pt-BR', 'Portuguese', 'Brazil', 'Português (Brasil)', 'ltr', 'BRA', 'PTB', 'br.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('166', 'pt-PT', 'Portuguese', 'Portugal', 'português (Portugal)', 'ltr', 'PRT', 'PTG', 'pt.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('167', 'pa-IN', 'Punjabi', 'India', 'ਪੰਜਾਬੀ (ਭਾਰਤ)', 'rtl', 'IND', 'PAN', 'in.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('168', 'quz', 'Quechua', NULL, 'runasimi', 'ltr', 'BOL', 'QUB', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('169', 'quz-BO', 'Quechua', 'Bolivia', 'runasimi (Qullasuyu)', 'ltr', 'BOL', 'QUB', 'bo.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('170', 'quz-EC', 'Quechua', 'Ecuador', 'runasimi (Ecuador)', 'ltr', 'ECU', 'QUE', 'ec.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('171', 'quz-PE', 'Quechua', 'Peru', 'runasimi (Piruw)', 'ltr', 'PER', 'QUP', 'pe.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('172', 'ro-RO', 'Romanian', 'Romania', 'română (România)', 'ltr', 'ROM', 'ROM', 'ro.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('173', 'rm-CH', 'Romansh', 'Switzerland', 'Rumantsch (Svizra)', 'ltr', 'CHE', 'RMC', 'ch.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('174', 'ru-RU', 'Russian', 'Russia', 'русский (Россия)', 'ltr', 'RUS', 'RUS', 'ru.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('175', 'smn', 'Sami', 'Inari', 'sämikielâ', 'ltr', 'FIN', 'SMN', 'fi.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('176', 'smj', 'Sami', 'Lule', 'julevusámegiella', 'ltr', 'SWE', 'SMK', 'se.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('177', 'se', 'Sami', 'Northern', 'davvisámegiella', 'ltr', 'NOR', 'SME', 'no.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('178', 'sms', 'Sami', 'Skolt', 'sääm´ǩiõll', 'ltr', 'FIN', 'SMS', 'fi.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('179', 'sma', 'Sami', 'Southern', 'åarjelsaemiengiele', 'ltr', 'SWE', 'SMB', 'se.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('180', 'smn-FI', 'Sami, Inari', 'Finland', 'sämikielâ (Suomâ)', 'ltr', 'FIN', 'SMN', 'fi.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('181', 'smj-NO', 'Sami, Lule', 'Norway', 'julevusámegiella (Vuodna)', 'ltr', 'NOR', 'SMJ', 'no.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('182', 'smj-SE', 'Sami, Lule', 'Sweden', 'julevusámegiella (Svierik)', 'ltr', 'SWE', 'SMK', 'se.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('183', 'se-FI', 'Sami, Northern', 'Finland', 'davvisámegiella (Suopma)', 'ltr', 'FIN', 'SMG', 'fi.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('184', 'se-NO', 'Sami, Northern', 'Norway', 'davvisámegiella (Norga)', 'ltr', 'NOR', 'SME', 'no.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('185', 'se-SE', 'Sami, Northern', 'Sweden', 'davvisámegiella (Ruoŧŧa)', 'ltr', 'SWE', 'SMF', 'se.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('186', 'sms-FI', 'Sami, Skolt', 'Finland', 'sääm´ǩiõll (Lää´ddjânnam)', 'ltr', 'FIN', 'SMS', 'fi.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('187', 'sma-NO', 'Sami, Southern', 'Norway', 'åarjelsaemiengiele (Nöörje)', 'ltr', 'NOR', 'SMA', 'no.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('188', 'sma-SE', 'Sami, Southern', 'Sweden', 'åarjelsaemiengiele (Sveerje)', 'ltr', 'SWE', 'SMB', 'se.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('189', 'sa-IN', 'Sanskrit', 'India', 'संस्कृत (भारतम्)', 'ltr', 'IND', 'SAN', 'in.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('190', 'gd-GB', 'Scottish Gaelic', 'United Kingdom', 'Gàidhlig (An Rìoghachd Aonaichte)', 'ltr', 'GBR', 'GLA', 'gb.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('191', 'sr', 'Serbian', NULL, 'srpski', 'ltr', 'SRB', 'SRM', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('192', 'sr-Cyrl', 'Serbian', 'Cyrillic', 'српски (Ћирилица)', 'ltr', 'SRB', 'SRO', 'rs.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('193', 'sr-Cyrl-BA', 'Serbian', 'Cyrillic, Bosnia and Herzegovina', 'српски (Босна и Херцеговина)', 'ltr', 'BIH', 'SRN', 'ba.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('194', 'sr-Cyrl-ME', 'Serbian', 'Cyrillic, Montenegro', 'српски (Црна Гора)', 'ltr', 'MNE', 'SRQ', 'me.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('195', 'sr-Cyrl-CS', 'Serbian', 'Cyrillic, Serbia and Montenegro (Former)', 'српски (Србија и Црна Гора (Претходно))', 'ltr', 'SCG', 'SRB', 'rs.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('196', 'sr-Cyrl-RS', 'Serbian', 'Cyrillic, Serbia', 'српски (Србија)', 'ltr', 'SRB', 'SRO', 'rs.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('197', 'sr-Latn', 'Serbian', 'Latin', 'srpski (Latinica)', 'ltr', 'SRB', 'SRM', 'rs.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('198', 'sr-Latn-BA', 'Serbian', 'Latin, Bosnia and Herzegovina', 'srpski (Bosna i Hercegovina)', 'ltr', 'BIH', 'SRS', 'ba.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('199', 'sr-Latn-ME', 'Serbian', 'Latin, Montenegro', 'srpski (Crna Gora)', 'ltr', 'MNE', 'SRP', 'me.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('200', 'sr-Latn-CS', 'Serbian', 'Latin, Serbia and Montenegro (Former)', 'srpski (Srbija i Crna Gora (Prethodno))', 'ltr', 'SCG', 'SRL', 'rs.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('201', 'sr-Latn-RS', 'Serbian', 'Latin, Serbia', 'srpski (Srbija)', 'ltr', 'SRB', 'SRM', 'rs.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('202', 'nso-ZA', 'Sesotho sa Leboa', 'South Africa', 'Sesotho sa Leboa (Afrika Borwa)', 'ltr', 'ZAF', 'NSO', 'za.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('203', 'tn-ZA', 'Setswana', 'South Africa', 'Setswana (Aforika Borwa)', 'ltr', 'ZAF', 'TSN', 'za.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('204', 'si-LK', 'Sinhala', 'Sri Lanka', 'සිංහ (ශ්‍රී ලංකා)', 'ltr', 'LKA', 'SIN', 'lk.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('205', 'sk-SK', 'Slovak', 'Slovakia', 'slovenčina (Slovenská republika)', 'ltr', 'SVK', 'SKY', 'sk.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('206', 'sl-SI', 'Slovenian', 'Slovenia', 'slovenski (Slovenija)', 'ltr', 'SVN', 'SLV', 'si.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('207', 'es', 'Spanish', NULL, 'español', 'ltr', 'ESP', 'ESN', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('208', 'es-AR', 'Spanish', 'Argentina', 'Español (Argentina)', 'ltr', 'ARG', 'ESS', 'ar.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('209', 'es-BO', 'Spanish', 'Bolivia', 'Español (Bolivia)', 'ltr', 'BOL', 'ESB', 'bo.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('210', 'es-CL', 'Spanish', 'Chile', 'Español (Chile)', 'ltr', 'CHL', 'ESL', 'cl.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('211', 'es-CO', 'Spanish', 'Colombia', 'Español (Colombia)', 'ltr', 'COL', 'ESO', 'co.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('212', 'es-CR', 'Spanish', 'Costa Rica', 'Español (Costa Rica)', 'ltr', 'CRI', 'ESC', 'cr.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('213', 'es-DO', 'Spanish', 'Dominican Republic', 'Español (República Dominicana)', 'ltr', 'DOM', 'ESD', 'do.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('214', 'es-EC', 'Spanish', 'Ecuador', 'Español (Ecuador)', 'ltr', 'ECU', 'ESF', 'ec.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('215', 'es-SV', 'Spanish', 'El Salvador', 'Español (El Salvador)', 'ltr', 'SLV', 'ESE', 'sv.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('216', 'es-GT', 'Spanish', 'Guatemala', 'Español (Guatemala)', 'ltr', 'GTM', 'ESG', 'gt.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('217', 'es-HN', 'Spanish', 'Honduras', 'Español (Honduras)', 'ltr', 'HND', 'ESH', 'hn.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('218', 'es-MX', 'Spanish', 'Mexico', 'Español (México)', 'ltr', 'MEX', 'ESM', 'mx.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('219', 'es-NI', 'Spanish', 'Nicaragua', 'Español (Nicaragua)', 'ltr', 'NIC', 'ESI', 'ni.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('220', 'es-PA', 'Spanish', 'Panama', 'Español (Panamá)', 'ltr', 'PAN', 'ESA', 'pa.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('221', 'es-PY', 'Spanish', 'Paraguay', 'Español (Paraguay)', 'ltr', 'PRY', 'ESZ', 'py.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('222', 'es-PE', 'Spanish', 'Peru', 'Español (Perú)', 'ltr', 'PER', 'ESR', 'pe.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('223', 'es-PR', 'Spanish', 'Puerto Rico', 'Español (Puerto Rico)', 'ltr', 'PRI', 'ESU', 'pr.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('224', 'es-ES', 'Spanish', 'Spain, International Sort', 'Español (España, alfabetización internacional)', 'ltr', 'ESP', 'ESN', 'es.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('225', 'es-US', 'Spanish', 'United States', 'Español (Estados Unidos)', 'ltr', 'USA', 'EST', 'us.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('226', 'es-UY', 'Spanish', 'Uruguay', 'Español (Uruguay)', 'ltr', 'URY', 'ESY', 'uy.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('227', 'es-VE', 'Spanish', 'Venezuela', 'Español (Republica Bolivariana de Venezuela)', 'ltr', 'VEN', 'ESV', 've.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('228', 'sv', 'Swedish', NULL, 'svenska', 'ltr', 'SWE', 'SVE', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('229', 'sv-FI', 'Swedish', 'Finland', 'svenska (Finland)', 'ltr', 'FIN', 'SVF', 'fi.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('230', 'sv-SE', 'Swedish', 'Sweden', 'svenska (Sverige)', 'ltr', 'SWE', 'SVE', 'se.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('231', 'syr-SY', 'Syriac', 'Syria', 'ܣܘܪܝܝܐ (سوريا)‏', 'rtl', 'SYR', 'SYR', 'sy.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('232', 'tg', 'Tajik', 'Cyrillic', 'Тоҷикӣ', 'ltr', 'TAJ', 'TAJ', 'tj.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('233', 'tg-Cyrl', 'Tajik', 'Cyrillic', 'Тоҷикӣ', 'ltr', 'TAJ', 'TAJ', 'tj.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('234', 'tg-Cyrl-TJ', 'Tajik', 'Cyrillic, Tajikistan', 'Тоҷикӣ (Тоҷикистон)', 'ltr', 'TAJ', 'TAJ', 'tj.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('235', 'tzm', 'Tamazight', NULL, 'Tamazight', 'ltr', 'DZA', 'TZM', 'empty.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('236', 'tzm-Latn', 'Tamazight', 'Latin', 'Tamazight (Latin)', 'ltr', 'DZA', 'TZM', 'dz.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('237', 'tzm-Latn-DZ', 'Tamazight', 'Latin, Algeria', 'Tamazight (Djazaïr)', 'ltr', 'DZA', 'TZM', 'dz.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('238', 'ta-IN', 'Tamil', 'India', 'தமிழ் (இந்தியா)', 'ltr', 'IND', 'TAM', 'in.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('239', 'tt-RU', 'Tatar', 'Russia', 'Татар (Россия)', 'ltr', 'RUS', 'TTT', 'ru.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('240', 'te-IN', 'Telugu', 'India', 'తెలుగు (భారత దేశం)', 'ltr', 'IND', 'TEL', 'in.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('241', 'th-TH', 'Thai', 'Thailand', 'ไทย (ไทย)', 'ltr', 'THA', 'THA', 'th.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('242', 'bo-CN', 'Tibetan', 'PRC', 'བོད་ཡིག (ཀྲུང་ཧྭ་མི་དམངས་སྤྱི་མཐུན་རྒྱལ་ཁབ།)', 'ltr', 'CHN', 'BOB', 'cn.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('243', 'tr-TR', 'Turkish', 'Turkey', 'Türkçe (Türkiye)', 'ltr', 'TUR', 'TRK', 'tr.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('244', 'tk-TM', 'Turkmen', 'Turkmenistan', 'türkmençe (Türkmenistan)', 'rtl', 'TKM', 'TUK', 'tm.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('245', 'uk-UA', 'Ukrainian', 'Ukraine', 'українська (Україна)', 'ltr', 'UKR', 'UKR', 'ua.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('246', 'hsb-DE', 'Upper Sorbian', 'Germany', 'hornjoserbšćina (Němska)', 'ltr', 'GER', 'HSB', 'de.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('247', 'ur-PK', 'Urdu', 'Islamic Republic of Pakistan', 'اُردو (پاکستان)‏', 'rtl', 'PAK', 'URD', 'pk.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('248', 'ug-CN', 'Uyghur', 'PRC', '(ئۇيغۇر يېزىقى (جۇڭخۇا خەلق جۇمھۇرىيىتى‏', 'rtl', 'CHN', 'UIG', 'cn.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('249', 'uz-Cyrl', 'Uzbek', 'Cyrillic', 'Ўзбек', 'ltr', 'UZB', 'UZB', 'uz.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('250', 'uz-Cyrl-UZ', 'Uzbek', 'Cyrillic, Uzbekistan', 'Ўзбек (Ўзбекистон)', 'ltr', 'UZB', 'UZB', 'uz.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('251', 'uz', 'Uzbek', 'Latin', 'U''zbek', 'ltr', 'UZB', 'UZB', 'uz.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('252', 'uz-Latn', 'Uzbek', 'Latin', 'U''zbek', 'ltr', 'UZB', 'UZB', 'uz.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('253', 'uz-Latn-UZ', 'Uzbek', 'Latin, Uzbekistan', 'U''zbek (U''zbekiston Respublikasi)', 'ltr', 'UZB', 'UZB', 'uz.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('254', 'vi-VN', 'Vietnamese', 'Vietnam', 'Tiếng Việt (Việt Nam)', 'ltr', 'VNM', 'VIT', 'vn.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('255', 'cy-GB', 'Welsh', 'United Kingdom', 'Cymraeg (y Deyrnas Unedig)', 'ltr', 'GBR', 'CYM', 'gb.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('256', 'wo-SN', 'Wolof', 'Senegal', 'Wolof (Sénégal)', 'ltr', 'SEN', 'WOL', 'sn.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('257', 'sah-RU', 'Yakut', 'Russia', 'саха (Россия)', 'ltr', 'RUS', 'SAH', 'ru.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('258', 'ii-CN', 'Yi', 'PRC', 'ꆈꌠꁱꂷ (ꍏꉸꏓꂱꇭꉼꇩ)', 'ltr', 'CHN', 'III', 'cn.png');
INSERT INTO `restaurantbooking_plugin_locale_languages` (`id`, `iso`, `title`, `region`, `native`, `dir`, `country_abbr`, `language_abbr`, `file`) VALUES('259', 'yo-NG', 'Yoruba', 'Nigeria', 'Yoruba (Nigeria)', 'ltr', 'NGA', 'YOR', 'ng.png');

DROP TABLE IF EXISTS `restaurantbooking_plugin_locale`;

CREATE TABLE `restaurantbooking_plugin_locale` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `language_iso` varchar(20) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `flag` varchar(255) DEFAULT NULL,
  `dir` enum('ltr','rtl') DEFAULT 'ltr',
  `sort` int(10) unsigned DEFAULT NULL,
  `is_default` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `language_iso` (`language_iso`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `restaurantbooking_plugin_locale` (`id`, `language_iso`, `name`, `flag`, `dir`, `sort`, `is_default`) VALUES('1', 'en-GB', 'English (United Kingdom)', NULL, 'ltr', '1', '0');
INSERT INTO `restaurantbooking_plugin_locale` (`id`, `language_iso`, `name`, `flag`, `dir`, `sort`, `is_default`) VALUES('2', 'it-IT', 'italiano (Italia)', NULL, 'ltr', '2', '1');

DROP TABLE IF EXISTS `restaurantbooking_plugin_paypal`;

CREATE TABLE `restaurantbooking_plugin_paypal` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `subscr_id` varchar(25) DEFAULT NULL,
  `txn_id` varchar(25) DEFAULT NULL,
  `txn_type` varchar(50) DEFAULT NULL,
  `mc_gross` decimal(9,2) unsigned DEFAULT NULL,
  `mc_currency` varchar(3) DEFAULT NULL,
  `payer_email` varchar(255) DEFAULT NULL,
  `dt` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fid` (`foreign_id`,`subscr_id`,`txn_id`,`txn_type`),
  UNIQUE KEY `txn_id` (`txn_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `restaurantbooking_plugin_one_admin`;

CREATE TABLE `restaurantbooking_plugin_one_admin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `restaurantbooking_plugin_log`;

CREATE TABLE `restaurantbooking_plugin_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) DEFAULT NULL,
  `function` varchar(255) DEFAULT NULL,
  `value` text,
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `restaurantbooking_plugin_log_config`;

CREATE TABLE `restaurantbooking_plugin_log_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


