var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var validator,
			$frmCreateBooking = $('#frmCreateBooking'),
			$frmUpdateBooking = $('#frmUpdateBooking'),
			$dialogCancellation = $("#dialogCancellation"),
			$dialogConfirmation = $("#dialogConfirmation"),
			dialog = ($.fn.dialog !== undefined),
			datepicker = ($.fn.datepicker !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			spinner = ($.fn.spinner !== undefined),
			chosen = ($.fn.chosen !== undefined),
			keyPressTimeout,
			tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs"),
			tOpt = {
				select: function (event, ui) {
					$(":input[name='tab_id']").val(ui.panel.id);
				}
			};
	
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs(tOpt);
		}
		$(".field-int").spinner({
			min: 0
		});
		if (chosen) {
			$("#c_country").chosen();
		}
		function showSchedule()
		{
			var number_rows = $('.dTable tr').length - 1;
			for(var i = 0; i < number_rows; i ++)
			{
				var headCol_height = $('#dHeadCol_' + i).height();
				var max_height = headCol_height;
				$('#dHeadCol_' + i).each(function( index ) {
					var cell_height = $( this ).height();
					if(cell_height > max_height)
					{
						max_height = cell_height;
					}
				});
				$('#dHeadCol_' + i).height(max_height);
				$('.dSlot_' + i).height(max_height);
			}
		}
		function changeValidate()
		{
			 var rand = Math.ceil(Math.random() * 999999);
			 $("#validate_datetime").val(rand);
		}
		function validateTable()
		{
			var valid = false;
			$( ".rbTable" ).each(function(){
				if($(this).val() != '')
				{
					valid = true;
				}
			});
			if(valid == true)
			{
				var rand = Math.ceil(Math.random() * 999999);
				 $("#validate_table").val(rand).valid();
			}else{
				$("#validate_table").val("");
			}
		}
		if($('.boxScheduleOuter').length > 0)
		{
			showSchedule();
		}
		
		if ($frmCreateBooking.length > 0 || $frmUpdateBooking.length > 0) {
			$frmCreateBooking.validate({
				rules: {
					"uuid": {
						remote: "index.php?controller=pjAdminBookings&action=pjActionCheckUID"
					},
					"validate_datetime":{
						remote: {
							url: "index.php?controller=pjAdminBookings&action=pjActionCheckDate",
							type: "post",
							data: {
								date: function() {
									return $( "#date" ).val();
								},
								hour: function() {
									return $( "#hour" ).val();
								},
								minute: function() {
									return $( "#minute" ).val();
								},
								ampm: function() {
									if($( "#ampm" ).length > 0)
									{
										return $( "#ampm" ).val();
									}else{
										return '';
									}
								},
								date_to: function() {
									return $( "#date_to" ).val();
								},
								hour_to: function() {
									return $( "#hour_to" ).val();
								},
								minute_to: function() {
									return $( "#minute_to" ).val();
								},
								ampm_to: function() {
									if($( "#ampm_to" ).length > 0)
									{
										return $( "#ampm_to" ).val();
									}else{
										return '';
									}
								}
							}
						}
					}
				},
				messages: {
					"uuid": {
						remote: myLabel.uuid_used
					},
					"validate_datetime": {
						remote: myLabel.validate_datetime
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {
				    if (validator.numberOfInvalids()) {
				    	var index = $(validator.errorList[0].element, this).closest("div[id^='tabs-']").index();
				    	if ($tabs.length > 0 && tabs && index !== -1) {
				    		$tabs.tabs(tOpt).tabs("option", "active", index-1);
				    	}
				    };
				}
			});
			$frmUpdateBooking.validate({
				rules: {
					"uuid": {
						remote: "index.php?controller=pjAdminBookings&action=pjActionCheckUID&id=" + $frmUpdateBooking.find("input[name='id']").val()
					},
					"validate_datetime":{
						remote: {
							url: "index.php?controller=pjAdminBookings&action=pjActionCheckDate",
							type: "post",
							data: {
								date: function() {
									return $( "#date" ).val();
								},
								hour: function() {
									return $( "#hour" ).val();
								},
								minute: function() {
									return $( "#minute" ).val();
								},
								ampm: function() {
									if($( "#ampm" ).length > 0)
									{
										return $( "#ampm" ).val();
									}else{
										return '';
									}
								},
								date_to: function() {
									return $( "#date_to" ).val();
								},
								hour_to: function() {
									return $( "#hour_to" ).val();
								},
								minute_to: function() {
									return $( "#minute_to" ).val();
								},
								ampm_to: function() {
									if($( "#ampm_to" ).length > 0)
									{
										return $( "#ampm_to" ).val();
									}else{
										return '';
									}
								}
							}
						}
					}
				},
				messages: {
					"uuid": {
						remote: myLabel.uuid_used
					},
					"validate_datetime": {
						remote: myLabel.validate_datetime
					},
					"validate_table": {
						remote: myLabel.validate_table
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {
				    if (validator.numberOfInvalids()) {
				    	var index = $(validator.errorList[0].element, this).closest("div[id^='tabs-']").index();
				    	if ($tabs.length > 0 && tabs && index !== -1) {
				    		$tabs.tabs(tOpt).tabs("option", "active", index-1);
				    	}
				    };
				}
			});
			$("#status, #is_paid").buttonset();
		}
		
		function getSchedule(dateText) {
			$('#pj_schedule_loader').css('display', 'block');
			$.get("index.php?controller=pjAdminBookings&action=pjActionGetSchedule", {
				date: dateText
			}).done(function (data) {
				$("#boxSchedule").html(data);
				showSchedule();
				$('#pj_schedule_loader').css('display', 'none');
			});
		}
		
		function getPaper(dateText) {
			$.get("index.php?controller=pjAdminBookings&action=pjActionGetPaper", {
				date: dateText
			}).done(function (data) {
				$("#boxPaper").html(data);
			});
		}
		function addPromo(frm)
		{
			if($('#code').val() != '')
			{
				$.post("index.php?controller=pjAdminBookings&action=pjActionAddPromo", frm.serialize()).done(function (data) {
					$('#total').val(data.total);
					if(data.discount != '')
					{
						$('#discount_format').html(data.discount);
						$('#discount_format').css('display', 'block');
					}else{
						$('#discount_format').html('');
						$('#discount_format').css('display', 'none');
					}
				});
			}
		}
		if ($("#grid").length > 0 && datagrid) {
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminBookings&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminBookings&action=pjActionDeleteBooking&id={:id}"}
						  ],
				columns: [
				          {text: myLabel.from_datetime, type: "text", sortable: true, editable: false, width:150},
				          {text: myLabel.name, type: "text", sortable: true, width:150},
				          {text: myLabel.email, type: "text", sortable: true, editable: false, width:180},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 120, options: [
				                                                                                     {label: myLabel.pending, value: "pending"}, 
				                                                                                     {label: myLabel.confirmed, value: "confirmed"},
				                                                                                     {label: myLabel.cancelled, value: "cancelled"},
				                                                                                     {label: myLabel.enquiry, value: "enquiry"}
				                                                                                     ], applyClass: "pj-status"}],
				dataUrl: "index.php?controller=pjAdminBookings&action=pjActionGetBooking" + pjGrid.queryString,
				dataType: "json",
				fields: ['dt', 'full_name', 'c_email', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminBookings&action=pjActionDeleteBookingBulk", render: true, confirmation: myLabel.delete_confirmation},
					   {text: myLabel.exported, url: "index.php?controller=pjAdminBookings&action=pjActionExportBooking", ajax: false}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminBookings&action=pjActionSaveBooking&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		function DisableSpecificDates(date) 
		{
			var m = date.getMonth();
			var d = date.getDate();
			var y = date.getFullYear();
			var day = date.getDay();
			var currentdate = (m + 1) + '-' + d + '-' + y ;
			if ($.inArray(currentdate, disabledDates) != -1 ) {
				return [false];
			}
			if ($.inArray(currentdate, enabledDates) != -1 ) {
				return [true];
			}
			if ($.inArray(day, disabledWeekDays) != -1 ) {
				return [false];
			}
			return [true];
		}		
		$(document).on("focusin", ".datepick", function (e) {
			var $this = $(this);
			var custom = {};
			var opt = {
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev"),
					onSelect: function (dateText, inst) {
						if($this.attr("id") == 'schedule_date'){
							getSchedule(dateText);
							var print_href = $this.attr('data-href');
							print_href = print_href.replace("[DATE]", dateText);
							$('.btnPrint').attr('href', print_href);
						}
						if($this.attr("id") == 'paper_date'){
							getPaper(dateText);
						}
						if($this.attr("id") == 'date'){
							if($frmUpdateBooking.length > 0)
							{
								addPromo($frmUpdateBooking);
								changeValidate();
							}
							if($frmCreateBooking.length > 0)
							{
								addPromo($frmCreateBooking);
								changeValidate();
							}
							$('#tblBookingTables').find('tbody').html("");
						}
						if($this.attr("id") == 'date_to'){
							if($frmUpdateBooking.length > 0)
							{
								changeValidate();
							}
							if($frmCreateBooking.length > 0)
							{
								changeValidate();
							}
						}
					}
				};
			if ($frmCreateBooking.length > 0 || $frmUpdateBooking.length > 0 || $('#boxSchedule').length > 0) 
			{
				custom.beforeShowDay = DisableSpecificDates;
			}
			if ($frmCreateBooking.length > 0 || $('#boxSchedule').length > 0) 
			{
				custom.minDate = 0;
			}
			$this.datepicker($.extend(opt, custom));
		}).on("click", ".pj-form-field-icon-date", function (e) {
			var $dp = $(this).parent().siblings("input[type='text']");
			if ($dp.hasClass("hasDatepicker")) {
				$dp.datepicker("show");
			} else {
				$dp.trigger("focusin").datepicker("show");
			}
		}).on("click", ".pj-button-detailed, .pj-button-detailed-arrow", function (e) {
			e.stopPropagation();
			$(".pj-form-filter-advanced").toggle();
		}).on("submit", ".frm-filter-advanced", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var obj = {},
				$this = $(this),
				arr = $this.serializeArray(),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			for (var i = 0, iCnt = arr.length; i < iCnt; i++) {
				obj[arr[i].name] = arr[i].value;
			}
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminBookings&action=pjActionGetBooking", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("reset", ".frm-filter-advanced", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(".pj-button-detailed").trigger("click");
			
			$("#date_from").val('');
			$("#date_to").val('');
			$('#table_id').val('');
			$('#email').val('');
			$('#name').val('');
			$('#phone').val('');
		}).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: "",
				date_from: "",
				date_to: "",
				table_id: "",
				name: "",
				phone: "",
				email: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminBookings&action=pjActionGetBooking", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminBookings&action=pjActionGetBooking", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val(),
				date_from: "",
				date_to: "",
				table_id: "",
				name: "",
				phone: "",
				email: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminBookings&action=pjActionGetBooking", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("change", "#payment_method", function (e) {
			switch ($("option:selected", this).val()) {
				case 'creditcard':
					$(".boxCC").show();
					break;
				default:
					$(".boxCC").hide();
			}
		}).on("click", ".btnRemoveTable", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).parent().parent().remove();
			validateTable();
			return false;
		}).on("click", ".btnAddTable", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if($frmCreateBooking.length > 0){
				$.post("index.php?controller=pjAdminBookings&action=pjActionGetTables", $frmCreateBooking.serialize()).done(function (data) {
					$("tbody", $("#tblBookingTables")).append(data);
				});
			}
			if($frmUpdateBooking.length > 0){
				$.post("index.php?controller=pjAdminBookings&action=pjActionGetTables", $frmUpdateBooking.serialize()).done(function (data) {
					$("tbody", $("#tblBookingTables")).append(data);
				});
			}
			return false;
		}).on("click", ".btnFilter", function (e) {
			var dateText = $(this).attr('rev'),
				print_href = $(this).attr('data-href');
			$('#schedule_date').val(dateText);
			print_href = print_href.replace("[DATE]", dateText);
			$('.btnPrint').attr('href', print_href);
			getSchedule(dateText);
		}).on("keydown", "#code", function (e) {
			if($frmCreateBooking.length > 0)
			{
				clearTimeout(keyPressTimeout);
				keyPressTimeout = setTimeout( function() {
					addPromo($frmCreateBooking);
		        },500);
				
			}
			if($frmUpdateBooking.length > 0)
			{
				clearTimeout(keyPressTimeout);
				keyPressTimeout = setTimeout( function() {
					addPromo($frmUpdateBooking);
		        },500);
			}
		}).on("change", ".pj-booking-time", function (e) {
			if($frmCreateBooking.length > 0)
			{
				addPromo($frmCreateBooking);
			}
			if($frmUpdateBooking.length > 0)
			{
				addPromo($frmUpdateBooking);
			}
			if($(this).attr('id') == 'hour' || $(this).attr('id') == 'minute' || $(this).attr('id') == 'ampm'){
				$('#tblBookingTables').find('tbody').html("");
			}
		}).on("change", "#hour, #minute, #ampm, #hour_to, #minute_to, #ampm_to", function (e) {
			changeValidate();
		}).on("change", ".rbTable", function (e) {
			changeValidate();
			validateTable();
		}).on("click", ".pjRbSendCancel", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$dialogCancellation.data('id', $(this).attr('data-id')).dialog('open');
		}).on("click", ".pjRbSendConfirm", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$dialogConfirmation.data('id', $(this).attr('data-id')).dialog('open');
		});
		if($('#tmp_table_id').length > 0 && $frmCreateBooking.length > 0)
		{
			var $tbody = $("tbody", $("#tblBookingTables"));
			$.post("index.php?controller=pjAdminBookings&action=pjActionGetTables", $frmCreateBooking.serialize()).done(function (data) {
				$tbody.append(data);
				var $firstRow = $tbody.find('tr:eq(0)');
				var $select = $firstRow.find('select:eq(0)');
				$select.val($('#tmp_table_id').val());
				var rand = Math.ceil(Math.random() * 999999);
				$("#validate_table").val(rand);
			});
			
		}
		function attachTinyMce(options) {
			if (window.tinymce !== undefined) {
				tinymce.EditorManager.editors = [];
				var defaults = {
					selector: "textarea.mceEditor",
					theme: "modern",
					width: 610,
					height: 330,
					plugins: [
				         "advlist autolink link image lists charmap print preview hr anchor pagebreak",
				         "searchreplace visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
				         "save table contextmenu directionality emoticons template paste textcolor"
				    ],
				    toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | print preview media fullpage | forecolor backcolor emoticons"
				};
				
				var settings = $.extend({}, defaults, options);
				
				tinymce.init(settings);
			}
		}
		if ($dialogConfirmation.length > 0 && dialog) {
			$dialogConfirmation.dialog({
				autoOpen: false,
				draggable: false,
				resizable: false,
				modal: true,
				width: 645,
				open: function () {
					$dialogConfirmation.html("");
					$dialogCancellation.html("");
					$.get("index.php?controller=pjAdminBookings&action=pjActionConfirmation", {
						"booking_id": $dialogConfirmation.data('id')
					}).done(function (data) {
						$dialogConfirmation.html(data);
						validator = $dialogConfirmation.find("form").validate({
							
						});
						$dialogConfirmation.dialog("option", "position", "center");
						attachTinyMce.call(null);
					});
				},
				buttons: (function () {
					var buttons = {};
					buttons[rbApp.locale.button.send] = function () {
						tinymce.get("confirm_message").save();
						var dialogButtons = $('.ui-dialog-buttonpane button');
						dialogButtons.prop('disabled', true).addClass("ui-state-disabled");
						if (validator.form()) {
							$.post("index.php?controller=pjAdminBookings&action=pjActionConfirmation", $dialogConfirmation.find("form").serialize()).done(function (data) {
								dialogButtons.prop('disabled', false).removeClass("ui-state-disabled");
								$dialogConfirmation.dialog("close");
							})
						}
					};
					buttons[rbApp.locale.button.cancel] = function () {
						var dialogButtons = $('.ui-dialog-buttonpane button');
						dialogButtons.prop('disabled', false).removeClass("ui-state-disabled");
						$dialogConfirmation.dialog("close");
					};
					
					return buttons;
				})()
			});
		}
		if ($dialogCancellation.length > 0 && dialog) {
			$dialogCancellation.dialog({
				autoOpen: false,
				draggable: false,
				resizable: false,
				modal: true,
				width: 645,
				open: function () {
					$dialogConfirmation.html("");
					$dialogCancellation.html("");
					$.get("index.php?controller=pjAdminBookings&action=pjActionCancellation", {
						"booking_id": $dialogCancellation.data('id')
					}).done(function (data) {
						$dialogCancellation.html(data);
						validator = $dialogCancellation.find("form").validate({
							
						});
						$dialogCancellation.dialog("option", "position", "center");
						attachTinyMce.call(null);
					});
				},
				buttons: (function () {
					var buttons = {};
					buttons[rbApp.locale.button.send] = function () {
						tinymce.get("confirm_message").save();
						var dialogButtons = $('.ui-dialog-buttonpane button');
						dialogButtons.prop('disabled', true).addClass("ui-state-disabled");
						if (validator.form()) {
							$.post("index.php?controller=pjAdminBookings&action=pjActionCancellation", $dialogCancellation.find("form").serialize()).done(function (data) {
								dialogButtons.prop('disabled', false).removeClass("ui-state-disabled");
								$dialogCancellation.dialog("close");
							})
						}
					};
					buttons[rbApp.locale.button.cancel] = function () {
						var dialogButtons = $('.ui-dialog-buttonpane button');
						dialogButtons.prop('disabled', false).removeClass("ui-state-disabled");
						$dialogCancellation.dialog("close");
					};
					
					return buttons;
				})()
			});
		}
	});
})(jQuery_1_8_2);