var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var tOpts = {},
			$frmCreateTable = $("#frmCreateTable"),
			$frmUpdateTable = $("#frmUpdateTable"),
			datagrid = ($.fn.datagrid !== undefined),
			tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs");

		if ($tabs.length > 0 && tabs) {
			$tabs.tabs();
		}
		$(".field-int").spinner({
			min: 0
		});
		$.validator.addMethod('validateMinimum',
			    function (value) { 
					var capacity = parseInt($('#seats').val(), 10),
						value = parseInt(value, 10);
					if(value > capacity)
					{
						return false;
					}else{
						return true;
					}
			    }, myLabel.validate_minimum);
		
		if ($frmCreateTable.length > 0) {
			$frmCreateTable.validate({
				rules: {
					"name": {
						required: true,
						remote: "index.php?controller=pjAdminTables&action=pjActionCheckName"
					},
					"minimum": {
						validateMinimum: true
					}
				},
				messages: {
					"name": {
						remote: myLabel.name_exist
					},
					"minimum": {
						validateMinimum: myLabel.validate_minimum
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		
		if ($frmUpdateTable.length > 0) {
			$frmUpdateTable.validate({
				rules: {
					"name": {
						required: true,
						remote: "index.php?controller=pjAdminTables&action=pjActionCheckName&id=" + $frmUpdateTable.find("input[name='id']").val()
					},
					"minimum": {
						validateMinimum: true
					}
				},
				messages: {
					"name": {
						remote: myLabel.name_exist
					},
					"minimum": {
						validateMinimum: myLabel.validate_minimum
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		
		if ($("#grid").length > 0 && datagrid) {
			
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminTables&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminTables&action=pjActionDeleteTable&id={:id}"}
				          ],
				columns: [{text: myLabel.name, type: "text", sortable: true, editable: true, width: 300},
				          {text: myLabel.mininum, type: "text", sortable: true, editable: true, width: 160},
				          {text: myLabel.capacity, type: "text", sortable: true, editable: true}],
				dataUrl: "index.php?controller=pjAdminTables&action=pjActionGetTable",
				dataType: "json",
				fields: ['name', 'minimum', 'seats'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminTables&action=pjActionDeleteTableBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminTables&action=pjActionSaveTable&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
	});
})(jQuery_1_8_2);